﻿<%@ Page Title="Crystal Report Export Options" Language="vb" AutoEventWireup="false" CodeBehind="CustomExportOptions.aspx.vb" Inherits="RSWebApp.CustomExportOptions" %>

<%@ Register Assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>
<%@ Register Src="StyleLink.ascx" TagName="StyleLink" TagPrefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Crystal Report Export Options</title>
    <uc1:stylelink id="StyleLink1" runat="server" />
    <script src="Scripts/jquery-2.1.4.js" type="text/javascript"></script>
    <script language="JavaScript" type="text/javascript" src="RipplestoneCommon.js"></script>
    <script language="JavaScript" type="text/javascript" src="selectbox.js"></script>
    <style type="text/css">
        .edInline
        {
            display: inline-table;
        }
	</style>
    <script type="text/javascript">
        function SetExportPanel(s) {
            var cboValue = s.GetValue();

            if (cboValue == null) // Nothing Selected
            {
                pnlExcel.SetVisible(false);
                pnlCSV.SetVisible(false);
                pnlPDF.SetVisible(false);
            }

            if (cboValue == "Excel")
            {
                pnlExcel.SetVisible(true);
                pnlCSV.SetVisible(false);
                pnlPDF.SetVisible(false);
            }

            if (cboValue == "CSV")
            {
                pnlExcel.SetVisible(false);
                pnlCSV.SetVisible(true);
                pnlPDF.SetVisible(false);
            }

            if (cboValue == "PDF")
            {
                pnlExcel.SetVisible(false);
                pnlCSV.SetVisible(false);
                pnlPDF.SetVisible(true);
            }
        }
        function setReportIsolate(s) {
            if (s == "enable")
            {
                chkCSVReportIsolate.SetEnabled(true);
            }
            else{
                chkCSVReportIsolate.SetEnabled(false);
            }
        }
        function setGroupIsolate(s) {
            if (s == "enable") {
                chkCSVGroupIsolate.SetEnabled(true);
            }
            else {
                chkCSVGroupIsolate.SetEnabled(false);
            }
        }
        function setPDFPageRange(s) {
            if (s == "enable") {
                txtPDFPageRangeFrom.SetEnabled(false);
                txtPDFPageRangeTo.SetEnabled(false);
            }
            else {
                txtPDFPageRangeFrom.SetEnabled(true);
                txtPDFPageRangeTo.SetEnabled(true);
            }
        }
        function setExcelColumnWidth(s) {
            if (s == "enable") {
                excelAreaType.SetEnabled(true)
                spinConstantColumnWidth.SetEnabled(false);
            }
            else {
                excelAreaType.SetEnabled(false)
                spinConstantColumnWidth.SetEnabled(true);
            }
        }
		function closeWindow() {
			window.close();
		}
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div style="padding-bottom:25px; padding-left:10px;">
            <h1>Custom Export Options</h1>
            <p>
                <br />
                <dx:ASPxLabel ID="lblHeader" runat="server" Text="Use the options below to customize the export file">
                </dx:ASPxLabel>
                <br /><br />File Type: 
                <dx:ASPxComboBox ID="cboExportType" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="exportType">
                    <ClientSideEvents SelectedIndexChanged="function(s, e) { SetExportPanel(s); }" Init="function(s, e) { SetExportPanel(s); }" />
                    <Items>
                        <dx:ListEditItem Text="Excel" Value="Excel" Selected="true" />
                        <dx:ListEditItem Text="CSV" Value="CSV" Selected="false" />
                        <dx:ListEditItem Text="PDF" Value="PDF" Selected="false" />
                    </Items>
                </dx:ASPxComboBox>
            </p>
        </div>
        <dx:ASPxPanel ID="pnlExcel" runat="server" Width="600px" ClientInstanceName="pnlExcel" EnableClientSideAPI="True">
            <Paddings PaddingLeft="15px" />
            <Border BorderStyle="Solid" BorderColor="black" BorderWidth="1px"></Border>
            <PanelCollection>
                <dx:PanelContent>
                    <div style="padding: 10px;">
                        <dx:ASPxLabel ID="lblExcelTitle" runat="server" Text="Excel Export Options" Font-Bold="True" Font-Size="Medium"></dx:ASPxLabel>
                    </div>
                    <div style="width: 600px;">
                        <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="580px">
                        <tr>
                            <td>
                                <dx:ASPxRadioButton ID="optColumnWidthObject" runat="server" GroupName="ExcelColumnWidth" Text="Column width based on objects in the" 
                                    ClientInstanceName="optExcelColumnWidth1" EnableClientSideAPI="true">
                                    <ClientSideEvents CheckedChanged="function(s, e) { setExcelColumnWidth('enable'); }" />
                                </dx:ASPxRadioButton>
                            </td>
                            <td>
                                <dx:ASPxComboBox ID="ASPxcboExcelAreaType" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="excelAreaType">
                                    <Items>
                                        <dx:ListEditItem Text="Detail" Value="Detail" Selected="true" />
                                        <dx:ListEditItem Text="Group Footer" Value="GroupFooter" Selected="false" />
                                        <dx:ListEditItem Text="Group Header" Value="GroupHeader" Selected="false" />
                                        <dx:ListEditItem Text="Page Footer" Value="PageFooter" Selected="false" />
                                        <dx:ListEditItem Text="Page Header" Value="PageHeader" Selected="false" />
                                        <dx:ListEditItem Text="Report Footer" Value="ReportFooter" Selected="false" />
                                        <dx:ListEditItem Text="Report Header" Value="ReportHeader" Selected="false" />
                                    </Items>
                                </dx:ASPxComboBox>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <dx:ASPxRadioButton ID="optConstantColumnWidth" runat="server" GroupName="ExcelColumnWidth" Text="Constant column width (in points)" 
                                    ClientInstanceName="optExcelColumnWidth2" EnableClientSideAPI="true">
                                    <ClientSideEvents CheckedChanged="function(s, e) { setExcelColumnWidth('disable'); }" />
                                </dx:ASPxRadioButton>
                            </td>
                            <td>
                                <dx:ASPxSpinEdit ID="ASPxSpinConstantColumnWidth" runat="server" Number="0" ClientInstanceName="spinConstantColumnWidth" EnableClientSideAPI="true" MaxValue="100" MinValue="1" NumberType="Integer" Width="75px">
                                    <ValidationSettings ErrorText="Must be a number between 1 and 100">
                                    </ValidationSettings>
                                </dx:ASPxSpinEdit>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr>
                            <td>
                                <dx:ASPxCheckBox ID="chkExportObjectFormatting" runat="server" Text="Export object formatting"></dx:ASPxCheckBox>
                            </td>
                            <td>
                                <dx:ASPxCheckBox ID="chkMaintainColumnAlignment" runat="server" Text="Maintain column alignment"></dx:ASPxCheckBox>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <dx:ASPxCheckBox ID="chkExportImages" runat="server" Text="Export images"></dx:ASPxCheckBox>
                            </td>
                            <td>
                                <dx:ASPxCheckBox ID="chkExportPageHeaderFooter" runat="server" Text="Export page header and page footer"></dx:ASPxCheckBox>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <dx:ASPxCheckBox ID="chkUseWorksheetFunctions" runat="server" Text="Use worksheet functions for summaries"></dx:ASPxCheckBox>
                            </td>
                            <td>
                                <dx:ASPxCheckBox ID="chkSimplifyPageHeaders" runat="server" Text="Simplify page headers"></dx:ASPxCheckBox>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <dx:ASPxCheckBox ID="chkMaintainRelativeObjectPosition" runat="server" Text="Maintain relative object position"></dx:ASPxCheckBox>
                            </td>
                            <td>
                                <dx:ASPxCheckBox ID="chkShowGroupOutlines" runat="server" Text="Show group outlines"></dx:ASPxCheckBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <hr />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" valign="middle">File Name:
                                <dx:ASPxTextBox ID="ASPxtxtExcelFileName" runat="server" Width="300px" Height="25px" CssClass="edInline" ToolTip="This is the default file name, but this can be changed."></dx:ASPxTextBox>
                            </td>
                        </tr>
                    </table>
                </div>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlCSV" runat="server" Width="600px" ClientInstanceName="pnlCSV" EnableClientSideAPI="True">
            <Paddings PaddingLeft="15px" />
            <Border BorderStyle="Solid" BorderColor="black" BorderWidth="1px"></Border>
            <PanelCollection>
                <dx:PanelContent>
                    <div style="padding: 10px;">
                        <dx:ASPxLabel ID="lblCSVTitle" runat="server" Text="CSV Export Options" Font-Bold="True" Font-Size="Medium"></dx:ASPxLabel>
                    </div>
                    <div style="width:300px;">
                        <fieldset>
                            <legend>Character Options</legend>
                            <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="200px">
                                <tr>
                                    <td style="width:75px">
                                        <dx:ASPxLabel ID="lblDelimiter" runat="server" Text="Delimiter"></dx:ASPxLabel>
                                    </td>
                                    <td>
                                        <dx:ASPxTextBox ID="txtDelimiter" runat="server" Width="50px"></dx:ASPxTextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width:75px">
                                        <dx:ASPxLabel ID="lblSeparator" runat="server" Text="Separator"></dx:ASPxLabel>
                                    </td>
                                    <td>
                                        <dx:ASPxTextBox ID="txtSeparator" runat="server" Width="50px" Text=","></dx:ASPxTextBox>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </div>
                    <div style="padding: 5px;">
                        <dx:ASPxLabel ID="lblMode" runat="server" Text="Mode:" CssClass="edInline"></dx:ASPxLabel>
                        <dx:ASPxComboBox ID="cboMode" runat="server" CssClass="edInline" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="csvMode">
                            <Items>
                                <dx:ListEditItem Text="Legacy" Value="Legacy" Selected="false" />
                                <dx:ListEditItem Text="Standard mode" Value="Standard" Selected="true" />
                            </Items>
                        </dx:ASPxComboBox>
                    </div>
                    <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="580px">
                        <tr>
                            <td colspan="2">Report and Page Sections:</td>
                        </tr>
                        <tr>
                            <td>
                                <dx:ASPxRadioButton ID="radioCSVReportExport" runat="server" GroupName="csvReportSections" Text="Export" EnableClientSideAPI="True" ClientInstanceName="radioCSVReportExport">
                                    <ClientSideEvents CheckedChanged="function(s, e) { setReportIsolate('enable'); }" />
                                </dx:ASPxRadioButton>
                            </td>
                            <td>
                                <dx:ASPxCheckBox ID="chkCSVReportIsolate" runat="server" Text="Isolate Report/Page Sections" ClientInstanceName="chkCSVReportIsolate" EnableClientSideAPI="True"></dx:ASPxCheckBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <dx:ASPxRadioButton ID="radioCSVReportDoNotExport" runat="server" GroupName="csvReportSections" Text="Do Not Export" ClientInstanceName="radioCSVReportDoNotExport" EnableClientSideAPI="True">
                                    <ClientSideEvents CheckedChanged="function(s, e) { setReportIsolate('disable'); }" />
                                </dx:ASPxRadioButton>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">Group Sections:</td>
                        </tr>
                        <tr>
                            <td>
                                <dx:ASPxRadioButton ID="radioCSVGroupExport" runat="server" GroupName="csvGroupSections" Text="Export" ClientInstanceName="radioCSVGroupExport" EnableClientSideAPI="True">
                                    <ClientSideEvents CheckedChanged="function(s, e) { setGroupIsolate('enable'); }" />
                                </dx:ASPxRadioButton>
                            </td>
                            <td>
                                <dx:ASPxCheckBox ID="chkCSVGroupIsolate" runat="server" Text="Isolate Report/Page Sections" ClientInstanceName="chkCSVGroupIsolate" EnableClientSideAPI="True"></dx:ASPxCheckBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <dx:ASPxRadioButton ID="radioCSVGroupDoNotExport" runat="server" GroupName="csvGroupSections" Text="Do Not Export" ClientInstanceName="radioCSVGroupDoNotExport" EnableClientSideAPI="True">
                                    <ClientSideEvents CheckedChanged="function(s, e) { setGroupIsolate('disable'); }" />
                                </dx:ASPxRadioButton>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <hr />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">File Name:
                                    <dx:ASPxTextBox ID="ASPxtxtCSVFileName" runat="server" Width="300px" Height="25px" CssClass="edInline" ToolTip="This is the default file name, but this can be changed."></dx:ASPxTextBox>
                            </td>
                        </tr>
                    </table>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlPDF" runat="server" Width="600px" ClientInstanceName="pnlPDF" EnableClientSideAPI="True">
            <Paddings PaddingLeft="15px" PaddingBottom="5px"/>
            <Border BorderStyle="Solid" BorderColor="black" BorderWidth="1px"></Border>
            <PanelCollection>
                <dx:PanelContent>
                    <div style="padding: 10px;">
                        <dx:ASPxLabel ID="lblPDFTitle" runat="server" Text="PDF Export Options" Font-Bold="True" Font-Size="Medium"></dx:ASPxLabel>
                    </div>
                    <div style="width: 300px;">
                        <fieldset>
                            <legend>Page range</legend>
                            <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="250px">
                                <tr>
                                    <td style="width: 75px">
                                        <dx:ASPxRadioButton ID="radioPDFPageRangeAll" runat="server" GroupName="pdfPageRange" Text="All" 
                                            ClientInstanceName="radioPDFPageRangeAll" EnableClientSideAPI="True" >
                                            <ClientSideEvents CheckedChanged="function(s, e) { setPDFPageRange('enable'); }" />
                                        </dx:ASPxRadioButton>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 75px">
                                        <dx:ASPxRadioButton ID="radioPDFPageRangeFromTo" runat="server" GroupName="pdfPageRange" Text="Page range" 
                                            ClientInstanceName="radioPDFPageRangeFromTo" EnableClientSideAPI="True">
                                            <ClientSideEvents CheckedChanged="function(s, e) { setPDFPageRange('disable'); }" />
                                        </dx:ASPxRadioButton>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        From: 
                                        <dx:ASPxTextBox ID="ASPxtxtPDFPageRangeFrom" runat="server" Width="50px" Text="1" CssClass="edInline" 
                                            ClientInstanceName="txtPDFPageRangeFrom" EnableClientSideAPI="true"></dx:ASPxTextBox>
                                        To:
                                        <dx:ASPxTextBox ID="ASPxtxtPDFPageRangeTo" runat="server" Width="50px" Text="1" CssClass="edInline" 
                                            ClientInstanceName="txtPDFPageRangeTo" EnableClientSideAPI="true"></dx:ASPxTextBox>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </div>
                    <div>
                        <dx:ASPxCheckBox ID="ASPxchkPDFCreateBookmarks" runat="server" Text="Create bookmarks from group tree"></dx:ASPxCheckBox>
                    </div>
                    <div style="width: 300px;">
                        <hr />
                    </div>
                    <div>File Name:
                        <dx:ASPxTextBox ID="ASPxtxtPDFFileName" runat="server" Width="300px" Height="25px" CssClass="edInline" ToolTip="This is the default file name, but this can be changed."></dx:ASPxTextBox>
                    </div>
                </dx:PanelContent>
            </PanelCollection>
            <Border BorderStyle="Solid"></Border>
        </dx:ASPxPanel>
        
        <div style="padding-bottom: 25px; padding-left: 10px;">
        </div>
        <div style="padding-left: 10px;">
            <dx:ASPxButton ID="btnExport" runat="server" Text="Export" CssClass="edInline"></dx:ASPxButton>&nbsp;
            <dx:ASPxButton ID="btnClose" runat="server" Text="Close" CssClass="edInline" ClientInstanceName="btnClose" EnableClientSideAPI="True" AutoPostBack="False">
                <ClientSideEvents Click="function(s, e) {window.close();}" />
            </dx:ASPxButton>
        </div>
    </form>
</body>
</html>


