﻿<%@ Page Language="VB" MasterPageFile="~/RSMasterPage.master" AutoEventWireup="false" Inherits="RSWebApp.EditConnection" Title="Edit Database Connection" Codebehind="EditConnection.aspx.vb" %>

<%@ Register Assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <style type="text/css">
    	.rsForm {
		    float: left;
		    width: 200px;
	    }
        .edInline
        {
            display: inline-table;
        }
	</style>

    <script type="text/javascript">
        // Added new script for the frequency dropdown
        // Jeff Lyon - 10/28/2016 - version 3.7.1.6
        function setupTable() {
            var cboValue = connectionType.GetValue();
            var cboDataSourceValue = dataSource.GetValue();

            if (cboValue == "CrystalReport") {
                databaseNamePanel.SetVisible(true);
                dataSourcePanel.SetVisible(false);
                userIDPanel.SetVisible(true);
                passwordPanel.SetVisible(true);
                connectionStringPanel.SetVisible(false);
                useNewServerPanel.SetVisible(true);
                if (useNewServer.GetChecked()) {
                    newServerNamePanel.SetVisible(true);
                    newDatabaseNamePanel.SetVisible(true);
                }
                else {
                    newServerNamePanel.SetVisible(false);
                    newDatabaseNamePanel.SetVisible(false);
                }
            }

            if (cboValue == "RSReport") {
                databaseNamePanel.SetVisible(true);
                dataSourcePanel.SetVisible(false);
                userIDPanel.SetVisible(true);
                passwordPanel.SetVisible(true);
                connectionStringPanel.SetVisible(false);
                useNewServerPanel.SetVisible(false);
                newServerNamePanel.SetVisible(false);
                newDatabaseNamePanel.SetVisible(false);
            }

            if (cboValue == "PickList") {
                if (cboDataSourceValue == "DSN") {
                    databaseNamePanel.SetVisible(false);
                }
                else {
                    databaseNamePanel.SetVisible(true);
                }
                dataSourcePanel.SetVisible(true);
                userIDPanel.SetVisible(true);
                passwordPanel.SetVisible(true);
                connectionStringPanel.SetVisible(false);
                useNewServerPanel.SetVisible(false);
                newServerNamePanel.SetVisible(false);
                newDatabaseNamePanel.SetVisible(false);
            }

            if (cboValue == "ConnectString") {
                databaseNamePanel.SetVisible(false);
                dataSourcePanel.SetVisible(false);
                userIDPanel.SetVisible(false);
                passwordPanel.SetVisible(false);
                connectionStringPanel.SetVisible(true);
                useNewServerPanel.SetVisible(false);
                newServerNamePanel.SetVisible(false);
                newDatabaseNamePanel.SetVisible(false);
            }

        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="Server">
	<div class="nav2">
		<a class="nav2left" onclick="callHelp('DatabaseConnectionsHelp.htm')" href="javascript:void(0)">
			<img alt="Help" src="images/help3.gif" /></a> <span class="nav2title">Edit Database Connections</span>
    </div>
    <div>
        <dx:ASPxPanel ID="pnlConnectionType" runat="server" Width="100%" ClientInstanceName="connectionTypePanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
<Paddings PaddingBottom="10px"></Paddings>
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblConnectionType" runat="server" Text="Connection Type" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxComboBox ID="cboConnectionType" runat="server" EnableClientSideAPI="True" ClientInstanceName="connectionType" Width="250px" CssClass="edInline">
                        <ClientSideEvents SelectedIndexChanged="function(s, e) { setupTable(); }" Init="function(s, e) { setupTable(); }" />
                        <Items>
                            <dx:ListEditItem Text="Crystal Report" Value="CrystalReport" Selected="false" />
                            <dx:ListEditItem Text="Ripplestone Report" Value="RSReport" Selected="false" />
                            <dx:ListEditItem Text="Dynamic Pick List" Value="PickList" Selected="false" />
                            <dx:ListEditItem Text="Advanced Pick List - Connect String" Value="ConnectString" Selected="false" />
                        </Items>
                    </dx:ASPxComboBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlServerName" runat="server" Width="100%" ClientInstanceName="serverNamePanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblServerName" runat="server" Text="Server Name/DSN" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxTextBox ID="ASPxTxtServerName" runat="server" Width="245px" ClientInstanceName="serverName" EnableClientSideAPI="True" CssClass="edInline">
                    </dx:ASPxTextBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlDatabaseName" runat="server" Width="100%" ClientInstanceName="databaseNamePanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblDatabaseName" runat="server" Text="Database Name" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxTextBox ID="ASPxTxtDatabaseName" runat="server" Width="245px" ClientInstanceName="databaseName" EnableClientSideAPI="true" CssClass="edInline">
                    </dx:ASPxTextBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlDataSource" runat="server" Width="100%" ClientInstanceName="dataSourcePanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblDataSource" runat="server" Text="Data Source Type" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxComboBox ID="cboDataSource" runat="server" ValueType="System.String" AutoPostBack="false" ClientInstanceName="dataSource" EnableClientSideAPI="true" CssClass="edInline">
                        <ClientSideEvents SelectedIndexChanged="function(s, e) { setupTable(); }" />
                        <Items>
                            <dx:ListEditItem Text="Not Specified" Value="Unknown" Selected="true" />
                            <dx:ListEditItem Text="Microsoft SQL Server" Value="SQLServer" Selected="false" />
                            <dx:ListEditItem Text="Oracle" Value="Oracle" Selected="false" />
                            <dx:ListEditItem Text="Microsoft Access" Value="Access" Selected="false" />
                            <dx:ListEditItem Text="ODBC DSN" Value="DSN" Selected="false" />
                        </Items>
                    </dx:ASPxComboBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlUserID" runat="server" Width="100%" ClientInstanceName="userIDPanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblUserID" runat="server" Text="UserID" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxTextBox ID="ASPxTxtUserID" runat="server" Width="170px" ClientInstanceName="userID" EnableClientSideAPI="true" CssClass="edInline"></dx:ASPxTextBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlPassword" runat="server" Width="100%" ClientInstanceName="passwordPanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblPassword" runat="server" Text="Password" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxTextBox ID="ASPxTxtPassword" runat="server" Width="245px" ClientInstanceName="password" EnableClientSideAPI="true" Password="True" CssClass="edInline"></dx:ASPxTextBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlConnectionString" runat="server" Width="100%" ClientInstanceName="connectionStringPanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblConnectionString" runat="server" Text="Connection String" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxTextBox ID="ASPxTxtConnectionString" runat="server" Width="300px" MaxLength="255" CssClass="edInline"></dx:ASPxTextBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlUseNewServer" runat="server" Width="100%" ClientInstanceName="useNewServerPanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblUseNewServer" runat="server" Text="Use New Server and Database" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxCheckBox ID="ASPxchkUseNewServer" runat="server" ClientInstanceName="useNewServer" EnableClientSideAPI="True" CheckState="Unchecked" CssClass="edInline">
                        <ClientSideEvents CheckedChanged="function(s, e) { setupTable(); }" />
                    </dx:ASPxCheckBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlNewServerName" runat="server" Width="100%" ClientInstanceName="newServerNamePanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblNewServerName" runat="server" Text="New Server Name" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxTextBox ID="ASPxTxtNewServerName" runat="server" Width="245px" ClientInstanceName="newServerName" EnableClientSideAPI="true" CssClass="edInline"></dx:ASPxTextBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
        <dx:ASPxPanel ID="pnlNewDatabaseName" runat="server" Width="100%" ClientInstanceName="newDatabaseNamePanel" EnableClientSideAPI="true" Paddings-PaddingBottom="10px">
            <PanelCollection>
                <dx:PanelContent>
                    <dx:ASPxLabel ID="lblNewDatabaseName" runat="server" Text="New Database Name" CssClass="rsForm"></dx:ASPxLabel>
                    <dx:ASPxTextBox ID="ASPxTxtNewDatabaseName" runat="server" Width="245px" CssClass="edInline"></dx:ASPxTextBox>
                </dx:PanelContent>
            </PanelCollection>
        </dx:ASPxPanel>
    </div>
    <div>
        <dx:ASPxButton ID="ASPxbtnOk" runat="server" Text="OK" Width="65px"></dx:ASPxButton>
        <dx:ASPxButton ID="ASPxbtnCancel" runat="server" Text="Cancel" Width="65px" CssClass="edInline"></dx:ASPxButton>
    </div>
</asp:Content>
