﻿<%@ Page Language="VB" MasterPageFile="~/RSMasterPage.master" AutoEventWireup="false" Inherits="RSWebApp.EditRole" 
	Title="Manage Role" Codebehind="EditRole.aspx.vb" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>
<%@ Register Assembly="SCS.PickList" Namespace="SCS.Web.UI.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <script type="text/javascript">
        function AddSelectedItems() {
            MoveSelectedItems(lbAvailable, lbChoosen);
            UpdateButtonState();
        }
        function AddAllItems() {
            MoveAllItems(lbAvailable, lbChoosen);
            UpdateButtonState();
        }
        function RemoveSelectedItems() {
            MoveSelectedItems(lbChoosen, lbAvailable);
            UpdateButtonState();
        }
        function RemoveAllItems() {
            MoveAllItems(lbChoosen, lbAvailable);
            UpdateButtonState();
        }
        function MoveSelectedItems(srcListBox, dstListBox) {
            srcListBox.BeginUpdate();
            dstListBox.BeginUpdate();
            var items = srcListBox.GetSelectedItems();
            for (var i = items.length - 1; i >= 0; i = i - 1) {
                dstListBox.AddItem(items[i].text, items[i].value);
                srcListBox.RemoveItem(items[i].index);
            }
            srcListBox.EndUpdate();
            dstListBox.EndUpdate();
        }
        function MoveAllItems(srcListBox, dstListBox) {
            srcListBox.BeginUpdate();
            var count = srcListBox.GetItemCount();
            for (var i = 0; i < count; i++) {
                var item = srcListBox.GetItem(i);
                dstListBox.AddItem(item.text, item.value);
            }
            srcListBox.EndUpdate();
            srcListBox.ClearItems();
        }
        function UpdateButtonState() {
            btnMoveAllItemsToRight.SetEnabled(lbAvailable.GetItemCount() > 0);
            btnMoveAllItemsToLeft.SetEnabled(lbChoosen.GetItemCount() > 0);
            btnMoveSelectedItemsToRight.SetEnabled(lbAvailable.GetSelectedItems().length > 0);
            btnMoveSelectedItemsToLeft.SetEnabled(lbChoosen.GetSelectedItems().length > 0);
        }

    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="Server">
	<div class="nav2">
		<a class="nav2left" onclick="callHelp('RoleHelp.htm')" href="javascript:void(0)" tabindex="-1">
			<img alt="Help" src="images/help3.gif" /></a> 
		<asp:Label id="lblTitle" runat="server" Text="Edit Role" CssClass="nav2title"></asp:Label>
	</div>
	<dx:ASPxPageControl ID="ASPxPageControl1" runat="server" ActiveTabIndex="0" TabSpacing="0px" Width="100%" 
		EnableClientSideAPI="True" ClientInstanceName="HomeTabs" EnableTheming="True">
		<Paddings Padding="2px" PaddingLeft="5px" PaddingRight="5px"></Paddings>
		<TabPages>
			<dx:TabPage Name="tabConfiguration" Text="General" ToolTip="General Role Information">
				<ContentCollection>
					<dx:ContentControl ID="tabGeneral" runat="server" SupportsDisabledAttribute="True" Width="100%">
                        <table width="100%">
                            <tr>
                                <td style="width: 21px;">
                                    <a onclick="callHelp('RoleHelp.htm')" href="javascript:void(0)" tabindex="-1">
                                        <img alt="Help" src="images/help3.gif" /></a>
                                </td>
                                <td class="FormLabel">Roles - Used to Assign Security to a group of users
                                </td>
                            </tr>
                        </table>
                        <table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr>
                                <td class="FormLabel" style="width: 150px">Role ID
                                </td>
                                <td colspan="2">
									<asp:Label ID="lblRoleID" runat="server"></asp:Label>
								</td>
							</tr>
							<tr>
                                <td class="FormLabel" style="width: 150px">Role Name
                                </td>
                                <td style="width: 348px">
                                    <dx:ASPxTextBox ID="ASPxtxtRole" runat="server" Width="350px"></dx:ASPxTextBox>
								</td>
								<td>
									<asp:RequiredFieldValidator ID="ctlRoleRequired" runat="server" EnableClientScript="True"
                                        ControlToValidate="ASPxtxtRole" ErrorMessage="* Role Name Required." Display="dynamic"></asp:RequiredFieldValidator>
									<asp:CustomValidator ID="ctlRoleIsUnique" runat="server" ControlToValidate="ASPxtxtRole"
                                        ErrorMessage="* Role Name Already Exists." Display="dynamic" OnServerValidate="RoleIsUnique"></asp:CustomValidator>
								</td>
							</tr>
							<tr>
                                <td class="FormLabel" style="width: 150px">Description
                                </td>
                                <td colspan="2">
                                    <dx:ASPxMemo ID="ASPxmemoDescription" runat="server" Height="71px" Width="350px" MaxLength="255" Rows="3"></dx:ASPxMemo>
								</td>
							</tr>
							<tr>
                                <td class="FormLabel" style="width: 150px">Super User
                                </td>
                                <td colspan="2">
                                    <dx:ASPxCheckBox ID="ASPxchkSuperUser" runat="server"></dx:ASPxCheckBox>
								</td>
							</tr>
							<tr>
                                <td class="FormLabel" style="width: 150px">Administrator
                                </td>
                                <td colspan="2">
                                    <dx:ASPxCheckBox ID="ASPxchkAdmin" runat="server"></dx:ASPxCheckBox>
								</td>
							</tr>
							<tr>
                                <td class="FormLabel" style="width: 150px">Publisher
                                </td>
                                <td colspan="2">
                                    <dx:ASPxCheckBox ID="ASPxchkPublisher" runat="server"></dx:ASPxCheckBox>
								</td>
							</tr>
							<tr>
                                <td class="FormLabel" style="width: 150px">Scheduler
                                </td>
                                <td colspan="2">
                                    <dx:ASPxCheckBox ID="ASPxchkScheduler" runat="server"></dx:ASPxCheckBox>
								</td>
							</tr>
                            <tr>
                                <td class="FormLabel" style="width: 150px">Viewer
                                </td>
                                <td colspan="2">
                                    <dx:ASPxCheckBox ID="ASPxchkViewer" runat="server"></dx:ASPxCheckBox>
                                </td>
                            </tr>
                        </table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabFolderSecurity" Text="Folder Security" ToolTip="Manage folders for this role">
				<ContentCollection>
					<dx:ContentControl ID="ContentControl1" runat="server" SupportsDisabledAttribute="True" Width="100%">
                        <table width="100%">
                            <tr>
                                <td style="width: 21px;">
                                    <a onclick="callHelp('UserRoles.htm')" href="javascript:void(0)" tabindex="-1">
                                        <img alt="Help" src="images/help3.gif" /></a>
                                </td>
                                <td class="FormLabel">Manage folder security for this role
                                </td>
                            </tr>
                        </table>
                        <table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr>
								<td>
									<table cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td style="width: 411px;" valign="top" align="left">
												<asp:CheckBox ID="chkSelectChildNodes" runat="server" ToolTip="If this is selected, then all child folders will also be selected when a parent folder is selected."
													Checked="True" Text="Select the child folders when parent is selected"></asp:CheckBox>
												<br />
												<br />
												Tree of all available folders
												<br />
												<br />
												<telerik:RadTreeView ID="RadTreeFolders" runat="server" Width="100%"
													CheckBoxes="True" Height="100%">
													<CollapseAnimation Type="OutQuint" Duration="100"></CollapseAnimation>

													<ExpandAnimation Duration="100"></ExpandAnimation>
												</telerik:RadTreeView>
											</td>
											<td valign="top" align="center">
												<br />
												<br />
												List of selected items
												<br />
												<br />
												<span style="text-align: left;">
													<asp:ListBox ID="lstSecurityAssigned" runat="server" Width="98%" Height="200px"></asp:ListBox>
												</span>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabUsers" Text="Users" ToolTip="Manage users for this role">
				<ContentCollection>
					<dx:ContentControl ID="tabUsers" runat="server" SupportsDisabledAttribute="True" Width="100%">
                        <table width="100%">
                            <tr>
                                <td style="width: 21px;">
                                    <a onclick="callHelp('RoleUsers.htm')" href="javascript:void(0)" tabindex="-1">
                                        <img alt="Help" src="images/help3.gif" /></a>
                                </td>
                                <td class="FormLabel">Manage users for this role
                                </td>
                            </tr>
                        </table>
                        <table style="width: 100%">
                            <tr>
                                <td style="width: 40%">
                                    <!-- Added EnableSynchronization property - Jeff Lyon - 4/23/2019 - version 3.9.4.2   -->
                                    <dx:ASPxListBox ID="lbAvailable" runat="server" ClientInstanceName="lbAvailable" EnableSynchronization="True"
                                        Width="100%" Height="250px" SelectionMode="CheckColumn" Caption="Available Users">
                                        <CaptionSettings Position="Top" />
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { UpdateButtonState(); }" />
                                    </dx:ASPxListBox>
                                </td>
                                <td style="padding: 90px 60px;">
                                    <div>
                                        <dx:ASPxButton ID="btnMoveSelectedItemsToRight" runat="server" ClientInstanceName="btnMoveSelectedItemsToRight"
                                            AutoPostBack="False" Text="Add >" Width="130px" ClientEnabled="False"
                                            ToolTip="Add selected items">
                                            <ClientSideEvents Click="function(s, e) { AddSelectedItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div class="TopPadding">
                                        <dx:ASPxButton ID="btnMoveAllItemsToRight" runat="server" ClientInstanceName="btnMoveAllItemsToRight"
                                            AutoPostBack="False" Text="Add All >>" Width="130px" ToolTip="Add all items">
                                            <ClientSideEvents Click="function(s, e) { AddAllItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div style="height: 32px">
                                    </div>
                                    <div>
                                        <dx:ASPxButton ID="btnMoveSelectedItemsToLeft" runat="server" ClientInstanceName="btnMoveSelectedItemsToLeft"
                                            AutoPostBack="False" Text="< Remove" Width="130px" ClientEnabled="False"
                                            ToolTip="Remove selected items">
                                            <ClientSideEvents Click="function(s, e) { RemoveSelectedItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div class="TopPadding">
                                        <dx:ASPxButton ID="btnMoveAllItemsToLeft" runat="server" ClientInstanceName="btnMoveAllItemsToLeft"
                                            AutoPostBack="False" Text="<< Remove All" Width="130px" ClientEnabled="False"
                                            ToolTip="Remove all items">
                                            <ClientSideEvents Click="function(s, e) { RemoveAllItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                </td>
                                <td style="width: 40%">
                                    <!-- Added EnableSynchronization property - Jeff Lyon - 4/23/2019 - version 3.9.4.2   -->
                                    <dx:ASPxListBox ID="lbChoosen" runat="server" ClientInstanceName="lbChoosen" Width="100%" EnableSynchronization="True"
                                        Height="250px" SelectionMode="CheckColumn" Caption="Assigned Users">
                                        <CaptionSettings Position="Top" />
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { UpdateButtonState(); }"></ClientSideEvents>
                                    </dx:ASPxListBox>
                                </td>
                            </tr>
                        </table>
                    </dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabAssign" Text="Assigned User and Roles" ToolTip="Used to assigned users and roles to this Administrator role">
				<ContentCollection>
					<dx:ContentControl runat="server">
                        <table width="100%">
                            <tr>
                                <td style="width: 21px;">
                                    <a onclick="callHelp('RoleUsers.htm')" href="javascript:void(0)" tabindex="-1">
                                        <img alt="Help" src="images/help3.gif" /></a>
                                </td>
                                <td class="FormLabel">Manage Assigned Roles
                                </td>
                            </tr>
                        </table>
                        <table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
<%--                            <tr>
                                <td style="width: 40%">
                                    <dx:ASPxListBox ID="ASPxlstAvailableRoles" runat="server" ClientInstanceName="lbRolesAvailable"
                                        Width="100%" Height="250px" SelectionMode="CheckColumn" Caption="Available Roles">
                                        <CaptionSettings Position="Top" />
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { UpdateButtonState(); }" />
                                    </dx:ASPxListBox>
                                </td>
                                <td style="padding: 90px 60px;">
                                    <div>
                                        <dx:ASPxButton ID="ASPxbtnMoveRoleRight" runat="server" ClientInstanceName="btnRolesMoveSelectedItemsToRight"
                                            AutoPostBack="False" Text="Add >" Width="130px" ClientEnabled="False"
                                            ToolTip="Add selected items">
                                            <ClientSideEvents Click="function(s, e) { AddSelectedItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div class="TopPadding">
                                        <dx:ASPxButton ID="ASPxbtnMoveAllRolesRight" runat="server" ClientInstanceName="btnRolesMoveAllItemsToRight"
                                            AutoPostBack="False" Text="Add All >>" Width="130px" ToolTip="Add all items">
                                            <ClientSideEvents Click="function(s, e) { AddAllItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div style="height: 32px">
                                    </div>
                                    <div>
                                        <dx:ASPxButton ID="ASPxbtnMoveRoleLeft" runat="server" ClientInstanceName="btnRolesMoveSelectedItemsToLeft"
                                            AutoPostBack="False" Text="< Remove" Width="130px" ClientEnabled="False"
                                            ToolTip="Remove selected items">
                                            <ClientSideEvents Click="function(s, e) { RemoveSelectedItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div class="TopPadding">
                                        <dx:ASPxButton ID="ASPxbtnMoveAllRolesLeft" runat="server" ClientInstanceName="btnRoleMoveAllItemsToLeft"
                                            AutoPostBack="False" Text="<< Remove All" Width="130px" ClientEnabled="False"
                                            ToolTip="Remove all items">
                                            <ClientSideEvents Click="function(s, e) { RemoveAllItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                </td>
                                <td style="width: 40%">
                                    <dx:ASPxListBox ID="ASPxlstSelectedRoles" runat="server" ClientInstanceName="lbRolesChoosen" Width="100%"
                                        Height="250px" SelectionMode="CheckColumn" Caption="Assigned Users">
                                        <CaptionSettings Position="Top" />
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { UpdateButtonState(); }"></ClientSideEvents>
                                    </dx:ASPxListBox>
                                </td>
                            </tr>--%>
                            <tr>
								<td>
									<cc1:PickList ID="pickAssignedRoles" runat="server" AvailableLabelText="Available Roles:" CurrentLabelText="Assigned Roles:" Rows="8" Width="309px" DisplayAddAllButton="True" DisplayRemoveAllButton="True" Font-Bold="False">
										<AddButtonStyle Width="125px" />
										<AddAllButtonStyle Width="125px" />
										<RemoveButtonStyle Width="125px" />
										<RemoveAllButtonStyle Width="125px" />
										<AvailableLabelStyle Font-Bold="True" />
										<SelectedLabelStyle Font-Bold="True" />
										<AvailableListBoxStyle Width="200px" />
										<SelectedListBoxStyle Width="200px" />
									</cc1:PickList>
								</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
							</tr>
							<tr>
								<td>
									<table width="100%">
										<tr>
											<td style="width: 6px">
												<a onclick="callHelp('RoleUsers.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel" style="width: 300px">Manage Assigned Users:
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td>
									<cc1:PickList ID="pickAssignedUsers" runat="server" AvailableLabelText="Available Users:" CurrentLabelText="Assigned Users:" Rows="8" Width="309px" DisplayAddAllButton="True" DisplayRemoveAllButton="True" Font-Bold="False">
										<AddButtonStyle Width="125px" />
										<AddAllButtonStyle Width="125px" />
										<RemoveButtonStyle Width="125px" />
										<RemoveAllButtonStyle Width="125px" />
										<AvailableLabelStyle Font-Bold="True" />
										<SelectedLabelStyle Font-Bold="True" />
										<AvailableListBoxStyle Width="200px" />
										<SelectedListBoxStyle Width="200px" />
									</cc1:PickList>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
		</TabPages>
		<LoadingPanelImage Url="~/App_Themes/Office2010Blue/Web/Loading.gif">
		</LoadingPanelImage>
		<LoadingPanelStyle ImageSpacing="5px">
		</LoadingPanelStyle>
		<Paddings Padding="2px" PaddingLeft="5px" PaddingRight="5px" />
		<ContentStyle>
			<Border BorderColor="#859EBF" BorderStyle="Solid" BorderWidth="1px" />
			<Paddings Padding="12px"></Paddings>
			<Border BorderColor="#859EBF" BorderStyle="Solid" BorderWidth="1px"></Border>
			<Paddings Padding="12px" />
		</ContentStyle>
	</dx:ASPxPageControl>
	<div id="buttons">
        <dx:ASPxButton ID="ASPxbtnSave" runat="server" Text="Save"></dx:ASPxButton>
        <dx:ASPxButton ID="ASPxbtnCancel" runat="server" Text="Cancel" CausesValidation="false"></dx:ASPxButton>
		<asp:ValidationSummary ID="ctlValidationSummary" runat="server" ForeColor="Red" ShowMessageBox="True"
			DisplayMode="List" ShowSummary="False" HeaderText="The following errors were found:">
		</asp:ValidationSummary>
	</div>
</asp:Content>
