﻿<%@ Page Language="VB" MasterPageFile="~/RSMasterPage.master" AutoEventWireup="false" Inherits="RSWebApp.EditSchedule"
	Title="Manage Scheduled Report" CodeBehind="EditSchedule.aspx.vb" ValidateRequest="false" %>

<%@ Register Assembly="DevExpress.Web.ASPxHtmlEditor.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web.ASPxHtmlEditor" TagPrefix="dx" %>
<%@ Register TagPrefix="uc1" TagName="ReportParameters" Src="ReportParameters.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>
<%@ Register assembly="DevExpress.Web.ASPxSpellChecker.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" namespace="DevExpress.Web.ASPxSpellChecker" tagprefix="dx" %>



<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <style type="text/css">
        .edInline
        {
            display: inline-table;
        }
		div.explain
		{
			border-right: 0px solid;
			border-top: 0px solid;
			margin-bottom: 0px;
			margin-left: 5px;
			border-left: 0px solid;
			border-bottom: 0px solid;
		}
		div.HideMonth
		{
			padding-right: 0px;
			display: none;
			padding-left: 0px;
			padding-bottom: 0px;
			margin: 0px;
			padding-top: 0px;
		}
		div.ShowMonth
		{
			padding-right: 0px;
			display: block;
			padding-left: 0px;
			padding-bottom: 0px;
			margin: 0px;
			padding-top: 0px;
		}
	    .auto-style2 {
            width: 184px;
        }
	    .FormTextbox {}
	    .auto-style3 {
            width: 188px;
            height: 55px;
        }
        .auto-style4 {
            height: 55px;
        }
	</style>
    <script type="text/javascript">
        function setExcelExportOptions(s) {
            var flag = UseExcelExportOptions.GetChecked();
            
            if (flag == true) {
                excelColumnWidth.SetEnabled(true);
                excelAreaType.SetEnabled(true);
                excelConstantColumn.SetEnabled(true);
                excelContantColumnText.SetEnabled(true);
                excelExportObjectFormatting.SetEnabled(true);
                excelMaintainColumnAligment.SetEnabled(true);
                excelExportImages.SetEnabled(true);
                excelExportPageFooter.SetEnabled(true);
                excelUseWorksheetFunctions.SetEnabled(true);
                excelSimplifyPageHeaders.SetEnabled(true);
                excelMaintainRelativeObject.SetEnabled(true);
                excelShowGroupOutlines.SetEnabled(true);
            }
            else {
                excelColumnWidth.SetEnabled(false);
                excelAreaType.SetEnabled(false);
                excelConstantColumn.SetEnabled(false);
                excelContantColumnText.SetEnabled(false);
                excelExportObjectFormatting.SetEnabled(false);
                excelMaintainColumnAligment.SetEnabled(false);
                excelExportImages.SetEnabled(false);
                excelExportPageFooter.SetEnabled(false);
                excelUseWorksheetFunctions.SetEnabled(false);
                excelSimplifyPageHeaders.SetEnabled(false);
                excelMaintainRelativeObject.SetEnabled(false);
                excelShowGroupOutlines.SetEnabled(false);
            }

        }
        function setCSVExportOptions(s) {
            var flag = UseCSVExportOptions.GetChecked();

            if (flag == true) {
                csvDelimiterLabel.SetEnabled(true);
                csvDelimiterText.SetEnabled(true);
                csvSeparatorLabel.SetEnabled(true);
                csvSeparatorText.SetEnabled(true);
                csvModeLabel.SetEnabled(true);
                csvMode.SetEnabled(true);
                csvReportIsolate.SetEnabled(true);
                csvGroupIsolate.SetEnabled(true);
                csvReportExport.SetEnabled(true);
                csvReportDoNotExport.SetEnabled(true);
                csvGroupExport.SetEnabled(true);
                csvGroupDoNotExport.SetEnabled(true);
            }
            else {
                csvDelimiterLabel.SetEnabled(false);
                csvDelimiterText.SetEnabled(false);
                csvSeparatorLabel.SetEnabled(false);
                csvSeparatorText.SetEnabled(false);
                csvModeLabel.SetEnabled(false);
                csvMode.SetEnabled(false);
                csvReportIsolate.SetEnabled(false);
                csvGroupIsolate.SetEnabled(false);
                csvReportExport.SetEnabled(false);
                csvReportDoNotExport.SetEnabled(false);
                csvGroupExport.SetEnabled(false);
                csvGroupDoNotExport.SetEnabled(false);
            }
        }
        function setPDFExportOptions(s) {
            var flag = UsePDFExportOptions.GetChecked();

            if (flag == true) {
                radioPDFPageRangeAll.SetEnabled(true);
                radioPDFPageRangeFromTo.SetEnabled(true);
                txtPDFPageRangeFrom.SetEnabled(true);
                txtPDFPageRangeTo.SetEnabled(true);
                chkPDFCreateBookmarks.SetEnabled(true);
            }
            else {
                radioPDFPageRangeAll.SetEnabled(false);
                radioPDFPageRangeFromTo.SetEnabled(false);
                txtPDFPageRangeFrom.SetEnabled(false);
                txtPDFPageRangeTo.SetEnabled(false);
                chkPDFCreateBookmarks.SetEnabled(false);
            }
        }
        function setPDFPageRange(s) {
            if (s == "enable") {
                txtPDFPageRangeFrom.SetEnabled(false);
                txtPDFPageRangeTo.SetEnabled(false);
            }
            else {
                txtPDFPageRangeFrom.SetEnabled(true);
                txtPDFPageRangeTo.SetEnabled(true);
            }
        }
        function enableFTPFileName(s) {
            var flag = chkFTPFileName.GetChecked();
            if (flag == true) {
                ASPxtxtFTPFileName.SetEnabled(false);
            }
            else {
                ASPxtxtFTPFileName.SetEnabled(true);
            }
        }
        function setStartEndDropdowns(s) {
            var flag = useCustomHours.GetChecked();

            if (flag == true) {
                ASPxcboHourlyStartTime.SetEnabled(true);
                ASPxcboHourlyEndTime.SetEnabled(true);
            }
            else {
                ASPxcboHourlyStartTime.SetEnabled(false);
                ASPxcboHourlyEndTime.SetEnabled(false);
            }
        }

        function SetOutputPanel(s) {
            var cboValue = s.GetValue();

            pnlExcel.SetVisible(false);
            pnlCSV.SetVisible(false);
            pnlPDF.SetVisible(false);

            if (cboValue == "2")
            {
                pnlPDF.SetVisible(true);
            }

            if (cboValue == "4")
            {
                pnlCSV.SetVisible(true);
            }

            if (cboValue == "9")
            {
                pnlExcel.SetVisible(true);
            }

            if (cboValue == "12")
            {
                pnlExcel.SetVisible(true);
            }

        }
        function setReportIsolate(s) {
            var flag = UseCSVExportOptions.GetChecked();

            If(flag == true)
            {
                if (s == "enable") {
                    csvReportIsolate.SetEnabled(true);
                }
                else {
                    csvReportIsolate.SetEnabled(false);
                }
            }
        }
        function setGroupIsolate(s) {
            var flag = UseCSVExportOptions.GetChecked();

            if (flag == true) {
                if (s == "enable") {
                    csvGroupIsolate.SetEnabled(true);
                }
                else {
                    csvGroupIsolate.SetEnabled(false);
                }
            }
        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="Server">
    <div id="scheduleName" class="EditPageTitle">
		Schedule Name:
		<asp:Label ID="lblScheduleName" runat="server"></asp:Label>
	</div>
	<div>
		<asp:Label ID="lblValidationSummaryTop" runat="server" ForeColor="Red" Visible="False">
		</asp:Label>
	</div>
	<dx:ASPxPageControl ID="ASPxPageControl1" runat="server" ActiveTabIndex="0" TabSpacing="0px" Width="100%" EnableClientSideAPI="True" ClientInstanceName="HomeTabs" EnableTheming="True">
		<Paddings Padding="2px" PaddingLeft="5px" PaddingRight="5px"></Paddings>
		<TabPages>
			<dx:TabPage Name="tabDocument" Text="Document" ToolTip="Manage the document information">
				<ContentCollection>
					<dx:ContentControl ID="tabDocument" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr id="NotSupportedRow" runat="server">
								<td class="FormLabel" style="width: 172px;">&nbsp;
								</td>
								<td class="ErrorMessage" colspan="2">This document type is not supported for scheduling, select a different document.
								</td>
							</tr>
							<tr id="JobIDRow" runat="server">
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobIdHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Job ID</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<asp:Label ID="lblJobID" runat="server"></asp:Label>
								</td>
							</tr>
							<tr id="JobDescriptionRow" runat="server">
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobDescHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Job Description</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:TextBox ID="txtJobDescription" runat="server" CssClass="FormTextbox" MaxLength="50"></asp:TextBox>
								</td>
								<td>
									<asp:RequiredFieldValidator ID="ctlValidateJobDesc" runat="server" EnableClientScript="True"
										ControlToValidate="txtJobDescription" ErrorMessage="* Job Description required."
										Display="dynamic"></asp:RequiredFieldValidator>
								</td>
							</tr>
							<tr id="OutputFormatRow" runat="server">
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobFormatHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Output Format
											</td>
										</tr>
									</table>
								</td>
								<td>
                                    <dx:ASPxComboBox ID="cboOutputType" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="outputType">
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { SetOutputPanel(s); }" Init="function(s, e) { SetOutputPanel(s); }" />
                                        <Items>
                                            <dx:ListEditItem Text="Crystal Report" Value="1" Selected="true" />
                                            <dx:ListEditItem Text="PDF" Value="2" Selected="false" />
                                            <dx:ListEditItem Text="Excel (xls)" Value="3" Selected="false" />
                                            <dx:ListEditItem Text="Excel Data (xls)" Value="12" Selected="false" />
                                            <dx:ListEditItem Text="Excel Data (xlsx)" Value="9" Selected="false" />
                                            <dx:ListEditItem Text="Word (rtf)" Value="6" Selected="false" />
                                            <dx:ListEditItem Text="Rich Text (rtf)" Value="8" Selected="false" />
                                            <dx:ListEditItem Text="Editable Rich Text (rtf)" Value="10" Selected="false" />
                                            <dx:ListEditItem Text="CSV" Value="4" Selected="false" />
                                            <dx:ListEditItem Text="Text" Value="5" Selected="false" />
                                            <dx:ListEditItem Text="Tab Separated" Value="7" Selected="false" />
                                            <dx:ListEditItem Text="XML" Value="11" Selected="false" />
                                        </Items>
                                    </dx:ASPxComboBox>
								</td>
                                <td>
                                    <dx:ASPxPanel ID="pnlExcel" runat="server" Width="600px" ClientInstanceName="pnlExcel" EnableClientSideAPI="True">
                                        <Styles>
                                            <Panel Border-BorderColor="Black" Border-BorderStyle="Solid" Border-BorderWidth="1px">
                                            </Panel>
                                        </Styles>
                                        <Paddings Padding="5px"></Paddings>
                                        <PanelCollection>
                                            <dx:PanelContent>
                                                <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="600px">
                                                    <tr>
                                                        <td colspan="2">
                                                            <dx:ASPxLabel ID="lblExcelTitle" runat="server" Text="Excel Data Export Options" Font-Bold="True" Font-Size="Medium"></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">
                                                            <dx:ASPxCheckBox ID="chkUseExcelExportOptions" runat="server" Text="Use Custom Export Options?" EnableClientSideAPI="True" ClientInstanceName="UseExcelExportOptions">
                                                                <ClientSideEvents CheckedChanged="function(s, e) { setExcelExportOptions(); }" />
                                                            </dx:ASPxCheckBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxRadioButton ID="optColumnWidthObject" runat="server" GroupName="ExcelColumnWidth" Text="Column width based on objects in the" EnableClientSideAPI="true" ClientInstanceName="excelColumnWidth"></dx:ASPxRadioButton>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxComboBox ID="ASPxcboExcelAreaType" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="excelAreaType">
                                                                <Items>
                                                                    <dx:ListEditItem Text="Detail" Value="Detail" Selected="true" />
                                                                    <dx:ListEditItem Text="Group Footer" Value="GroupFooter" Selected="false" />
                                                                    <dx:ListEditItem Text="Group Header" Value="GroupHeader" Selected="false" />
                                                                    <dx:ListEditItem Text="Page Footer" Value="PageFooter" Selected="false" />
                                                                    <dx:ListEditItem Text="Page Header" Value="PageHeader" Selected="false" />
                                                                    <dx:ListEditItem Text="Report Footer" Value="ReportFooter" Selected="false" />
                                                                    <dx:ListEditItem Text="Report Header" Value="ReportHeader" Selected="false" />
                                                                </Items>
                                                            </dx:ASPxComboBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxRadioButton ID="optConstantColumnWidth" runat="server" GroupName="ExcelColumnWidth" Text="Constant column width (in points)" EnableClientSideAPI="true" ClientInstanceName="excelConstantColumn"></dx:ASPxRadioButton>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxTextBox ID="txtConstantColumnWidth" runat="server" Width="100px" EnableClientSideAPI="true" ClientInstanceName="excelContantColumnText"></dx:ASPxTextBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">&nbsp;</td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkExportObjectFormatting" runat="server" Text="Export object formatting" EnableClientSideAPI="true" ClientInstanceName="excelExportObjectFormatting"></dx:ASPxCheckBox>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkMaintainColumnAlignment" runat="server" Text="Maintain column alignment" EnableClientSideAPI="true" ClientInstanceName="excelMaintainColumnAligment"></dx:ASPxCheckBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkExportImages" runat="server" Text="Export images" EnableClientSideAPI="true" ClientInstanceName="excelExportImages"></dx:ASPxCheckBox>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkExportPageHeaderFooter" runat="server" Text="Export page header and page footer" EnableClientSideAPI="true" ClientInstanceName="excelExportPageFooter"></dx:ASPxCheckBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkUseWorksheetFunctions" runat="server" Text="Use worksheet functions for summaries" EnableClientSideAPI="true" ClientInstanceName="excelUseWorksheetFunctions"></dx:ASPxCheckBox>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkSimplifyPageHeaders" runat="server" Text="Simplify page headers" EnableClientSideAPI="true" ClientInstanceName="excelSimplifyPageHeaders"></dx:ASPxCheckBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkMaintainRelativeObjectPosition" runat="server" Text="Maintain relative object position" EnableClientSideAPI="true" ClientInstanceName="excelMaintainRelativeObject"></dx:ASPxCheckBox>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkShowGroupOutlines" runat="server" Text="Show group outlines" EnableClientSideAPI="true" ClientInstanceName="excelShowGroupOutlines"></dx:ASPxCheckBox>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </dx:PanelContent>
                                        </PanelCollection>
                                        <Border BorderStyle="Solid"></Border>
                                    </dx:ASPxPanel>
                                    <dx:ASPxPanel ID="pnlCSV" runat="server" Width="600px" ClientInstanceName="pnlCSV" EnableClientSideAPI="True">
                                        <Styles>
                                            <Panel Border-BorderColor="Black" Border-BorderStyle="Solid" Border-BorderWidth="1px">
                                            </Panel>
                                        </Styles>
                                        <PanelCollection>
                                            <dx:PanelContent>
                                                <div style="padding: 10px;">
                                                    <dx:ASPxLabel ID="lblCSVTitle" runat="server" Text="CSV Export Options" Font-Bold="True" Font-Size="Medium"></dx:ASPxLabel>
                                                </div>
                                                <div>
                                                    <dx:ASPxCheckBox ID="chkUseCSVExportOptions" runat="server" Text="Use Custom Export Options?" EnableClientSideAPI="True" ClientInstanceName="UseCSVExportOptions">
                                                        <ClientSideEvents CheckedChanged="function(s, e) { setCSVExportOptions(); }" />
                                                    </dx:ASPxCheckBox>
                                                </div>
                                                <div style="width: 300px;">
                                                    <fieldset>
                                                        <legend>Character Options</legend>
                                                        <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="200px">
                                                            <tr>
                                                                <td style="width: 75px">
                                                                    <dx:ASPxLabel ID="lblDelimiter" runat="server" Text="Delimiter" EnableClientSideAPI="true" ClientInstanceName="csvDelimiterLabel"></dx:ASPxLabel>
                                                                </td>
                                                                <td>
                                                                    <dx:ASPxTextBox ID="txtDelimiter" runat="server" Width="50px" EnableClientSideAPI="true" ClientInstanceName="csvDelimiterText"></dx:ASPxTextBox>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 75px">
                                                                    <dx:ASPxLabel ID="lblSeparator" runat="server" Text="Separator" EnableClientSideAPI="true" ClientInstanceName="csvSeparatorLabel"></dx:ASPxLabel>
                                                                </td>
                                                                <td>
                                                                    <dx:ASPxTextBox ID="txtSeparator" runat="server" Width="50px" Text="," EnableClientSideAPI="true" ClientInstanceName="csvSeparatorText"></dx:ASPxTextBox>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                </div>
                                                <div style="padding: 5px;">
                                                    <dx:ASPxLabel ID="lblMode" runat="server" Text="Mode:" CssClass="edInline" EnableClientSideAPI="true" ClientInstanceName="csvModeLabel"></dx:ASPxLabel>
                                                    <dx:ASPxComboBox ID="cboMode" runat="server" CssClass="edInline" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="csvMode">
                                                        <Items>
                                                            <dx:ListEditItem Text="Legacy" Value="Legacy" Selected="false" />
                                                            <dx:ListEditItem Text="Standard mode" Value="Standard" Selected="true" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                </div>
                                                <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="600px">
                                                    <tr>
                                                        <td colspan="2">Report and Page Sections:</td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxRadioButton ID="radioCSVReportExport" runat="server" GroupName="csvReportSections" Text="Export" EnableClientSideAPI="True" ClientInstanceName="csvReportExport">
                                                                <ClientSideEvents CheckedChanged="function(s, e) { setReportIsolate('enable'); }" />                                                                
                                                            </dx:ASPxRadioButton>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkCSVReportIsolate" runat="server" Text="Isolate Report/Page Sections" ClientInstanceName="csvReportIsolate" EnableClientSideAPI="True"></dx:ASPxCheckBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">
                                                            <dx:ASPxRadioButton ID="radioCSVReportDoNotExport" runat="server" GroupName="csvReportSections" Text="Do Not Export" ClientInstanceName="csvReportDoNotExport" EnableClientSideAPI="True">
                                                                <ClientSideEvents CheckedChanged="function(s, e) { setReportIsolate('disable'); }" />
                                                            </dx:ASPxRadioButton>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">Group Sections:</td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxRadioButton ID="radioCSVGroupExport" runat="server" GroupName="csvGroupSections" Text="Export" ClientInstanceName="csvGroupExport" EnableClientSideAPI="True">
                                                                <ClientSideEvents CheckedChanged="function(s, e) { setGroupIsolate('enable'); }" />
                                                            </dx:ASPxRadioButton>
                                                        </td>
                                                        <td>
                                                            <dx:ASPxCheckBox ID="chkCSVGroupIsolate" runat="server" Text="Isolate Report/Page Sections" ClientInstanceName="csvGroupIsolate" EnableClientSideAPI="True"></dx:ASPxCheckBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">
                                                            <dx:ASPxRadioButton ID="radioCSVGroupDoNotExport" runat="server" GroupName="csvGroupSections" Text="Do Not Export" ClientInstanceName="csvGroupDoNotExport" EnableClientSideAPI="True">
                                                                <ClientSideEvents CheckedChanged="function(s, e) { setGroupIsolate('disable'); }" />
                                                            </dx:ASPxRadioButton>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </dx:PanelContent>
                                        </PanelCollection>
                                    </dx:ASPxPanel>
                                    <dx:ASPxPanel ID="pnlPDF" runat="server" Width="600px" ClientInstanceName="pnlPDF" EnableClientSideAPI="True">
                                        <Styles>
                                            <Panel Border-BorderColor="Black" Border-BorderStyle="Solid" Border-BorderWidth="1px">
                                            </Panel>
                                        </Styles>
                                        <PanelCollection>
                                            <dx:PanelContent>
                                                <div style="padding: 10px;">
                                                    <dx:ASPxLabel ID="lblPDFTitle" runat="server" Text="PDF Export Options" Font-Bold="True" Font-Size="Medium"></dx:ASPxLabel>
                                                </div>
                                                <div>
                                                    <dx:ASPxCheckBox ID="chkUsePDFExportOptions" runat="server" Text="Use Custom Export Options?" EnableClientSideAPI="True" ClientInstanceName="UsePDFExportOptions">
                                                        <ClientSideEvents CheckedChanged="function(s, e) { setPDFExportOptions(); }" />
                                                    </dx:ASPxCheckBox>
                                                </div>
                                                <div style="width: 300px;">
                                                    <fieldset>
                                                        <legend>Page range</legend>
                                                        <table class="RSTable" cellspacing="0" cellpadding="5" border="0" width="250px">
                                                            <tr>
                                                                <td style="width: 75px">
                                                                    <dx:ASPxRadioButton ID="radioPDFPageRangeAll" runat="server" GroupName="pdfPageRange" Text="All"
                                                                        ClientInstanceName="radioPDFPageRangeAll" EnableClientSideAPI="True">
                                                                        <ClientSideEvents CheckedChanged="function(s, e) { setPDFPageRange('enable'); }" />
                                                                    </dx:ASPxRadioButton>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="width: 75px">
                                                                    <dx:ASPxRadioButton ID="radioPDFPageRangeFromTo" runat="server" GroupName="pdfPageRange" Text="Page range"
                                                                        ClientInstanceName="radioPDFPageRangeFromTo" EnableClientSideAPI="True">
                                                                        <ClientSideEvents CheckedChanged="function(s, e) { setPDFPageRange('disable'); }" />
                                                                    </dx:ASPxRadioButton>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>From: 
                                                                    <dx:ASPxTextBox ID="ASPxtxtPDFPageRangeFrom" runat="server" Width="50px" Text="1" CssClass="edInline"
                                                                        ClientInstanceName="txtPDFPageRangeFrom" EnableClientSideAPI="true">
                                                                    </dx:ASPxTextBox>
                                                                    To:
                                                                    <dx:ASPxTextBox ID="ASPxtxtPDFPageRangeTo" runat="server" Width="50px" Text="1" CssClass="edInline"
                                                                        ClientInstanceName="txtPDFPageRangeTo" EnableClientSideAPI="true">
                                                                    </dx:ASPxTextBox>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </fieldset>
                                                </div>
                                                <div>
                                                    <dx:ASPxCheckBox ID="ASPxchkPDFCreateBookmarks" runat="server" Text="Create bookmarks from group tree" 
                                                        ClientInstanceName="chkPDFCreateBookmarks" EnableClientSideAPI="true"></dx:ASPxCheckBox>
                                                </div>
                                            </dx:PanelContent>
                                        </PanelCollection>
                                    </dx:ASPxPanel>
                                </td>
							</tr>
							<tr id="DisableLiveDataRow" runat="server">
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobDisableLiveHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Disable Live Data</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<div>
										<asp:RadioButton ID="optLiveDataYes" runat="server" Text="Yes" GroupName="source"></asp:RadioButton>
										<asp:RadioButton ID="optLiveDataNo" runat="server" Text="No" GroupName="source"></asp:RadioButton>
									</div>
								</td>
							</tr>
                            <tr>
                                <td class="FormLabel" style="width: 172px;" valign="top">Save and Send Output
                                </td>
                                <td colspan="2">
                                    <div>
                                        <dx:ASPxCheckBox ID="chkSaveOutput" runat="server" Text="Save and send output only when the following is true"></dx:ASPxCheckBox>
                                        <dx:ASPxRadioButtonList ID="radioSaveOutput" runat="server">
                                            <Items>
                                                <dx:ListEditItem Text="Report is empty" Value="empty" />
                                                <dx:ListEditItem Text="Report has data" Value="datafound" />
                                            </Items>
                                        </dx:ASPxRadioButtonList>
                                    </div>
                                </td>
                            </tr>
							<tr id="rowActive" runat="server">
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobActive.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Active</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<div>
										<asp:CheckBox ID="chkActive" runat="server" ToolTip="Indicates if this job is currently active" Checked="true" />
									</div>
								</td>
							</tr>
                            <tr>
                                <td class="FormLabel" colspan="3">
                                    <asp:Label ID="lblLastExecution" runat="server" Text="Last Execution Date: "></asp:Label>
                                </td>
                            </tr>
                            <tr>
								<td class="FormLabel" colspan="3">
									<asp:Label ID="lblCreated" runat="server" Text="Created by "></asp:Label>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" colspan="3">
									<asp:Label ID="lblModified" runat="server" Text="Last modified by "></asp:Label>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabFolder" Text="Folder & Parameters" ToolTip="Manage the folder and report parameters">
				<ContentCollection>
					<dx:ContentControl ID="tabFolder" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr id="RoleListRow" runat="server">
								<td class="FormLabel" style="width: 357px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobRoleHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Run as Role</td>
										</tr>
										<tr>
											<td>&nbsp;
											</td>
											<td>
												<asp:DropDownList ID="ddlRoleList" runat="server" DataTextField="Role" DataValueField="RoleID">
												</asp:DropDownList>
												<br />
												<asp:CheckBox ID="chkUseEachUserInRole" runat="server"
													Text="Use the UserID for Row Level Security"
													ToolTip="Checking this box will cause the report to loop through the users in the above Role and use their UserID for Row Level Security." />
											</td>
										</tr>
									</table>
								</td>
								<td id="cellReportParameters" valign="top" align="left" rowspan="2" runat="server">
									<span class="FormLabel">Reports Parameters</span><br />
									<uc1:ReportParameters ID="ctlParameters" runat="server"></uc1:ReportParameters>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 356px" valign="top">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('FoldersHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Document Folder</td>
										</tr>
										<tr>
											<td>&nbsp;
											</td>
											<td>
												<telerik:RadTreeView ID="RadTreeFolders" runat="server" Height="100%" Width="100%"
													autopostbackoncheck="True" autopostback="True" imagesbasedir="~/"
													loadingmessageposition="AfterNodeText" CheckBoxes="True" TriStateCheckBoxes="False" CausesValidation="false">
												</telerik:RadTreeView>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
            <dx:TabPage Name="tabOutputFileName" Text="Output File Name" ToolTip="Manage the Output File Name">
                <ContentCollection>
                    <dx:ContentControl ID="tabOutputFileName" runat="server" SupportsDisabledAttribute="True" Width="100%">
                        <table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
                            <tr>
                                <td colspan="2">Use the box below to change the output file name. You can type in any text for the name, but you do not need an extension.
                                    <br />You can also use tokens to dynamically change the name.
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                                <td class="FormLabel" style="width: 130px">Output File Name</td>
                                <td>
                                    <dx:ASPxTextBox ID="txtOutputFileName" runat="server" Width="500px"></dx:ASPxTextBox>
                                </td>
                            </tr>
                            <tr>
                                <td class="FormLabel" style="width: 130px">Date Offset</td>
                                <td>
                                    <dx:ASPxComboBox ID="cboDatePart" runat="server" ValueType="System.String" CssClass="edInline">
                                        <Items>
                                            <dx:ListEditItem Text="Minute" Value="minute" Selected="true" />
                                            <dx:ListEditItem Text="Hour" Value="hour" Selected="false" />
                                            <dx:ListEditItem Text="Day" Value="day" Selected="false" />
                                            <dx:ListEditItem Text="Month" Value="month" Selected="false" />
                                            <dx:ListEditItem Text="Year" Value="year" Selected="false" />
                                        </Items>
                                    </dx:ASPxComboBox>&nbsp;
                                    <dx:ASPxSpinEdit ID="spinDateOffset" runat="server" Number="0" MaxValue="100" MinValue="-100" NumberType="Integer" Width="75px" CssClass="edInline">
                                    </dx:ASPxSpinEdit>
                                    &nbsp; Use the date offset to add or substract the date part selected from the date token.
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                                <td colspan="2">The default name is [FileName]_[Date:yyyy_MM_dd hhmmssff]</td>
                            </tr>
                            <tr>
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                                <td colspan="2">Below are the available tokens that can be used:</td>
                            </tr>
                            <tr>
                                <td style="width: 130px">[FileName]</td>
                                <td>This is the report file name without the extension</td>
                            </tr>
                            <tr>
                                <td style="width: 130px">[JobID]</td>
                                <td>This is the unique Job ID from the first tab</td>
                            </tr>
                            <tr>
                                <td style="width: 130px">[JobDescription]</td>
                                <td>This is the job description from the first tab</td>
                            </tr>
                            <tr>
                                <td style="width: 130px">[DateTime]</td>
                                <td>This is the current date and time formatted with the format of yyyy-MM-dd hhmmss</td>
                            </tr>
                            <tr>
                                <td style="width: 130px">[Date:]</td>
                                <td>This allows you to determine the format of the date and time using the standard date parts.  For example, [Date:yyyy-MM-dd]<br />Note: Do not use forward-slash, backslash or colon since they are not valid in file names.
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 130px">[ParameterX]</td>
                                <td>This will use the value for the parameter with the "X" being substituted with a number.  For example, [Parameter1] will 
                                    get the value for the first parameter.
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <b>Note:</b>  The final name cannot be larger than 255 characters and the file name cannot contain the following special charaters: \ / : * ? < > |
                                </td>
                            </tr>
                        </table>
                    </dx:ContentControl>
                </ContentCollection>
            </dx:TabPage>
            <dx:TabPage Name="tabExternalParams" Text="External Parameters" ToolTip="Get parameters from an external source">
				<ContentCollection>
					<dx:ContentControl ID="tabExternalParams" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr>
								<td colspan="2">External Parameters from another source can be used to provide the report with a list of parameter values.  Each row of parameters will be used to run the report and optionally to email the report to an email address.
								</td>
							</tr>
							<tr>
								<td class="FormLabel">Enabled
								</td>
								<td colspan="2">
									<asp:CheckBox ID="chkExternalParamEnabled" runat="server" Text=""
										ToolTip="Checking this box will enable the external parameters feature"
										AutoPostBack="false" CausesValidation="false" CssClass="FormLabel"></asp:CheckBox>
								</td>
							</tr>

							<tr>
								<td class="FormLabel" colspan="2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobDescHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Setup External Source</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td class="FormLabel">Database Connection
								</td>
								<td colspan="2">
									<asp:DropDownList ID="ddlExternalParamConnection" runat="server" DataTextField="DynamicParameterListName" DataValueField="ID">
									</asp:DropDownList>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" valign="top">
									SQL
								</td>
								<td>
									<asp:TextBox ID="txtExternalParamSQL" runat="server" Rows="5" TextMode="MultiLine" CssClass="FormTextbox"></asp:TextBox>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" valign="top">
									<asp:LinkButton ID="btnTestParams" runat="server" Text="Test Pick List">Test</asp:LinkButton>
								</td>
								<td valign="top">
									<asp:DropDownList ID="ddlTestParams" runat="server">
										<asp:ListItem Value="Use Link at Left to Test List">Use Link at Left to Test</asp:ListItem>
									</asp:DropDownList><br />
									<span id="ctlTestError" style="color: red" runat="server"></span>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" colspan="2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobDescHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Parameter Mapping</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 125px;">
									Parameter 1
								</td>
								<td>
									<asp:TextBox ID="txtExternalParam1" runat="server" CssClass="FormTextbox" MaxLength="100"></asp:TextBox>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 125px;">Parameter 2
								</td>
								<td>
									<asp:TextBox ID="txtExternalParam2" runat="server" CssClass="FormTextbox" MaxLength="100"></asp:TextBox>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 125px;">Parameter 3
								</td>
								<td>
									<asp:TextBox ID="txtExternalParam3" runat="server" CssClass="FormTextbox" MaxLength="100"></asp:TextBox>
								</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
							</tr>
							<tr>
								<td class="FormLabel" colspan="2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobDescHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Email Mapping (optional)</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 125px;">Email Address
								</td>
								<td>
									<asp:TextBox ID="txtExternalParamEmail" runat="server" CssClass="FormTextbox" MaxLength="100"></asp:TextBox>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabSchedule" Text="Schedule" ToolTip="Schedule when the document will run">
				<ContentCollection>
					<dx:ContentControl ID="tabSchedule" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr>
								<td class="FormLabel" valign="top" style="width: 100px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobIntervalHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Schedule Interval</td>
										</tr>
									</table>
								</td>
								<td valign="top" style="width: 100px;">
                                    <dx:ASPxComboBox ID="ASPxcboFrequency" runat="server" ValueType="System.Int32" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="frequency">
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { setScheduleOptions(s); }" Init="function(s, e) { setScheduleOptions(s); }" />
                                        <Items>
                                            <dx:ListEditItem Text="Inactive" Value="0" Selected="false" />
                                            <dx:ListEditItem Text="One Time" Value="3" Selected="false" />
                                            <dx:ListEditItem Text="Minute" Value="8" Selected="false" />
                                            <dx:ListEditItem Text="Hourly" Value="2" Selected="false" />
                                            <dx:ListEditItem Text="Daily" Value="1" Selected="false" />
                                            <dx:ListEditItem Text="Weekly" Value="4" Selected="false" />
                                            <dx:ListEditItem Text="Monthly" Value="5" Selected="false" />
                                            <dx:ListEditItem Text="Quarterly" Value="6" Selected="false" />
                                            <dx:ListEditItem Text="Yearly" Value="7" Selected="false" />
                                        </Items>
                                    </dx:ASPxComboBox>
								</td>
								<td valign="top">
									<div id="ctlMonthOptions" runat="server">
										<table cellspacing="0" cellpadding="2">
											<tr id="rowDay" runat="server">
												<td class="FormLabel">
                                                    <dx:ASPxRadioButton ID="ASPxrdoSpecificDay" runat="server" Text="Day" GroupName="MonthlyOptions" CssClass="edInline" 
                                                        EnableClientSideAPI="true" ClientInstanceName="specificDay">
                                                    </dx:ASPxRadioButton>
                                                    <dx:ASPxComboBox ID="ASPxcboDay" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="true" 
                                                        ClientInstanceName="dayOfMonth" DropDownRows="10" Width="50px" CssClass="edInline">
                                                        <Items>
                                                            <dx:ListEditItem Text="1" Value="1" Selected="false" />
                                                            <dx:ListEditItem Text="2" Value="2" Selected="false" />
                                                            <dx:ListEditItem Text="3" Value="3" Selected="false" />
                                                            <dx:ListEditItem Text="4" Value="4" Selected="false" />
                                                            <dx:ListEditItem Text="5" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="6" Value="6" Selected="false" />
                                                            <dx:ListEditItem Text="7" Value="7" Selected="false" />
                                                            <dx:ListEditItem Text="8" Value="8" Selected="false" />
                                                            <dx:ListEditItem Text="9" Value="9" Selected="false" />
                                                            <dx:ListEditItem Text="10" Value="10" Selected="false" />
                                                            <dx:ListEditItem Text="11" Value="11" Selected="false" />
                                                            <dx:ListEditItem Text="12" Value="12" Selected="false" />
                                                            <dx:ListEditItem Text="13" Value="13" Selected="false" />
                                                            <dx:ListEditItem Text="14" Value="14" Selected="false" />
                                                            <dx:ListEditItem Text="15" Value="15" Selected="false" />
                                                            <dx:ListEditItem Text="16" Value="16" Selected="false" />
                                                            <dx:ListEditItem Text="17" Value="17" Selected="false" />
                                                            <dx:ListEditItem Text="18" Value="18" Selected="false" />
                                                            <dx:ListEditItem Text="19" Value="19" Selected="false" />
                                                            <dx:ListEditItem Text="20" Value="20" Selected="false" />
                                                            <dx:ListEditItem Text="21" Value="21" Selected="false" />
                                                            <dx:ListEditItem Text="22" Value="22" Selected="false" />
                                                            <dx:ListEditItem Text="23" Value="23" Selected="false" />
                                                            <dx:ListEditItem Text="24" Value="24" Selected="false" />
                                                            <dx:ListEditItem Text="25" Value="25" Selected="false" />
                                                            <dx:ListEditItem Text="26" Value="26" Selected="false" />
                                                            <dx:ListEditItem Text="27" Value="27" Selected="false" />
                                                            <dx:ListEditItem Text="28" Value="28" Selected="false" />
                                                            <dx:ListEditItem Text="29" Value="29" Selected="false" />
                                                            <dx:ListEditItem Text="30" Value="30" Selected="false" />
                                                            <dx:ListEditItem Text="31" Value="31" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
												</td>
											</tr>
											<tr id="rowFirstLast" runat="server">
												<td class="FormLabel">
                                                    <dx:ASPxRadioButton ID="ASPxrdoVariable" runat="server" Text="The" GroupName="MonthlyOptions" CssClass="edInline" EnableClientSideAPI="true" ClientInstanceName="variableDay">
                                                    </dx:ASPxRadioButton>
                                                    <dx:ASPxComboBox ID="ASPxcboVariableInterval" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="firstLast" Width="50px" CssClass="edInline">
                                                        <Items>
                                                            <dx:ListEditItem Text="First" Value="0" Selected="false" />
                                                            <dx:ListEditItem Text="Last" Value="1" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                    <dx:ASPxComboBox ID="ASPxcboVariableTarget" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="dayOfWeek" CssClass="edInline">
                                                        <Items>
                                                            <dx:ListEditItem Text="Day" Value="7" Selected="false" />
                                                            <dx:ListEditItem Text="Sunday" Value="0" Selected="false" />
                                                            <dx:ListEditItem Text="Monday" Value="1" Selected="false" />
                                                            <dx:ListEditItem Text="Tuesday" Value="2" Selected="false" />
                                                            <dx:ListEditItem Text="Wednesday" Value="3" Selected="false" />
                                                            <dx:ListEditItem Text="Thursday" Value="4" Selected="false" />
                                                            <dx:ListEditItem Text="Friday" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="Saturday" Value="6" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                </td>
											</tr>
										</table>
									</div>
									<div id="DailyOptions" runat="server">
										<table cellspacing="0" cellpadding="2">
											<tr>
												<td class="FormLabel">Select the days for the jobs to be run<br />
                                                    <dx:ASPxCheckBoxList ID="ASPxchklstDaily" runat="server" ValueType="System.String" 
                                                        RepeatColumns="4" RepeatDirection="Horizontal" Border-BorderStyle="None">
                                                        <Items>
                                                            <dx:ListEditItem Value="1" Text="Monday" />
                                                            <dx:ListEditItem Value="2" Text="Tuesday" />
                                                            <dx:ListEditItem Value="3" Text="Wednesday" />
                                                            <dx:ListEditItem Value="4" Text="Thursday" />
                                                            <dx:ListEditItem Value="5" Text="Friday" />
                                                            <dx:ListEditItem Value="6" Text="Saturday" />
                                                            <dx:ListEditItem Value="7" Text="Sunday" />
                                                        </Items>
                                                        <Border BorderStyle="None"></Border>
                                                    </dx:ASPxCheckBoxList>
                                                </td>
											</tr>
										</table>
									</div>
									<div id="WeeklyOptions" runat="server">
                                        Recurring every <dx:ASPxSpinEdit ID="ASPxspinWeeklyRecurrence" runat="server" Number="1"
                                            MinValue="1" MaxValue="52" CssClass="edInline" Width="50px">
                                        </dx:ASPxSpinEdit> week(s)
									</div>
									<div id="HourlyOptions" runat="server">
										<table cellspacing="0" cellpadding="5">
                                            <!-- New Hourly Interval for 3.6.1.5 -->
                                            <tr>
                                                <td>
                                                    Select the Hourly Interval&nbsp;&nbsp;
                                                    <dx:ASPxComboBox ID="ASPxcboHourlyInterval" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="hourlyInterval" CssClass="edInline" Width="100px">
                                                        <Items>
                                                            <dx:ListEditItem Text="Each hour" Value="1" Selected="false" />
                                                            <dx:ListEditItem Text="Every 2 hours" Value="2" Selected="false" />
                                                            <dx:ListEditItem Text="Every 3 hours" Value="3" Selected="false" />
                                                            <dx:ListEditItem Text="Every 4 hours" Value="4" Selected="false" />
                                                            <dx:ListEditItem Text="Every 5 hours" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="Every 6 hours" Value="6" Selected="false" />
                                                            <dx:ListEditItem Text="Every 7 hours" Value="7" Selected="false" />
                                                            <dx:ListEditItem Text="Every 8 hours" Value="8" Selected="false" />
                                                            <dx:ListEditItem Text="Every 9 hours" Value="9" Selected="false" />
                                                            <dx:ListEditItem Text="Every 10 hours" Value="10" Selected="false" />
                                                            <dx:ListEditItem Text="Every 11 hours" Value="11" Selected="false" />
                                                            <dx:ListEditItem Text="Every 12 hours" Value="12" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>&nbsp;</td>
                                            </tr>
											<tr>
												<td>
                                                    <dx:ASPxCheckBox ID="ASPxchkUseCustomHours" runat="server" Text="Select the hours to run (optional)"
                                                        ToolTip="Checking this box will allow you to set the hours that the report will be run." 
                                                        AutoPostBack="false" ValidationSettings-CausesValidation="false" EnableClientSideAPI="true" 
                                                        ClientInstanceName="useCustomHours">
                                                        <ClientSideEvents CheckedChanged="function(s, e) { setStartEndDropdowns(); }" />
                                                    </dx:ASPxCheckBox>
												</td>
											</tr>
											<tr>
												<td class="FormLabel">Start Time:
                                                    <dx:ASPxComboBox ID="ASPxcboHourlyStartTime" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="ASPxcboHourlyStartTime" CssClass="edInline" Width="75px" ClientEnabled="False">
                                                        <Items>
                                                            <dx:ListEditItem Text="12 AM" Value="24" Selected="true" />
                                                            <dx:ListEditItem Text="1 AM" Value="1" Selected="false" />
                                                            <dx:ListEditItem Text="2 AM" Value="2" Selected="false" />
                                                            <dx:ListEditItem Text="3 AM" Value="3" Selected="false" />
                                                            <dx:ListEditItem Text="4 AM" Value="4" Selected="false" />
                                                            <dx:ListEditItem Text="5 AM" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="6 AM" Value="6" Selected="false" />
                                                            <dx:ListEditItem Text="7 AM" Value="7" Selected="false" />
                                                            <dx:ListEditItem Text="8 AM" Value="8" Selected="false" />
                                                            <dx:ListEditItem Text="9 AM" Value="9" Selected="false" />
                                                            <dx:ListEditItem Text="10 AM" Value="10" Selected="false" />
                                                            <dx:ListEditItem Text="11 AM" Value="11" Selected="false" />
                                                            <dx:ListEditItem Text="12 PM" Value="12" Selected="false" />
                                                            <dx:ListEditItem Text="1 PM" Value="13" Selected="false" />
                                                            <dx:ListEditItem Text="2 PM" Value="14" Selected="false" />
                                                            <dx:ListEditItem Text="3 PM" Value="15" Selected="false" />
                                                            <dx:ListEditItem Text="4 PM" Value="16" Selected="false" />
                                                            <dx:ListEditItem Text="5 PM" Value="17" Selected="false" />
                                                            <dx:ListEditItem Text="6 PM" Value="18" Selected="false" />
                                                            <dx:ListEditItem Text="7 PM" Value="19" Selected="false" />
                                                            <dx:ListEditItem Text="8 PM" Value="20" Selected="false" />
                                                            <dx:ListEditItem Text="9 PM" Value="21" Selected="false" />
                                                            <dx:ListEditItem Text="10 PM" Value="22" Selected="false" />
                                                            <dx:ListEditItem Text="11 PM" Value="23" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
												</td>
												<td class="FormLabel">End Time:
                                                    <dx:ASPxComboBox ID="ASPxcboHourlyEndTime" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="ASPxcboHourlyEndTime" CssClass="edInline" Width="75px" ClientEnabled="False">
                                                        <Items>
                                                            <dx:ListEditItem Text="12 AM" Value="24" Selected="true" />
                                                            <dx:ListEditItem Text="1 AM" Value="1" Selected="false" />
                                                            <dx:ListEditItem Text="2 AM" Value="2" Selected="false" />
                                                            <dx:ListEditItem Text="3 AM" Value="3" Selected="false" />
                                                            <dx:ListEditItem Text="4 AM" Value="4" Selected="false" />
                                                            <dx:ListEditItem Text="5 AM" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="6 AM" Value="6" Selected="false" />
                                                            <dx:ListEditItem Text="7 AM" Value="7" Selected="false" />
                                                            <dx:ListEditItem Text="8 AM" Value="8" Selected="false" />
                                                            <dx:ListEditItem Text="9 AM" Value="9" Selected="false" />
                                                            <dx:ListEditItem Text="10 AM" Value="10" Selected="false" />
                                                            <dx:ListEditItem Text="11 AM" Value="11" Selected="false" />
                                                            <dx:ListEditItem Text="12 PM" Value="12" Selected="false" />
                                                            <dx:ListEditItem Text="1 PM" Value="13" Selected="false" />
                                                            <dx:ListEditItem Text="2 PM" Value="14" Selected="false" />
                                                            <dx:ListEditItem Text="3 PM" Value="15" Selected="false" />
                                                            <dx:ListEditItem Text="4 PM" Value="16" Selected="false" />
                                                            <dx:ListEditItem Text="5 PM" Value="17" Selected="false" />
                                                            <dx:ListEditItem Text="6 PM" Value="18" Selected="false" />
                                                            <dx:ListEditItem Text="7 PM" Value="19" Selected="false" />
                                                            <dx:ListEditItem Text="8 PM" Value="20" Selected="false" />
                                                            <dx:ListEditItem Text="9 PM" Value="21" Selected="false" />
                                                            <dx:ListEditItem Text="10 PM" Value="22" Selected="false" />
                                                            <dx:ListEditItem Text="11 PM" Value="23" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
												</td>
											</tr>
										</table>
									</div>
                                    <div id="MinuteOptions" runat="server">
                                        <table cellspacing="0" cellpadding="5">
                                            <!-- New Minute Interval for 3.20.10.1 -->
                                            <tr>
                                                <td>Select the Minute Interval&nbsp;&nbsp;
                                                    <dx:ASPxComboBox ID="ASPxcboMinuteInterval" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="minuteInterval" CssClass="edInline" Width="100px">
                                                        <Items>
                                                            <dx:ListEditItem Text="5 Minutes" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="10 Minutes" Value="10" Selected="false" />
                                                            <dx:ListEditItem Text="15 Minutes" Value="15" Selected="false" />
                                                            <dx:ListEditItem Text="20 Minutes" Value="20" Selected="false" />
                                                            <dx:ListEditItem Text="25 Minutes" Value="25" Selected="false" />
                                                            <dx:ListEditItem Text="30 Minutes" Value="30" Selected="false" />
                                                            <dx:ListEditItem Text="35 Minutes" Value="35" Selected="false" />
                                                            <dx:ListEditItem Text="40 Minutes" Value="40" Selected="false" />
                                                            <dx:ListEditItem Text="45 Minutes" Value="45" Selected="false" />
                                                            <dx:ListEditItem Text="50 Minutes" Value="50" Selected="false" />
                                                            <dx:ListEditItem Text="55 Minutes" Value="55" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 100px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobBeginDateHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Begin on Date</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<dx:ASPxDateEdit ID="ASPxDateBegin" runat="server">
									</dx:ASPxDateEdit>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 100px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobStartTimeHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Start Time</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<asp:DropDownList ID="ddlHour" runat="server">
										<asp:ListItem Text="1" Value="1" />
										<asp:ListItem Text="2" Value="2" />
										<asp:ListItem Text="3" Value="3" />
										<asp:ListItem Text="4" Value="4" />
										<asp:ListItem Text="5" Value="5" />
										<asp:ListItem Text="6" Value="6" />
										<asp:ListItem Text="7" Value="7" />
										<asp:ListItem Text="8" Value="8" />
										<asp:ListItem Text="9" Value="9" />
										<asp:ListItem Text="10" Value="10" />
										<asp:ListItem Text="11" Value="11" />
										<asp:ListItem Text="12" Value="12" />
									</asp:DropDownList>
									<asp:DropDownList ID="ddlMinute" runat="server">
										<asp:ListItem Text="00" Value="0" />
										<asp:ListItem Text="01" Value="1" />
										<asp:ListItem Text="02" Value="2" />
										<asp:ListItem Text="03" Value="3" />
										<asp:ListItem Text="04" Value="4" />
										<asp:ListItem Text="05" Value="5" />
										<asp:ListItem Text="06" Value="6" />
										<asp:ListItem Text="07" Value="7" />
										<asp:ListItem Text="08" Value="8" />
										<asp:ListItem Text="09" Value="9" />
										<asp:ListItem Text="10" Value="10" />
										<asp:ListItem Text="11" Value="11" />
										<asp:ListItem Text="12" Value="12" />
										<asp:ListItem Text="13" Value="13" />
										<asp:ListItem Text="14" Value="14" />
										<asp:ListItem Text="15" Value="15" />
										<asp:ListItem Text="16" Value="16" />
										<asp:ListItem Text="17" Value="17" />
										<asp:ListItem Text="18" Value="18" />
										<asp:ListItem Text="19" Value="19" />
										<asp:ListItem Text="20" Value="20" />
										<asp:ListItem Text="21" Value="21" />
										<asp:ListItem Text="22" Value="22" />
										<asp:ListItem Text="23" Value="23" />
										<asp:ListItem Text="24" Value="24" />
										<asp:ListItem Text="25" Value="25" />
										<asp:ListItem Text="26" Value="26" />
										<asp:ListItem Text="27" Value="27" />
										<asp:ListItem Text="28" Value="28" />
										<asp:ListItem Text="29" Value="29" />
										<asp:ListItem Text="30" Value="30" />
										<asp:ListItem Text="31" Value="31" />
										<asp:ListItem Text="32" Value="32" />
										<asp:ListItem Text="33" Value="33" />
										<asp:ListItem Text="34" Value="34" />
										<asp:ListItem Text="35" Value="35" />
										<asp:ListItem Text="36" Value="36" />
										<asp:ListItem Text="37" Value="37" />
										<asp:ListItem Text="38" Value="38" />
										<asp:ListItem Text="39" Value="39" />
										<asp:ListItem Text="40" Value="40" />
										<asp:ListItem Text="41" Value="41" />
										<asp:ListItem Text="42" Value="42" />
										<asp:ListItem Text="43" Value="43" />
										<asp:ListItem Text="44" Value="44" />
										<asp:ListItem Text="45" Value="45" />
										<asp:ListItem Text="46" Value="46" />
										<asp:ListItem Text="47" Value="47" />
										<asp:ListItem Text="48" Value="48" />
										<asp:ListItem Text="49" Value="49" />
										<asp:ListItem Text="50" Value="50" />
										<asp:ListItem Text="51" Value="51" />
										<asp:ListItem Text="52" Value="52" />
										<asp:ListItem Text="53" Value="53" />
										<asp:ListItem Text="54" Value="54" />
										<asp:ListItem Text="55" Value="55" />
										<asp:ListItem Text="56" Value="56" />
										<asp:ListItem Text="57" Value="57" />
										<asp:ListItem Text="58" Value="58" />
										<asp:ListItem Text="59" Value="59" />
									</asp:DropDownList>
									<asp:DropDownList ID="ddlAmPm" runat="server">
										<asp:ListItem Text="AM" Value="AM" />
										<asp:ListItem Text="PM" Value="PM" />
									</asp:DropDownList>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 100px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobEndDateHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">End on Date</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<dx:ASPxDateEdit ID="ASPxDateEnd" runat="server">
									</dx:ASPxDateEdit>
								</td>
							</tr>
							<tr>
								<td>&nbsp;
								</td>
							</tr>
						</table>
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr>
								<td colspan="2">Scheduled History
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 220px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleHistoryHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Schedule History Duration</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:TextBox ID="txtScheduleHistoryDuration" runat="server" Width="64px" CssClass="FormTextbox"></asp:TextBox>
									<asp:RangeValidator ID="valScheduleHistoryDuration" runat="server" ControlToValidate="txtScheduleHistoryDuration"
										ErrorMessage="The duration value must be between 1 and 1000" Display="Dynamic"
										Type="Integer" MinimumValue="1" MaximumValue="1000">The duration value must be between 1 and 1000</asp:RangeValidator>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 220px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleHistoryHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Schedule History Type</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:DropDownList ID="ddlScheduleHistoryType" runat="server" Width="168px">
										<asp:ListItem Value=""></asp:ListItem>
										<asp:ListItem Value="items">Items</asp:ListItem>
										<asp:ListItem Value="days">Days</asp:ListItem>
										<asp:ListItem Value="off">Off</asp:ListItem>
									</asp:DropDownList>
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<asp:Button ID="btnCleanHistory" runat="server" Width="184px" CausesValidation="False"
										Text="Clean Scheduled History"></asp:Button>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabEmail" Text="Email" ToolTip="Manage the how this report will be emailed">
				<ContentCollection>
					<dx:ContentControl ID="tabEmail" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobEmailHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Email Report</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:RadioButtonList ID="optIsEmailReport" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
										<asp:ListItem Value="Y">Yes</asp:ListItem>
										<asp:ListItem Value="N">No</asp:ListItem>
									</asp:RadioButtonList>
								</td>
							</tr>
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobFromHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">From</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:TextBox ID="txtMailFrom" runat="server" CssClass="FormTextbox" Width="100%"></asp:TextBox>
                                    <asp:Label ID="lblMailFromValidate" runat="server" Visible="False" ForeColor="#ff0000"></asp:Label>
								</td>
							</tr>
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
                                        <tr>
                                            <td style="width: 21px;"><a href="javascript:void(0)" onclick="callHelp('ScheduleJobToHelp.htm')" tabindex="-1">
                                                <img alt="Help" src="images/help3.gif" />
                                                </a></td>
                                            <td class="FormLabel" valign="top">To</td>
                                        </tr>
                                    </table>
								</td>
								<td>
									<asp:TextBox ID="txtSendMailTo" runat="server" CssClass="FormTextbox" Width="100%" Height="50px" TextMode="MultiLine" Rows="3"></asp:TextBox>
                                    <asp:Label ID="lblMailToValidate" runat="server" Visible="False" ForeColor="#ff0000"></asp:Label>
								</td>
							</tr>
							<tr>
								<td class="auto-style2">&nbsp;</td>
								<td>
									<asp:CheckBox ID="chkUseRoleForEmail" runat="server" Text="Use the Roles for the Email"
										ToolTip="Checking this box will cause the report to loop through the users in the above Role and use their email address for sending the report."></asp:CheckBox>
								</td>
							</tr>
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobSubjectHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Subject</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:TextBox ID="txtMailSubject" runat="server" CssClass="FormTextbox" Width="100%"></asp:TextBox>
                                    <asp:Label ID="lblMailSubjectValidate" runat="server" Visible="False" ForeColor="#ff0000"></asp:Label>
								</td>
							</tr>
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobMessgeHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Message</td>
										</tr>
									</table>
								</td>
								<td>
									<dx:ASPxHtmlEditor ID="ASPxHtmlMail" runat="server" ToolbarMode="Ribbon" Width="100%">
<SettingsHtmlEditing>
<PasteFiltering Attributes="class"></PasteFiltering>
</SettingsHtmlEditing>
                                    </dx:ASPxHtmlEditor>
								</td>
								<td>&nbsp;</td>
							</tr>
							<tr>
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('MinimalHomePage.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel" style="width: 200px">Email messages one at a time:
											</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:DropDownList ID="ddlEmailOneAtATime" runat="server">
										<asp:ListItem Selected="True" Value="global">Use Global Setting</asp:ListItem>
										<asp:ListItem Value="yes">Yes</asp:ListItem>
										<asp:ListItem Value="no">No</asp:ListItem>
									</asp:DropDownList>
								</td>
							</tr>
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobSubjectHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Add Unsubscribe Link</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:CheckBox ID="chkUnsubscribe" runat="server" Text=""
										ToolTip="Checking this box will add a unsubscribe hyperlink to the email message." AutoPostBack="true">
									</asp:CheckBox><br />
									<asp:TextBox ID="txtUnsubscribe" runat="server" CssClass="FormTextbox" TextMode="MultiLine" Rows="3" Width="50%"></asp:TextBox>
								</td>
							</tr>
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobSubjectHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Add Run Report Link</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:CheckBox ID="chkRunReport" runat="server" Text="" AutoPostBack="true"
										ToolTip="Checking this box will add a run report hyperlink to the email message."></asp:CheckBox><br />
									<asp:TextBox ID="txtRunReport" runat="server" CssClass="FormTextbox" TextMode="MultiLine" Rows="3" Width="50%"></asp:TextBox>
								</td>
							</tr>
							<tr valign="top">
								<td class="auto-style2">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobSubjectHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Add Edit Schedule Link</td>
										</tr>
									</table>
								</td>
								<td>
									<asp:CheckBox ID="chkEditSchedule" runat="server" Text="" AutoPostBack="true"
										ToolTip="Checking this box will add an edit schedule hyperlink to the email message for users that have permissions to edit the scheduled job."></asp:CheckBox><br />
									<asp:TextBox ID="txtEditSchedule" runat="server" CssClass="FormTextbox" TextMode="MultiLine" Rows="3" Width="50%"></asp:TextBox>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabAlert" Text="Alert Report" ToolTip="Manage any alert information for the report">
				<ContentCollection>
					<dx:ContentControl ID="tabAlert" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr valign="top">
								<td class="FormLabel" style="width: 200px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobAlertHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Alert Report</td>
										</tr>
									</table>
								</td>
								<td>
									<div style="width: 175px">
                                        <dx:ASPxRadioButtonList ID="rdoIsAlert" runat="server" ValueType="System.String" RepeatDirection="Horizontal" EnableClientSideAPI="true">
                                            <Items>
                                                <dx:ListEditItem Text="Yes" Value="yes" />
                                                <dx:ListEditItem Text="No" Value="no" Selected="true" />
                                            </Items>
                                        </dx:ASPxRadioButtonList>
<%--										<input id="ctlIsAlertReportYes" onclick="setEmailReport(this)" type="radio" value="Y"
											name="ctlIsAlertReport" runat="server" />Yes
										<input id="ctlIsAlertReportNo" onclick="setEmailReport(this)" type="radio" value="N"
											name="ctlIsAlertReport" runat="server" />No--%>
									</div>
								</td>
							</tr>
							<tr valign="top">
								<td class="FormLabel" style="width: 200px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobSaveEmptyAlertHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Save Alerts with No Data in History</td>
										</tr>
									</table>
								</td>
								<td>
									<div style="width: 175px">
                                        <dx:ASPxRadioButtonList ID="rdoSaveEmptyAlert" runat="server" ValueType="System.String" RepeatDirection="Horizontal">
                                            <Items>
                                                <dx:ListEditItem Text="Yes" Value="yes" />
                                                <dx:ListEditItem Text="No" Value="no" Selected="true" />
                                            </Items>
                                        </dx:ASPxRadioButtonList>
									</div>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 200px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobFilterHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Filter Column</td>
										</tr>
									</table>
								</td>
								<td>
                                    <dx:ASPxComboBox ID="cboAlertColumnList" runat="server" ValueType="System.String" AutoPostBack="false"></dx:ASPxComboBox>
								</td>
							</tr>
							<tr>
								<td colspan="2">
                                    <asp:ObjectDataSource ID="dataAlerts" runat="server" DeleteMethod="DeleteAlertDetailByID" InsertMethod="InsertAlertDetail"
                                        SelectMethod="GetAlertDetailsByJobID" TypeName="Ripplestone.BLL.AlertDetail" UpdateMethod="UpdateAlertDetail">
                                        <SelectParameters>
                                            <asp:ControlParameter DefaultValue="0" ControlID="lblJobID" Name="jobID" PropertyName="text" Type="Int32" />
                                        </SelectParameters>
                                        <DeleteParameters>
                                            <asp:Parameter Name="ID" Type="Int32" />
                                        </DeleteParameters>
                                        <InsertParameters>
                                            <asp:Parameter Name="jobID" Type="Int32" />
                                            <asp:Parameter Name="alertOperator" Type="String" />
                                            <asp:Parameter Name="selectionValue" Type="String" />
                                            <asp:Parameter Name="receiverEmail" Type="String" />
                                        </InsertParameters>
                                        <UpdateParameters>
                                            <asp:Parameter Name="ID" Type="Int32" />
                                            <asp:Parameter Name="jobID" Type="Int32" />
                                            <asp:Parameter Name="alertOperator" Type="String" />
                                            <asp:Parameter Name="selectionValue" Type="String" />
                                            <asp:Parameter Name="receiverEmail" Type="String" />
                                        </UpdateParameters>
                                    </asp:ObjectDataSource>
                                    <asp:ObjectDataSource ID="dataOperators" runat="server" SelectMethod="GetOperators" TypeName="Ripplestone.BLL.Operators">
                                    </asp:ObjectDataSource>
                                    <dx:ASPxGridView ID="grdAlerts" runat="server" AutoGenerateColumns="False" DataSourceID="dataAlerts" KeyFieldName="ID" Width="100%">

<SettingsPopup>
<HeaderFilter MinHeight="140px"></HeaderFilter>
</SettingsPopup>
                                        <Columns>
                                            <dx:GridViewDataTextColumn FieldName="ID" ReadOnly="True" VisibleIndex="0" Width="25px">
                                                <EditFormSettings Visible="False" />
                                            </dx:GridViewDataTextColumn>
                                            <dx:GridViewDataComboBoxColumn FieldName="AlertOperator" VisibleIndex="1">
                                                <PropertiesComboBox MaxLength="50" DataSourceID="dataOperators" TextField="AlertOperator" ValueField="AlertOperator">
                                                </PropertiesComboBox>
                                            </dx:GridViewDataComboBoxColumn>
                                            <dx:GridViewDataTextColumn FieldName="SelectionValue" VisibleIndex="2">
                                                <PropertiesTextEdit MaxLength="255">
                                                </PropertiesTextEdit>
                                            </dx:GridViewDataTextColumn>
                                            <dx:GridViewDataTextColumn FieldName="ReceiverEmail" VisibleIndex="3">
                                                <PropertiesTextEdit MaxLength="255">
                                                </PropertiesTextEdit>
                                            </dx:GridViewDataTextColumn>
                                            <dx:GridViewCommandColumn ButtonType="Button" ShowDeleteButton="True" ShowEditButton="True" ShowNewButtonInHeader="True" VisibleIndex="4" Width="150px">
                                            </dx:GridViewCommandColumn>
                                        </Columns>
                                        <SettingsBehavior ConfirmDelete="True" />
                                        <SettingsCommandButton>
                                            <EditButton ButtonType="Button">
                                            </EditButton>
                                        </SettingsCommandButton>
                                    </dx:ASPxGridView>
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabUnmanaged" Text="Unmanaged Output" ToolTip="Manage if any unmanaged output is created">
				<ContentCollection>
					<dx:ContentControl ID="tabUnmanaged" runat="server" SupportsDisabledAttribute="True" Width="100%">
                        <dx:ASPxRoundPanel ID="pnlUnmanagedOutput" runat="server" ShowCollapseButton="False" Width="100%" View="GroupBox" HeaderText="Unmanaged Output">
                            <PanelCollection>
                                <dx:PanelContent>
                                    <table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
                                        <tr valign="top">
                                            <td class="FormLabel" style="width: 188px">
                                                <table width="100%">
                                                    <tr>
                                                        <td style="width: 21px;">
                                                            <a onclick="callHelp('ScheduleJobUnmanagedYNHelp.htm')" href="javascript:void(0)" tabindex="-1">
                                                                <img alt="Help" src="images/help3.gif" /></a>
                                                        </td>
                                                        <td class="FormLabel">Unmanaged Output</td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td>
                                                <dx:ASPxRadioButtonList ID="rdoUnmanagedOutput" runat="server" ValueType="System.String" RepeatDirection="Horizontal">
                                                    <Items>
                                                        <dx:ListEditItem Text="Yes" Value="yes" />
                                                        <dx:ListEditItem Text="No" Value="no" Selected="true" />
                                                    </Items>
                                                </dx:ASPxRadioButtonList>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td style="width: 188px">
                                                <table width="100%">
                                                    <tr>
                                                        <td valign="top" style="width: 21px;">
                                                            <a onclick="callHelp('ScheduleJobOutputFileHelp.htm')" href="javascript:void(0)" tabindex="-1">
                                                                <img alt="Help" src="images/help3.gif" /></a>
                                                        </td>
                                                        <td class="FormLabel">Output File Name<br />
                                                            (complete path)</td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td>You can use a date token in the output file name to allow the current date to be added when the file is created.<br />
                                                To use the token add [DATE] to the file name. For example, \\servername\sharename\files\report_[DATE].pdf<br />
                                                <dx:ASPxTextBox ID="ASPxUnmanagedFileName" runat="server" MaxLength="255" Width="600px"></dx:ASPxTextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>&nbsp;</td>
                                            <td>
                                                <dx:ASPxCheckBox ID="chkUseOutputFileName" runat="server" Text="Use the same name as the Output File Name"></dx:ASPxCheckBox>
                                            </td>
                                        </tr>
                                    </table>
                                </dx:PanelContent>
                            </PanelCollection>
                        </dx:ASPxRoundPanel>
                        <br />
                        <dx:ASPxRoundPanel ID="pnlFTP" runat="server" ShowCollapseButton="False" Width="100%" View="GroupBox" HeaderText="FTP">
                            <PanelCollection>
                                <dx:PanelContent>
                                    <table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
                                        <tr>
                                            <td></td>
                                            <td>Send the output to a FTP Server</td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Type</td>
                                            <td>
                                                <dx:ASPxRadioButtonList ID="ASPxrdoFTPType" runat="server" ValueType="System.String" RepeatDirection="Horizontal">
                                                    <Items>
                                                        <dx:ListEditItem Text="Standard" Value="standard" Selected="true" />
                                                        <dx:ListEditItem Text="SFTP" Value="sftp" />
                                                    </Items>
                                                </dx:ASPxRadioButtonList>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Hostname</td>
                                            <td>
                                                <dx:ASPxTextBox ID="ASPxtxtHostname" runat="server" MaxLength="255" Width="300px"></dx:ASPxTextBox>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Port</td>
                                            <td>
                                                <dx:ASPxTextBox ID="ASPxtxtFTPPort" runat="server" Width="50px" MaxLength="50"></dx:ASPxTextBox>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Transfer Type</td>
                                            <td>
                                                <dx:ASPxComboBox ID="cboTransferType" runat="server" ValueType="System.String" CssClass="edInline">
                                                    <Items>
                                                        <dx:ListEditItem Text="Binary" Value="BINARY" Selected="true" />
                                                        <dx:ListEditItem Text="Ascii" Value="ASCII" Selected="false" />
                                                    </Items>
                                                </dx:ASPxComboBox>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Connection Mode</td>
                                            <td>
                                                <dx:ASPxComboBox ID="cboConnectMode" runat="server" ValueType="System.String" CssClass="edInline">
                                                    <Items>
                                                        <dx:ListEditItem Text="Active" Value="active" Selected="true" />
                                                        <dx:ListEditItem Text="Passive" Value="passive" Selected="false" />
                                                    </Items>
                                                </dx:ASPxComboBox>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Username</td>
                                            <td>
                                                <dx:ASPxTextBox ID="ASPxtxtUsername" runat="server" Width="250px" MaxLength="255"></dx:ASPxTextBox>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Password</td>
                                            <td>
                                                <dx:ASPxTextBox ID="ASPxtxtFTPPassword" runat="server" Width="250px" MaxLength="255" Password="true"></dx:ASPxTextBox>
                                                <dx:ASPxTextBox ID="ASPxtxtCurrentPassword" runat="server" Visible="false"></dx:ASPxTextBox>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP Remote Folder</td>
                                            <td>
                                                <dx:ASPxTextBox ID="ASPxtxtFTPRemoteFolder" runat="server" Width="350px" MaxLength="255"></dx:ASPxTextBox>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="FormLabel">FTP File Name</td>
                                            <td>Check this box to use the Output File Name.<br />
                                                If the box is unchecked, then enter a filename below<br />
                                                <dx:ASPxCheckBox ID="ASPxchkFTPFilename" runat="server" ClientInstanceName="chkFTPFileName" EnableClientSideAPI="True">
                                                    <ClientSideEvents CheckedChanged="function(s, e) { enableFTPFileName(); }" />
                                                </dx:ASPxCheckBox>
                                                <dx:ASPxTextBox ID="ASPxtxtFTPFileName" runat="server" Width="250px" MaxLength="255" ClientInstanceName="ASPxtxtFTPFileName" EnableClientSideAPI="true" ClientEnabled="False"></dx:ASPxTextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </dx:PanelContent>
                            </PanelCollection>
                        </dx:ASPxRoundPanel>
                        <br />
                        <dx:ASPxRoundPanel ID="pnlPrinter" runat="server" ShowCollapseButton="False" Width="100%" View="GroupBox" HeaderText="Printer">
                            <PanelCollection>
                                <dx:PanelContent>
                                    <table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
                                        <tr id="PrinterRow" valign="top" runat="server">
                                            <td style="width: 188px">
                                                <table width="100%">
                                                    <tr>
                                                        <td valign="top" style="width: 21px;">
                                                            <a onclick="callHelp('ScheduleJobPrinterHelp.htm')" href="javascript:void(0)" tabindex="-1">
                                                                <img alt="Help" src="images/help3.gif" /></a>
                                                        </td>
                                                        <td class="FormLabel">Printer Name</td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td>
                                                <asp:DropDownList ID="ddlPrinters" runat="server" Width="250" AutoPostBack="True">
                                                </asp:DropDownList>
                                                &nbsp;
									            <asp:TextBox ID="txtPrinter" runat="server" Width="50%" MaxLength="255"></asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </dx:PanelContent>
                            </PanelCollection>
                        </dx:ASPxRoundPanel>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
		</TabPages>
		<LoadingPanelImage Url="~/App_Themes/Office2010Blue/Web/Loading.gif">
		</LoadingPanelImage>
		<LoadingPanelStyle ImageSpacing="5px">
		</LoadingPanelStyle>
		<Paddings Padding="2px" PaddingLeft="5px" PaddingRight="5px" />
		<ContentStyle>
			<Border BorderColor="#859EBF" BorderStyle="Solid" BorderWidth="1px" />
			<Border BorderColor="#859EBF" BorderStyle="Solid" BorderWidth="1px"></Border>
			<Paddings Padding="12px"></Paddings>
			<Paddings Padding="12px" />
		</ContentStyle>
	</dx:ASPxPageControl>
	<br />
	<div>
		<asp:Button ID="btnSave" runat="server" Width="65px" Text="Save"></asp:Button>&nbsp;
		<asp:Button ID="btnCancel" runat="server" Width="65px" Text="Cancel" CausesValidation="False">
		</asp:Button>
	</div>
	<div>
		<asp:Label ID="lblValidationSummary" runat="server" ForeColor="Red" Visible="False"></asp:Label>
		<asp:ValidationSummary ID="ValidationSummary1" runat="server" />
	</div>
</asp:Content>
