﻿<%@ Page Title="Manage Scheduled Group" Language="vb" AutoEventWireup="false" MasterPageFile="~/RSMasterPage.master" 
        CodeBehind="EditScheduleGroup.aspx.vb" Inherits="RSWebApp.EditScheduleGroup" %>
<%@ Register Assembly="SCS.PickList" Namespace="SCS.Web.UI.WebControls" TagPrefix="cc1" %>
<%@ Register assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" namespace="DevExpress.Web" tagprefix="dx" %>

<%@ Register assembly="DevExpress.Web.ASPxHtmlEditor.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" namespace="DevExpress.Web.ASPxHtmlEditor" tagprefix="dx" %>
<%@ Register assembly="DevExpress.Web.ASPxSpellChecker.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" namespace="DevExpress.Web.ASPxSpellChecker" tagprefix="dx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <style type="text/css">
		div.explain
		{
			border-right: 0px solid;
			border-top: 0px solid;
			margin-bottom: 0px;
			margin-left: 5px;
			border-left: 0px solid;
			border-bottom: 0px solid;
		}
		div.HideMonth
		{
			padding-right: 0px;
			display: none;
			padding-left: 0px;
			padding-bottom: 0px;
			margin: 0px;
			padding-top: 0px;
		}
		div.ShowMonth
		{
			padding-right: 0px;
			display: block;
			padding-left: 0px;
			padding-bottom: 0px;
			margin: 0px;
			padding-top: 0px;
		}
        .edInline
        {
            display: inline-table;
        }
	</style>
    <script type="text/javascript">
        // Added new script for the frequency dropdown
        // Jeff Lyon - 10/28/2016 - version 3.7.1.6
        function SetFrequencyOptions(s) {
            var cboValue = s.GetValue();
            var ctlMonthOptions = document.getElementById('ctl00_MainContent_ASPxPageControl1_ctlMonthOptions');
            var ctlDailyOptions = document.getElementById('ctl00_MainContent_ASPxPageControl1_DailyOptions');
            var rowDay = document.getElementById('ctl00_MainContent_ASPxPageControl1_rowDay');
            //var ctlVariable = document.getElementById('ctl00_MainContent_ASPxPageControl1_ASPxrdoVariable');

            if (cboValue == 0) // inactive
            {
                ctlMonthOptions.style.display = 'none';
                ctlDailyOptions.style.display = 'none';
            }

            if (cboValue == 1) // daily
            {
                ctlMonthOptions.style.display = 'none';
                ctlDailyOptions.style.display = 'block';
            }

            if (cboValue == 2) // hourly
            {
                ctlMonthOptions.style.display = 'none';
                ctlDailyOptions.style.display = 'none';
            }

            if (cboValue == 3) // onetime
            {
                ctlMonthOptions.style.display = 'none';
                ctlDailyOptions.style.display = 'none';
            }

            if (cboValue == 4) // weekly
            {
                ctlMonthOptions.style.display = 'none';
                ctlDailyOptions.style.display = 'none';
            }

            if (cboValue == 5) // monthly
            {
                ctlMonthOptions.style.display = 'block';
                ctlDailyOptions.style.display = 'none';
                variableDay.SetVisible(true);
                //ctlVariable.style.display = 'inline';
                rowDay.style.display = 'block';
            }

            if (cboValue == 6) // Quarterly
            {
                ctlMonthOptions.style.display = 'block';
                ctlDailyOptions.style.display = 'none';
                variableDay.SetVisible(false);
                //ctlVariable.style.display = 'none';
                rowDay.style.display = 'none';
            }

            if (cboValue == 7) // yearly
            {
                ctlMonthOptions.style.display = 'none';
                ctlDailyOptions.style.display = 'none';
            }

        }

        function AddSelectedItems() {
            MoveSelectedItems(lbAvailable, lbChoosen);
            UpdateButtonState();
        }
        function AddAllItems() {
            MoveAllItems(lbAvailable, lbChoosen);
            UpdateButtonState();
        }
        function RemoveSelectedItems() {
            MoveSelectedItems(lbChoosen, lbAvailable);
            UpdateButtonState();
        }
        function RemoveAllItems() {
            MoveAllItems(lbChoosen, lbAvailable);
            UpdateButtonState();
        }
        function MoveSelectedItems(srcListBox, dstListBox) {
            srcListBox.BeginUpdate();
            dstListBox.BeginUpdate();
            var items = srcListBox.GetSelectedItems();
            for(var i = items.length - 1; i >= 0; i = i - 1) {
                dstListBox.AddItem(items[i].text, items[i].value);
                srcListBox.RemoveItem(items[i].index);
            }
            srcListBox.EndUpdate();
            dstListBox.EndUpdate();
        }
        function MoveAllItems(srcListBox, dstListBox) {
            srcListBox.BeginUpdate();
            var count = srcListBox.GetItemCount();
            for(var i = 0; i < count; i++) {
                var item = srcListBox.GetItem(i);
                dstListBox.AddItem(item.text, item.value);
            }
            srcListBox.EndUpdate();
            srcListBox.ClearItems();
        }
        function UpdateButtonState() {
            btnMoveAllItemsToRight.SetEnabled(lbAvailable.GetItemCount() > 0);
            btnMoveAllItemsToLeft.SetEnabled(lbChoosen.GetItemCount() > 0);
            btnMoveSelectedItemsToRight.SetEnabled(lbAvailable.GetSelectedItems().length > 0);
            btnMoveSelectedItemsToLeft.SetEnabled(lbChoosen.GetSelectedItems().length > 0);
        }
    </script>

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="nav2">
		<a class="nav2left" onclick="callHelp('SchedulingHowToHelp.htm')" href="javascript:void(0)">
			<img alt="Help" src="images/help3.gif" /></a> <span class="nav2title">Manage Scheduled Group</span>
	</div>
	<dx:ASPxPageControl ID="ASPxPageControl1" runat="server" ActiveTabIndex="0" TabSpacing="0px" Width="100%" EnableClientSideAPI="True" ClientInstanceName="HomeTabs" EnableTheming="True">
		<Paddings Padding="2px" PaddingLeft="5px" PaddingRight="5px"></Paddings>
		<TabPages>
			<dx:TabPage Name="tabDocument" Text="General" ToolTip="Manage the general information">
				<ContentCollection>
					<dx:ContentControl ID="tabDocument" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr id="GroupIDRow" runat="server">
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobIdHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Group ID
											</td>
										</tr>
									</table>
								</td>
								<td>
									<dx:ASPxLabel ID="lblGroupID" runat="server">
                                    </dx:ASPxLabel>
								</td>
							</tr>
							<tr id="GroupDescriptionRow" runat="server">
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobDescHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Group Description
											</td>
										</tr>
									</table>
								</td>
								<td>
									<dx:ASPxTextBox ID="txtGroupDescription" runat="server" Width="90%">
                                        <ValidationSettings Display="Dynamic" ErrorDisplayMode="ImageWithText">
                                            <RequiredField ErrorText="Description is required" IsRequired="true" />
                                        </ValidationSettings>
                                    </dx:ASPxTextBox>
								</td>
							</tr>
							<tr>
                                <td class="FormLabel" style="width: 172px;" valign="top">
                                    <table width="100%">
                                        <tr>
                                            <td style="width: 21px;" valign="top">
                                                <a onclick="callHelp('ScheduleJobDescHelp.htm')" href="javascript:void(0)" tabindex="-1">
                                                    <img alt="Help" src="images/help3.gif" /></a>
                                            </td>
                                            <td class="FormLabel" valign="top">Run as Role
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td>
                                    <dx:ASPxComboBox ID="ASPxcboRoleList" runat="server" ValueType="System.Int32" TextField="Role" ValueField="ID" AutoPostBack="false">
                                    </dx:ASPxComboBox>
                                    <br />
                                    <dx:ASPxCheckBox ID="ASPxchkUseEachUserInRole" runat="server" 
                                        Text="Use the UserID for Row Level Security" 
                                        ToolTip="Checking this box will cause the report to loop through the users in the Role use their UserID for Row Level Security."></dx:ASPxCheckBox>
                                </td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabSchedule" Text="Schedule" ToolTip="Schedule when the group will run">
				<ContentCollection>
					<dx:ContentControl ID="tabSchedule" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
                            <tr>
								<td class="FormLabel" valign="top" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobIntervalHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Schedule Interval
											</td>
										</tr>
									</table>
								</td>
								<td valign="top" style="width: 200px;">
                                    <dx:ASPxComboBox ID="ASPxcboFrequency" runat="server" ValueType="System.Int32" AutoPostBack="false" EnableClientSideAPI="True" ClientInstanceName="frequency">
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { SetFrequencyOptions(s); }" Init="function(s, e) { SetFrequencyOptions(s); }" />
                                        <Items>
                                            <dx:ListEditItem Text="Inactive" Value="0" Selected="false" />
                                            <dx:ListEditItem Text="One Time" Value="3" Selected="false" />
                                            <dx:ListEditItem Text="Hourly" Value="2" Selected="false" />
                                            <dx:ListEditItem Text="Daily" Value="1" Selected="false" />
                                            <dx:ListEditItem Text="Weekly" Value="4" Selected="false" />
                                            <dx:ListEditItem Text="Monthly" Value="5" Selected="false" />
                                            <dx:ListEditItem Text="Quarterly" Value="6" Selected="false" />
                                        </Items>
                                    </dx:ASPxComboBox>
								</td>
								<td>
									<div id="ctlMonthOptions" runat="server">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr id="rowDay" runat="server">
												<td class="FormLabel" valign="top">
                                                    <dx:ASPxRadioButton ID="ASPxrdoSpecificDay" runat="server" Text="Day" GroupName="MonthlyOptions" CssClass="edInline" EnableClientSideAPI="true" ClientInstanceName="specificDay">
                                                    </dx:ASPxRadioButton>
                                                    <dx:ASPxComboBox ID="ASPxcboDay" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="true" ClientInstanceName="dayOfMonth" 
                                                        DropDownRows="10" Width="50px" CssClass="edInline">
                                                        <Items>
                                                            <dx:ListEditItem Text="1" Value="1" Selected="false" />
                                                            <dx:ListEditItem Text="2" Value="2" Selected="false" />
                                                            <dx:ListEditItem Text="3" Value="3" Selected="false" />
                                                            <dx:ListEditItem Text="4" Value="4" Selected="false" />
                                                            <dx:ListEditItem Text="5" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="6" Value="6" Selected="false" />
                                                            <dx:ListEditItem Text="7" Value="7" Selected="false" />
                                                            <dx:ListEditItem Text="8" Value="8" Selected="false" />
                                                            <dx:ListEditItem Text="9" Value="9" Selected="false" />
                                                            <dx:ListEditItem Text="10" Value="10" Selected="false" />
                                                            <dx:ListEditItem Text="11" Value="11" Selected="false" />
                                                            <dx:ListEditItem Text="12" Value="12" Selected="false" />
                                                            <dx:ListEditItem Text="13" Value="13" Selected="false" />
                                                            <dx:ListEditItem Text="14" Value="14" Selected="false" />
                                                            <dx:ListEditItem Text="15" Value="15" Selected="false" />
                                                            <dx:ListEditItem Text="16" Value="16" Selected="false" />
                                                            <dx:ListEditItem Text="17" Value="17" Selected="false" />
                                                            <dx:ListEditItem Text="18" Value="18" Selected="false" />
                                                            <dx:ListEditItem Text="19" Value="19" Selected="false" />
                                                            <dx:ListEditItem Text="20" Value="20" Selected="false" />
                                                            <dx:ListEditItem Text="21" Value="21" Selected="false" />
                                                            <dx:ListEditItem Text="22" Value="22" Selected="false" />
                                                            <dx:ListEditItem Text="23" Value="23" Selected="false" />
                                                            <dx:ListEditItem Text="24" Value="24" Selected="false" />
                                                            <dx:ListEditItem Text="25" Value="25" Selected="false" />
                                                            <dx:ListEditItem Text="26" Value="26" Selected="false" />
                                                            <dx:ListEditItem Text="27" Value="27" Selected="false" />
                                                            <dx:ListEditItem Text="28" Value="28" Selected="false" />
                                                            <dx:ListEditItem Text="29" Value="29" Selected="false" />
                                                            <dx:ListEditItem Text="30" Value="30" Selected="false" />
                                                            <dx:ListEditItem Text="31" Value="31" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                </td>
											</tr>
											<tr id="rowFirstLast" runat="server" valign="top">
												<td class="FormLabel">
                                                    <dx:ASPxRadioButton ID="ASPxrdoVariable" runat="server" Text="The" GroupName="MonthlyOptions" CssClass="edInline" EnableClientSideAPI="true" ClientInstanceName="variableDay">
                                                    </dx:ASPxRadioButton>
                                                    <dx:ASPxComboBox ID="ASPxcboVariableInterval" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="firstLast" Width="50px" CssClass="edInline">
                                                        <Items>
                                                            <dx:ListEditItem Text="First" Value="0" Selected="false" />
                                                            <dx:ListEditItem Text="Last" Value="1" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                    <dx:ASPxComboBox ID="ASPxcboVariableTarget" runat="server" ValueType="System.Int32" AutoPostBack="false"
                                                        EnableClientSideAPI="true" ClientInstanceName="dayOfWeek" CssClass="edInline">
                                                        <Items>
                                                            <dx:ListEditItem Text="Day" Value="7" Selected="false" />
                                                            <dx:ListEditItem Text="Sunday" Value="0" Selected="false" />
                                                            <dx:ListEditItem Text="Monday" Value="1" Selected="false" />
                                                            <dx:ListEditItem Text="Tuesday" Value="2" Selected="false" />
                                                            <dx:ListEditItem Text="Wednesday" Value="3" Selected="false" />
                                                            <dx:ListEditItem Text="Thursday" Value="4" Selected="false" />
                                                            <dx:ListEditItem Text="Friday" Value="5" Selected="false" />
                                                            <dx:ListEditItem Text="Saturday" Value="6" Selected="false" />
                                                        </Items>
                                                    </dx:ASPxComboBox>
                                                </td>
											</tr>
										</table>
									</div>
									<div id="DailyOptions" runat="server">
										<table cellspacing="0" cellpadding="0">
											<tr>
												<td class="FormLabel" valign="top">Select the days for the jobs to be run<br />
												    <dx:ASPxCheckBoxList ID="ASPxchklstDaily" runat="server" RepeatColumns="4" RepeatDirection="Horizontal">
                                                        <Items>
                                                            <dx:ListEditItem Value="1" Text="Monday" />
                                                            <dx:ListEditItem Value="2" Text="Tuesday" />
                                                            <dx:ListEditItem Value="3" Text="Wednesday" />
                                                            <dx:ListEditItem Value="4" Text="Thursday" />
                                                            <dx:ListEditItem Value="5" Text="Friday" />
                                                            <dx:ListEditItem Value="6" Text="Saturday" />
                                                            <dx:ListEditItem Value="7" Text="Sunday" />
                                                        </Items>
                                                    </dx:ASPxCheckBoxList>
												</td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobBeginDateHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Begin on Date
											</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<dx:ASPxDateEdit ID="ASPxDateBegin" runat="server">
									</dx:ASPxDateEdit>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 172px;" valign="top">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobStartTimeHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel" valign="middle">Start Time
											</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
                                    <dx:ASPxComboBox ID="ASPxcboHour" runat="server" ValueType="System.Int32" AutoPostBack="false" EnableClientSideAPI="False" AutoResizeWithContainer="True" 
                                        DropDownRows="12" Width="50px" HorizontalAlign="Justify" CssClass="edInline">
                                        <Items>
                                            <dx:ListEditItem Text="1" Value="1" Selected="false" />
                                            <dx:ListEditItem Text="2" Value="2" Selected="false" />
                                            <dx:ListEditItem Text="3" Value="3" Selected="false" />
                                            <dx:ListEditItem Text="4" Value="4" Selected="false" />
                                            <dx:ListEditItem Text="5" Value="5" Selected="false" />
                                            <dx:ListEditItem Text="6" Value="6" Selected="false" />
                                            <dx:ListEditItem Text="7" Value="7" Selected="false" />
                                            <dx:ListEditItem Text="8" Value="8" Selected="false" />
                                            <dx:ListEditItem Text="9" Value="9" Selected="false" />
                                            <dx:ListEditItem Text="10" Value="10" Selected="false" />
                                            <dx:ListEditItem Text="11" Value="11" Selected="false" />
                                            <dx:ListEditItem Text="12" Value="12" Selected="false" />
                                        </Items>
                                    </dx:ASPxComboBox>
                                    <dx:ASPxComboBox ID="ASPxcboMinute" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="False" AutoResizeWithContainer="True"
                                        CustomButtonsPosition="Far" DropDownRows="20" Width="50px" HorizontalAlign="Justify" CssClass="edInline">
                                        <Items>
                                            <dx:ListEditItem Text="00" Value="0" Selected="false" />
                                            <dx:ListEditItem Text="1" Value="1" Selected="false" />
                                            <dx:ListEditItem Text="2" Value="2" Selected="false" />
                                            <dx:ListEditItem Text="3" Value="3" Selected="false" />
                                            <dx:ListEditItem Text="4" Value="4" Selected="false" />
                                            <dx:ListEditItem Text="5" Value="5" Selected="false" />
                                            <dx:ListEditItem Text="6" Value="6" Selected="false" />
                                            <dx:ListEditItem Text="7" Value="7" Selected="false" />
                                            <dx:ListEditItem Text="8" Value="8" Selected="false" />
                                            <dx:ListEditItem Text="9" Value="9" Selected="false" />
                                            <dx:ListEditItem Text="10" Value="10" Selected="false" />
                                            <dx:ListEditItem Text="11" Value="11" Selected="false" />
                                            <dx:ListEditItem Text="12" Value="12" Selected="false" />
                                            <dx:ListEditItem Text="13" Value="13" Selected="false" />
                                            <dx:ListEditItem Text="14" Value="14" Selected="false" />
                                            <dx:ListEditItem Text="15" Value="15" Selected="false" />
                                            <dx:ListEditItem Text="16" Value="16" Selected="false" />
                                            <dx:ListEditItem Text="17" Value="17" Selected="false" />
                                            <dx:ListEditItem Text="18" Value="18" Selected="false" />
                                            <dx:ListEditItem Text="19" Value="19" Selected="false" />
                                            <dx:ListEditItem Text="20" Value="20" Selected="false" />
                                            <dx:ListEditItem Text="21" Value="21" Selected="false" />
                                            <dx:ListEditItem Text="22" Value="22" Selected="false" />
                                            <dx:ListEditItem Text="23" Value="23" Selected="false" />
                                            <dx:ListEditItem Text="24" Value="24" Selected="false" />
                                            <dx:ListEditItem Text="25" Value="25" Selected="false" />
                                            <dx:ListEditItem Text="26" Value="26" Selected="false" />
                                            <dx:ListEditItem Text="27" Value="27" Selected="false" />
                                            <dx:ListEditItem Text="28" Value="28" Selected="false" />
                                            <dx:ListEditItem Text="29" Value="29" Selected="false" />
                                            <dx:ListEditItem Text="30" Value="30" Selected="false" />
                                            <dx:ListEditItem Text="31" Value="31" Selected="false" />
                                            <dx:ListEditItem Text="32" Value="32" Selected="false" />
                                            <dx:ListEditItem Text="33" Value="33" Selected="false" />
                                            <dx:ListEditItem Text="34" Value="34" Selected="false" />
                                            <dx:ListEditItem Text="35" Value="35" Selected="false" />
                                            <dx:ListEditItem Text="36" Value="36" Selected="false" />
                                            <dx:ListEditItem Text="37" Value="37" Selected="false" />
                                            <dx:ListEditItem Text="38" Value="38" Selected="false" />
                                            <dx:ListEditItem Text="39" Value="39" Selected="false" />
                                            <dx:ListEditItem Text="40" Value="40" Selected="false" />
                                            <dx:ListEditItem Text="41" Value="41" Selected="false" />
                                            <dx:ListEditItem Text="42" Value="42" Selected="false" />
                                            <dx:ListEditItem Text="43" Value="43" Selected="false" />
                                            <dx:ListEditItem Text="44" Value="44" Selected="false" />
                                            <dx:ListEditItem Text="45" Value="45" Selected="false" />
                                            <dx:ListEditItem Text="46" Value="46" Selected="false" />
                                            <dx:ListEditItem Text="47" Value="47" Selected="false" />
                                            <dx:ListEditItem Text="48" Value="48" Selected="false" />
                                            <dx:ListEditItem Text="49" Value="49" Selected="false" />
                                            <dx:ListEditItem Text="50" Value="50" Selected="false" />
                                            <dx:ListEditItem Text="51" Value="51" Selected="false" />
                                            <dx:ListEditItem Text="52" Value="52" Selected="false" />
                                            <dx:ListEditItem Text="53" Value="53" Selected="false" />
                                            <dx:ListEditItem Text="54" Value="54" Selected="false" />
                                            <dx:ListEditItem Text="55" Value="55" Selected="false" />
                                            <dx:ListEditItem Text="56" Value="56" Selected="false" />
                                            <dx:ListEditItem Text="57" Value="57" Selected="false" />
                                            <dx:ListEditItem Text="58" Value="58" Selected="false" />
                                            <dx:ListEditItem Text="59" Value="59" Selected="false" />
                                        </Items>
                                    </dx:ASPxComboBox>
                                    <dx:ASPxComboBox ID="ASPxcboAmPm" runat="server" ValueType="System.String" AutoPostBack="false" EnableClientSideAPI="False" AutoResizeWithContainer="True"
                                        CustomButtonsPosition="Far" Width="50px" HorizontalAlign="Justify" CssClass="edInline">
                                        <Items>
                                            <dx:ListEditItem Text="AM" Value="AM" Selected="false" />
                                            <dx:ListEditItem Text="PM" Value="PM" Selected="false" />
                                        </Items>
                                    </dx:ASPxComboBox>
								</td>
							</tr>
							<tr>
								<td class="FormLabel" style="width: 172px;">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobEndDateHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">End on Date
											</td>
										</tr>
									</table>
								</td>
								<td colspan="2">
									<dx:ASPxDateEdit ID="ASPxDateEnd" runat="server">
									</dx:ASPxDateEdit>
								</td>
							</tr>
						</table>

					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabEmail" Text="Email" ToolTip="Manage the how this group will be emailed">
				<ContentCollection>
					<dx:ContentControl ID="tabEmail" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr valign="top">
								<td style="width: 150px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobEmailHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Merge Output to a Single File
											</td>
										</tr>
									</table>
								</td>
								<td>
								    <dx:ASPxRadioButtonList ID="ASPxrdoMerge" runat="server" RepeatDirection="Horizontal" Border-BorderStyle="None">
                                        <Items>
                                            <dx:ListEditItem Text="Yes" Value="Y" />
                                            <dx:ListEditItem Text="No" Value="N" />
                                        </Items>
                                    </dx:ASPxRadioButtonList>
								</td>
								<td>&nbsp;
								</td>
							</tr>
							<tr valign="top">
								<td style="width: 150px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobEmailHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Email Report
											</td>
										</tr>
									</table>
								</td>
								<td>
								    <dx:ASPxRadioButtonList ID="ASPxrdoEmailReport" runat="server" RepeatDirection="Horizontal" Border-BorderStyle="None">
                                        <Items>
                                            <dx:ListEditItem Text="Yes" Value="Y" />
                                            <dx:ListEditItem Text="No" Value="N" />
                                        </Items>
                                    </dx:ASPxRadioButtonList>
								</td>
								<td>&nbsp;
								</td>
							</tr>
							<tr valign="top">
								<td style="width: 150px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobFromHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">From
											</td>
										</tr>
									</table>
								</td>
								<td>
								    <dx:ASPxTextBox ID="ASPxtxtEmailFrom" runat="server" Width="350px">
                                    </dx:ASPxTextBox>
								</td>
								<td>
									<asp:Label ID="lblMailFromValidate" runat="server" Visible="False" ForeColor="#ff0000"></asp:Label>
								</td>
							</tr>
							<tr valign="top">
								<td style="width: 150px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobToHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">To
											</td>
										</tr>
									</table>
								</td>
								<td>
								    <dx:ASPxTextBox ID="ASPxtxtSendMailTo" runat="server" Width="100%">
                                    </dx:ASPxTextBox>
								</td>
								<td>
									<asp:Label ID="lblMailToValidate" runat="server" Visible="False" ForeColor="#ff0000"></asp:Label>
								</td>
							</tr>
							<tr valign="top">
								<td style="width: 150px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobSubjectHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Subject
											</td>
										</tr>
									</table>
								</td>
								<td>
								    <dx:ASPxTextBox ID="ASPxtxtMailSubject" runat="server" Width="100%">
                                    </dx:ASPxTextBox>
								</td>
								<td>
									<asp:Label ID="lblMailSubjectValidate" runat="server" Visible="False" ForeColor="#ff0000"></asp:Label>
								</td>
							</tr>
							<tr valign="top">
								<td style="width: 150px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('ScheduleJobMessgeHelp.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormLabel">Message
											</td>
										</tr>
									</table>
								</td>
								<td>
                                    <dx:ASPxHtmlEditor ID="ASPxHtmlMailBody" runat="server" ToolbarMode="Ribbon" Width="100%">
                                        <SettingsDialogs>
                                        <InsertImageDialog>
                                        <SettingsImageSelector>
                                        <SettingsDropbox TeamMemberID=""></SettingsDropbox>
                                        </SettingsImageSelector>
                                        </InsertImageDialog>

                                        <InsertFlashDialog>
                                        <SettingsFlashSelector>
                                        <SettingsDropbox TeamMemberID=""></SettingsDropbox>
                                        </SettingsFlashSelector>
                                        </InsertFlashDialog>

                                        <InsertAudioDialog>
                                        <SettingsAudioSelector>
                                        <SettingsDropbox TeamMemberID=""></SettingsDropbox>
                                        </SettingsAudioSelector>
                                        </InsertAudioDialog>

                                        <InsertVideoDialog>
                                        <SettingsVideoSelector>
                                        <SettingsDropbox TeamMemberID=""></SettingsDropbox>
                                        </SettingsVideoSelector>
                                        </InsertVideoDialog>

                                        <InsertLinkDialog>
                                        <SettingsDocumentSelector>
                                        <SettingsDropbox TeamMemberID=""></SettingsDropbox>
                                        </SettingsDocumentSelector>
                                        </InsertLinkDialog>
                                        </SettingsDialogs>
                                    </dx:ASPxHtmlEditor>
								</td>
								<td>&nbsp;
								</td>
							</tr>
						</table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
			<dx:TabPage Name="tabReports" Text="Assign Reports" ToolTip="Manage the reports within this group">
				<ContentCollection>
					<dx:ContentControl ID="tanReports" runat="server" SupportsDisabledAttribute="True" Width="100%">
						<table class="RSTable" id="tblAssignReports" cellspacing="5" cellpadding="0" width="100%" border="0">
							<tr>
								<td style="width: 400px">
									<table width="100%">
										<tr>
											<td style="width: 21px;">
												<a onclick="callHelp('UserRoles.htm')" href="javascript:void(0)" tabindex="-1">
													<img alt="Help" src="images/help3.gif" /></a>
											</td>
											<td class="FormText">Assign Reports to this Group:
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
                        <table style="width: 100%">
                            <tr>
                                <td style="width: 40%">
                                    <!-- Added EnableSynchronization property - Jeff Lyon - 4/23/2019 - version 3.9.4.2   -->
                                    <dx:ASPxListBox ID="lbAvailable" runat="server" ClientInstanceName="lbAvailable" EnableSynchronization="True"
                                        Width="100%" Height="250px" SelectionMode="CheckColumn" Caption="Available Reports">
                                        <CaptionSettings Position="Top" />
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { UpdateButtonState(); }" />
                                    </dx:ASPxListBox>
                                </td>
                                <td style="padding: 90px 60px;">
                                    <div>
                                        <dx:ASPxButton ID="btnMoveSelectedItemsToRight" runat="server" ClientInstanceName="btnMoveSelectedItemsToRight"
                                            AutoPostBack="False" Text="Add >" Width="130px" ClientEnabled="False"
                                            ToolTip="Add selected items">
                                            <ClientSideEvents Click="function(s, e) { AddSelectedItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div class="TopPadding">
                                        <dx:ASPxButton ID="btnMoveAllItemsToRight" runat="server" ClientInstanceName="btnMoveAllItemsToRight"
                                            AutoPostBack="False" Text="Add All >>" Width="130px" ToolTip="Add all items">
                                            <ClientSideEvents Click="function(s, e) { AddAllItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div style="height: 32px">
                                    </div>
                                    <div>
                                        <dx:ASPxButton ID="btnMoveSelectedItemsToLeft" runat="server" ClientInstanceName="btnMoveSelectedItemsToLeft"
                                            AutoPostBack="False" Text="< Remove" Width="130px" ClientEnabled="False"
                                            ToolTip="Remove selected items">
                                            <ClientSideEvents Click="function(s, e) { RemoveSelectedItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                    <div class="TopPadding">
                                        <dx:ASPxButton ID="btnMoveAllItemsToLeft" runat="server" ClientInstanceName="btnMoveAllItemsToLeft"
                                            AutoPostBack="False" Text="<< Remove All" Width="130px" ClientEnabled="False"
                                            ToolTip="Remove all items">
                                            <ClientSideEvents Click="function(s, e) { RemoveAllItems(); }" />
                                        </dx:ASPxButton>
                                    </div>
                                </td>
                                <td style="width: 40%">
                                    <!-- Added EnableSynchronization property - Jeff Lyon - 4/23/2019 - version 3.9.4.2   -->
                                    <dx:ASPxListBox ID="lbChoosen" runat="server" ClientInstanceName="lbChoosen" Width="100%" EnableSynchronization="True"
                                        Height="250px" SelectionMode="CheckColumn" Caption="Assigned Reports">
                                        <CaptionSettings Position="Top" />
                                        <ClientSideEvents SelectedIndexChanged="function(s, e) { UpdateButtonState(); }"></ClientSideEvents>
                                    </dx:ASPxListBox>
                                </td>
                            </tr>
                        </table>
					</dx:ContentControl>
				</ContentCollection>
			</dx:TabPage>
		</TabPages>
	</dx:ASPxPageControl>
	<div class="bottomButtons">
        <dx:ASPxButton ID="ASPxbtnSave" runat="server" Text="Save" CssClass="edInline" />
        <dx:ASPxButton ID="ASPxbtnCancel" runat="server" Text="Cancel" CssClass="edInline" CausesValidation="False" />
    </div>
	<div>
		<asp:Label ID="lblValidationSummary" runat="server" ForeColor="Red" Visible="False"></asp:Label>
	</div>
</asp:Content>
