﻿Option Explicit On
Option Strict On

Imports CrystalDecisions.CrystalReports.Engine
Imports CrystalDecisions.Shared
Imports Ripplestone
Imports Telerik.Web.UI
Imports Ripplestone.BLL
Imports Ripplestone.CR
Imports Ripplestone.Common
Imports Ripplestone.Common.Utilities
Imports CrystalDecisions.Web

''' <summary>
''' Main page for Ripplestone
''' </summary>
''' <remarks>
'''    Jeff Lyon - added document location path to the Favorites and Search grid so the user knows what folder the document is in - 6/18/2014 - version 3.4.5.3
'''    Added the Round Panel control for the groups
'''    Jeff Lyon - 2/27/2017 - version 3.8.1.0
'''    Changed all the checks for the MinimalHomePage to use an Or and not OrElse.  This the OrElse the second part was not getting evaluated
'''    Jeff Lyon - 8/3/2017 - version 3.8.2.2
''' </remarks>
Partial Class Home
    Inherits RSBasePage

#Region " Private Variables "

    Private _UserID As Integer
    Private _objUser As New Ripplestone.BLL.User
    Private _crystalReport1 As ReportDocument
    Private _crystalReport2 As ReportDocument
    Private _crystalReport3 As ReportDocument
    Private _crystalReport4 As ReportDocument
    Private _crystalReport5 As ReportDocument
    Private _rsReport1 As DevExpress.XtraReports.UI.XtraReport
    Private _rsReport2 As DevExpress.XtraReports.UI.XtraReport

#End Region

#Region " Page Events "

    Private Sub Page_Init(sender As Object, e As EventArgs) Handles Me.Init

        Dim allowedExportFormats As Integer = 0

        If Utilities.GetRipplestoneConfigStringValue("AllowedExportFormats", "1791") <> "" Then
            allowedExportFormats = CInt(Utilities.GetRipplestoneConfigStringValue("AllowedExportFormats", "1791"))
        Else
            allowedExportFormats = ViewerExportFormats.AllFormats
        End If

        ' Moved these lines up and out of the check for session.  They should be set everytime there is a post back
        ' Jeff Lyon - 7/22/2015 - version 3.6.1.4
        CrystalReportViewer1.AllowedExportFormats = allowedExportFormats
        CrystalReportViewer2.AllowedExportFormats = allowedExportFormats
        CrystalReportViewer3.AllowedExportFormats = allowedExportFormats
        CrystalReportViewer4.AllowedExportFormats = allowedExportFormats
        CrystalReportViewer5.AllowedExportFormats = allowedExportFormats

        If Session("rsreport1") IsNot Nothing Then
            _rsReport1 = CType(Session("rsreport1"), DevExpress.XtraReports.UI.XtraReport)
            'webreportViewer1.OpenReport(_rsReport1)

            ASPxPageControl1.TabPages(7).ClientVisible = True
        End If

        If Session("report1") IsNot Nothing Then
            _crystalReport1 = CType(Session("report1"), ReportDocument)
            CrystalReportViewer1.ReportSource = _crystalReport1

            ASPxPageControl1.TabPages(2).ClientVisible = True
        End If

        If Session("report2") IsNot Nothing Then
            _crystalReport2 = CType(Session("report2"), ReportDocument)
            CrystalReportViewer2.ReportSource = _crystalReport2

            ASPxPageControl1.TabPages(3).ClientVisible = True
        End If

        If Session("report3") IsNot Nothing Then
            _crystalReport3 = CType(Session("report3"), ReportDocument)
            CrystalReportViewer3.ReportSource = _crystalReport3

            ASPxPageControl1.TabPages(4).ClientVisible = True
        End If

        If Session("report4") IsNot Nothing Then
            _crystalReport4 = CType(Session("report4"), ReportDocument)
            CrystalReportViewer4.ReportSource = _crystalReport4

            ASPxPageControl1.TabPages(5).ClientVisible = True
        End If

        If Session("report5") IsNot Nothing Then
            _crystalReport5 = CType(Session("report5"), ReportDocument)
            CrystalReportViewer5.ReportSource = _crystalReport5

            ASPxPageControl1.TabPages(6).ClientVisible = True
        End If

    End Sub

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks>
    ''' Jeff Lyon - 08/15/2012 - Fixed bug to add the correct URL to Publish New Documents links when the
    '''                          user is a publisher. ver 3.4.1
    ''' </remarks>
    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ' Added to allow the resellers to brand the product
        ' Jeff Lyon - 11/24/2011 - version 3.2.9
        Dim productName As String = Ripplestone.BLL.ReportConstant.GetReportConstantProductName
        If productName.Trim.Length > 0 Then
            Page.Title = productName & " :: " & Page.Title
        End If

        ' Added a TryCast
        ' Jeff Lyon - 3/4/2019 - version 3.9.2.2
        _objUser = TryCast(Session("RSUser"), Ripplestone.BLL.User)

        ' Added checks to see if the user is active
        ' Jeff Lyon - 3/4/2019 - version 3.9.2.2
        If _objUser Is Nothing Then
            System.Web.Security.FormsAuthentication.SignOut()
        ElseIf _objUser.Active = False And _objUser.WindowsUserID = True Then
            Response.Redirect("ApplicationError.aspx?Error=033&Page=Global.aspx&User=" & _objUser.UserLogin)
        ElseIf _objUser.Active = False And _objUser.WindowsUserID = False Then
            Response.Redirect("SignOn.aspx")
        Else
            _UserID = _objUser.ID
            lblUserID.Text = _UserID.ToString
        End If

        ' Added code to display the Favorites and not the home page
        ' Jeff Lyon - 3.3.2 - 6/12/2012
        Dim showFavorites As String = ""
        If Not Request.QueryString.Item("Favorites") Is Nothing Then
            showFavorites = Request.QueryString.Item("Favorites").ToString
        End If

        ' Added the ability to have the Super User add a message to the home page.
        ' Jeff Lyon - 7/21/2015 - version 3.6.1.4
        lblMessages.Text = RSCommon.ReadRipplestoneConfig("HomePageMessage").Trim

        If Not IsPostBack Then
            ' First time this page is loaded.
            If (showFavorites <> "no" AndAlso RSCommon.DisplayFavorites = True) Or (showFavorites <> "no" AndAlso UserOption.GetOptionValueByUserIDAndDescription(_UserID, "DisplayFavorites") = "yes") Then
                showFavorites = "yes"
            End If

            'Do some clean up of old report objects
            ' Jeff Lyon - 6/26/2014 - version 3.4.5.3
            If Session("report1") IsNot Nothing Then
                _crystalReport1 = CType(Session("report1"), ReportDocument)
                _crystalReport1.Close()
                _crystalReport1.Dispose()
                GC.Collect()
                Session.Remove("report1")
                CrystalReportViewer1.ReportSource = Nothing
            End If
            If Session("report2") IsNot Nothing Then
                _crystalReport2 = CType(Session("report2"), ReportDocument)
                _crystalReport2.Close()
                _crystalReport2.Dispose()
                GC.Collect()
                Session.Remove("report2")
                CrystalReportViewer2.ReportSource = Nothing
            End If
            If Session("report3") IsNot Nothing Then
                _crystalReport3 = CType(Session("report3"), ReportDocument)
                _crystalReport3.Close()
                _crystalReport3.Dispose()
                GC.Collect()
                Session.Remove("report3")
                CrystalReportViewer3.ReportSource = Nothing
            End If
            If Session("report4") IsNot Nothing Then
                _crystalReport4 = CType(Session("report4"), ReportDocument)
                _crystalReport4.Close()
                _crystalReport4.Dispose()
                GC.Collect()
                Session.Remove("report4")
                CrystalReportViewer4.ReportSource = Nothing
            End If
            If Session("report5") IsNot Nothing Then
                _crystalReport5 = CType(Session("report5"), ReportDocument)
                _crystalReport5.Close()
                _crystalReport5.Dispose()
                GC.Collect()
                Session.Remove("report5")
                CrystalReportViewer5.ReportSource = Nothing
            End If

            ' Added to keep track of the DocumentID in the CR Web Viewer tab
            ' Jeff Lyon - 6/26/2014 - version 3.4.5.3
            hideDocID1.Value = "0"
            hideDocID2.Value = "0"
            HideDocID3.Value = "0"
            HideDocID4.Value = "0"
            HideDocID5.Value = "0"

            ' Added to have an option to only display the Favorites and nothing else
            ' Jeff Lyon - ver 3.3.2 - 6/12/2012
            If showFavorites.ToLower = "yes" Then

                FavoritesHome.Visible = True

                ASPxPageControl1.TabPages(0).ClientVisible = False
                ASPxPageControl1.TabPages(1).ClientVisible = True
                ASPxPageControl1.ActiveTabIndex = 1

                ' Display the favorite documents for this user
                ' New for version 2.9.9 - JSL - 11/3/2009
                Dim FavoriteDocumentsList As List(Of Ripplestone.BLL.DocumentFavorite)
                FavoriteDocumentsList = Ripplestone.BLL.DocumentFavorite.GetDocumentFavoriteByUserID(_UserID)

                repeaterFavoritesHome.DataSource = FavoriteDocumentsList
                repeaterFavoritesHome.DataBind()
            Else
                ' First time the page is loaded... this is NOT a postback
                If _objUser Is Nothing Then
                    System.Web.Security.FormsAuthentication.SignOut()
                    Response.Redirect("SignOn.aspx")
                ElseIf _objUser.Active = False And _objUser.WindowsUserID = True Then
                    Response.Redirect("ApplicationError.aspx?Error=033&Page=Global.aspx&User=" & _objUser.UserLogin)
                ElseIf _objUser.Active = False And _objUser.WindowsUserID = False Then
                    Response.Redirect("SignOn.aspx")
                Else
                    TreeFunctions.GenerateTreeView(RadTreeFolders, _objUser.IsSuperUser, _objUser.IsAdministrator, _UserID)
                End If

                ripplestoneHome.Attributes.Add("style", "display: none;")
                myDocuments.Attributes.Add("style", "display: none;")
                folderHome.Attributes.Add("style", "display: none;")
                documentMaintenance.Attributes.Add("style", "display: none;")
                documentActions.Attributes.Add("style", "display: none;")
                documentSchedules.Attributes.Add("style", "display: none;")
                documentMetrics.Attributes.Add("style", "display: none;")
                documentSearch.Attributes.Add("style", "display: none;")
                ASPxPageControl1.TabPages(1).ClientVisible = False
                ASPxPageControl1.TabPages(2).ClientVisible = False
                ASPxPageControl1.TabPages(3).ClientVisible = False
                ASPxPageControl1.TabPages(4).ClientVisible = False
                ASPxPageControl1.TabPages(5).ClientVisible = False
                ASPxPageControl1.TabPages(6).ClientVisible = False

                FavoritesHome.Visible = False
                FavoritesHome.Attributes.Add("style", "display: none;")

                ' If the Querystring has the nodeValue passed in, then try and find the node and display it
                Dim nodeValue As String = ""
                If Not Request.QueryString("nodeValue") Is Nothing Then
                    nodeValue = Request.QueryString("nodeValue")

                    If nodeValue.Trim.Length > 0 Then
                        Dim treeNode = TreeFunctions.FindTreeNode(RadTreeFolders, nodeValue, False, True, _UserID)

                        If Not treeNode Is Nothing Then
                            treeNode = RadTreeFolders.FindNodeByValue(nodeValue)

                            RadTreeFolders.UnselectAllNodes()
                            treeNode.Selected = True
                            ShowSelectedNode(treeNode)
                        End If
                    End If
                Else
                    ' Setup the default view of displaying the Home node
                    panelHome.HeaderText = RSCommon.GetRipplestoneHomeTitle
                    lblHomeMessage.Text = RSCommon.GetRipplestoneHomeMessage
                    ripplestoneHome.Attributes.Add("style", "display: block;")
                    ' Added new option to determine if the normal home page or the favorites are displayed by default
                    ' Jeff Lyon - ver 3.3.2 - 6/12/2012
                    If RSCommon.UseMinimizeHomePageData = True Or UserOption.GetOptionValueByUserIDAndDescription(_UserID, "MinimalHomePage") = "yes" Then
                        myDocuments.Attributes.Add("style", "display: none;")
                    Else
                        myDocuments.Attributes.Add("style", "display: block;")
                    End If

                    Dim FavoriteDocumentsList As List(Of DocumentFavorite)
                    FavoriteDocumentsList = DocumentFavorite.GetDocumentFavoriteByUserID(_UserID)

                    repeaterFavorites.DataSource = FavoriteDocumentsList
                    repeaterFavorites.DataBind()

                    If _objUser Is Nothing Then
                        System.Web.Security.FormsAuthentication.SignOut()
                        Response.Redirect("SignOn.aspx")
                    Else
                        If _objUser.IsSuperUser Or _objUser.IsAdministrator Then
                            EditRootFolder.Attributes.Add("style", "display: block;")
                            RSNewFolder.Attributes.Add("style", "display: block;")

                            Dim FolderID As Integer = DocumentFolder.GetRootFolderID

                            linkRootFolderEdit.NavigateUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                            imgbtnRootFolderEdit.PostBackUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                            imgbtnPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                            linkPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                        ElseIf _objUser.IsPublisher Then
                            Dim FolderID As Integer = DocumentFolder.GetRootFolderID

                            EditRootFolder.Attributes.Add("style", "display: none;")
                            RSNewFolder.Attributes.Add("style", "display: none;")
                            linkRootFolderEdit.NavigateUrl = "#"
                            imgbtnRootFolderEdit.PostBackUrl = "#"
                            imgbtnPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                            linkPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                        Else
                            EditRootFolder.Attributes.Add("style", "display: none;")
                            RSNewFolder.Attributes.Add("style", "display: none;")
                            linkRootFolderEdit.NavigateUrl = "#"
                            imgbtnRootFolderEdit.PostBackUrl = "#"
                            imgbtnPublish.PostBackUrl = "#"
                            linkPublish.NavigateUrl = "#"
                        End If
                        If _objUser.IsSuperUser Or _objUser.IsAdministrator Or _objUser.IsPublisher Then
                            RSNewDocument.Attributes.Add("style", "display: block;")
                        Else
                            RSNewDocument.Attributes.Add("style", "display: none;")
                        End If
                        If _objUser.IsSuperUser Or _objUser.IsAdministrator Or _objUser.IsScheduler Then
                            RSNewSchedule.Attributes.Add("style", "display: block;")
                        Else
                            RSNewSchedule.Attributes.Add("style", "display: none;")
                        End If
                    End If
                End If
            End If
        Else
            ' This is a postback... 

            ' Added a check to see if there are any reports stored in session but the report is not visible
            ' This can happen if the report didn't finish running or the user pressed the back button
            ' Jeff Lyon - 2/9/2015 - version 3.5.2.2
            If hideDocID1.Value = "0" AndAlso ASPxPageControl1.TabPages(2).Text = "Empty Report 1" Then
                If Session("report1") IsNot Nothing Then
                    _crystalReport1 = CType(Session("report1"), ReportDocument)
                    _crystalReport1.Close()
                    _crystalReport1.Dispose()
                    GC.Collect()
                    Session.Remove("report1")
                    CrystalReportViewer1.ReportSource = Nothing
                End If
            ElseIf String.IsNullOrEmpty(hideDocID1.Value) = False Then
                ' Added to set the viewer toolbar options
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                SetReportViewerOptions(CInt(hideDocID1.Value), 1)
            End If
            If hideDocID2.Value = "0" AndAlso ASPxPageControl1.TabPages(3).Text = "Empty Report 2" Then
                If Session("report2") IsNot Nothing Then
                    _crystalReport2 = CType(Session("report2"), ReportDocument)
                    _crystalReport2.Close()
                    _crystalReport2.Dispose()
                    GC.Collect()
                    Session.Remove("report2")
                    CrystalReportViewer2.ReportSource = Nothing
                End If
            ElseIf String.IsNullOrEmpty(hideDocID2.Value) = False Then
                ' Added to set the viewer toolbar options
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                SetReportViewerOptions(CInt(hideDocID2.Value), 2)
            End If
            If HideDocID3.Value = "0" AndAlso ASPxPageControl1.TabPages(4).Text = "Empty Report 3" Then
                If Session("report3") IsNot Nothing Then
                    _crystalReport3 = CType(Session("report3"), ReportDocument)
                    _crystalReport3.Close()
                    _crystalReport3.Dispose()
                    GC.Collect()
                    Session.Remove("report3")
                    CrystalReportViewer3.ReportSource = Nothing
                End If
            ElseIf String.IsNullOrEmpty(hideDocID3.Value) = False Then
                ' Added to set the viewer toolbar options
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                SetReportViewerOptions(CInt(HideDocID3.Value), 3)
            End If
            If HideDocID4.Value = "0" AndAlso ASPxPageControl1.TabPages(5).Text = "Empty Report 4" Then
                If Session("report4") IsNot Nothing Then
                    _crystalReport4 = CType(Session("report4"), ReportDocument)
                    _crystalReport4.Close()
                    _crystalReport4.Dispose()
                    GC.Collect()
                    Session.Remove("report4")
                    CrystalReportViewer4.ReportSource = Nothing
                End If
            ElseIf String.IsNullOrEmpty(hideDocID4.Value) = False Then
                ' Added to set the viewer toolbar options
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                SetReportViewerOptions(CInt(HideDocID4.Value), 4)
            End If
            If HideDocID5.Value = "0" AndAlso ASPxPageControl1.TabPages(6).Text = "Empty Report 5" Then
                If Session("report5") IsNot Nothing Then
                    _crystalReport5 = CType(Session("report5"), ReportDocument)
                    _crystalReport5.Close()
                    _crystalReport5.Dispose()
                    GC.Collect()
                    Session.Remove("report5")
                    CrystalReportViewer5.ReportSource = Nothing
                End If
            ElseIf String.IsNullOrEmpty(hideDocID5.Value) = False Then
                ' Added to set the viewer toolbar options
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                SetReportViewerOptions(CInt(HideDocID5.Value), 5)
            End If
        End If

    End Sub

    Private Sub Home_Error(sender As Object, e As EventArgs) Handles Me.[Error]

        ' Get last error from the server
        Dim exc As Exception = Server.GetLastError

        If TypeOf exc Is InvalidOperationException Then
            ' Log the exception and notify system operators
            RipplestoneWeb.CommonWeb.LogException(exc, "HomePage")
            RipplestoneWeb.CommonWeb.NotifySystemOps(exc)

            ' Handle exceptions generated by Button 2
        ElseIf TypeOf exc Is ArgumentOutOfRangeException Then
            ' Log the exception and notify system operators
            'RipplestoneWeb.ExceptionUtility.LogException(exc, "DefaultPage")
            'RipplestoneWeb.ExceptionUtility.NotifySystemOps(exc)
            ' Clear the error from the server
            Server.ClearError()
        Else
            ' Pass the error on to the default global handler
        End If

    End Sub

#End Region

#Region " Show Selected Node Method "

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <param name="objNode"></param>
    ''' <remarks>
    ''' Jeff Lyon - 08/15/2012 - Fixed bug to add the correct URL to Publish New Documents links when the
    '''                          user is a publisher. ver 3.4.1
    ''' </remarks>
    Private Sub ShowSelectedNode(ByVal objNode As RadTreeNode)

        Dim FolderID As Integer = CInt(objNode.Value.Substring(1))
        Dim FolderName As String = objNode.Text

        If objNode.Category = "Folder" Then
            lblFolderDescription.Text = objNode.ToolTip

            panelFolder.HeaderText = "Folder: " & FolderName
            folderHome.Attributes.Add("style", "display: block;")
            If _objUser.IsSuperUser Then
                EditFolder.Attributes.Add("style", "display: block;")
                linkFolderEdit.NavigateUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                imgbtnFolderEdit.PostBackUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                imgbtnFolderPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                linkFolderPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                DeleteFolder.Attributes.Add("style", "display: block;")
                linkbtnFolderDelete.CommandArgument = FolderID.ToString
                linkbtnFolderDelete.Attributes.Add("onclick", "javascript:return confirm('Are you sure you want to delete this folder?');")
                imgbtnFolderDelete.CommandArgument = FolderID.ToString
                imgbtnFolderDelete.Attributes.Add("onclick", "javascript:return confirm('Are you sure you want to delete this folder?');")
                NewFolder.Attributes.Add("style", "display: block;")
            ElseIf _objUser.IsAdministrator Then
                ' Added code for Administrators to check to see if they are a Admin for the folder they have clicked on.
                ' Jeff Lyon - 02/25/2011 - Version 2.9.11
                If SecurityRole.CheckPermissionsForAdmin(_objUser.ID, FolderID) = True Then
                    EditFolder.Attributes.Add("style", "display: block;")
                    linkFolderEdit.NavigateUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                    imgbtnFolderEdit.PostBackUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                    imgbtnFolderPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                    linkFolderPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                    DeleteFolder.Attributes.Add("style", "display: block;")
                    linkbtnFolderDelete.CommandArgument = FolderID.ToString
                    linkbtnFolderDelete.Attributes.Add("onclick", "javascript:return confirm('Are you sure you want to delete this folder?');")
                    imgbtnFolderDelete.CommandArgument = FolderID.ToString
                    imgbtnFolderDelete.Attributes.Add("onclick", "javascript:return confirm('Are you sure you want to delete this folder?');")
                    NewFolder.Attributes.Add("style", "display: block;")
                Else
                    EditFolder.Attributes.Add("style", "display: none;")
                    linkFolderEdit.NavigateUrl = "#"
                    imgbtnFolderEdit.PostBackUrl = "#"
                    imgbtnFolderPublish.PostBackUrl = "#"
                    linkFolderPublish.NavigateUrl = "#"
                    DeleteFolder.Attributes.Add("style", "display: none;")
                    linkbtnFolderDelete.CommandArgument = "0"
                    imgbtnFolderDelete.CommandArgument = "0"
                    NewFolder.Attributes.Add("style", "display: none;")
                End If
            ElseIf _objUser.IsPublisher Then
                If SecurityRole.CheckPermissionsForPublish(_objUser.ID, FolderID) = True Then
                    imgbtnFolderPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                    linkFolderPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                Else
                    imgbtnFolderPublish.PostBackUrl = "#"
                    linkFolderPublish.NavigateUrl = "#"
                End If
                EditFolder.Attributes.Add("style", "display: none;")
                linkFolderEdit.NavigateUrl = "#"
                imgbtnFolderEdit.PostBackUrl = "#"
                DeleteFolder.Attributes.Add("style", "display: none;")
                linkbtnFolderDelete.CommandArgument = "0"
                imgbtnFolderDelete.CommandArgument = "0"
                NewFolder.Attributes.Add("style", "display: none;")
            Else
                EditFolder.Attributes.Add("style", "display: none;")
                linkFolderEdit.NavigateUrl = "#"
                imgbtnFolderEdit.PostBackUrl = "#"
                imgbtnFolderPublish.PostBackUrl = "#"
                linkFolderPublish.NavigateUrl = "#"
                DeleteFolder.Attributes.Add("style", "display: none;")
                linkbtnFolderDelete.CommandArgument = "0"
                imgbtnFolderDelete.CommandArgument = "0"
                NewFolder.Attributes.Add("style", "display: none;")
            End If

            ' Changed to check the permissions for each folder
            ' JSL - 07/06/2009 - 2.9.9
            If _objUser.IsSuperUser Then
                PublishDocument.Attributes.Add("style", "display: block;")
            Else
                If Ripplestone.BLL.SecurityRole.CheckPermissionsForPublish(_objUser.ID, FolderID) = True Then
                    PublishDocument.Attributes.Add("style", "display: block;")
                Else
                    PublishDocument.Attributes.Add("style", "display: none;")
                End If
            End If

            ' Changed to check the permissions for each folder
            ' JSL - 07/06/2009 - 2.9.9
            If _objUser.IsSuperUser Then
                ScheduleDocument.Attributes.Add("style", "display: block;")
            Else
                If Ripplestone.BLL.SecurityRole.CheckPermissionsForSchedule(_objUser.ID, FolderID) = True Then
                    ScheduleDocument.Attributes.Add("style", "display: block;")
                Else
                    ScheduleDocument.Attributes.Add("style", "display: none;")
                End If
            End If

            ' Display the documents for this folder
            ' New for version 2.9.9
            If RSCommon.UseMinimizeHomePageData = True Or UserOption.GetOptionValueByUserIDAndDescription(_UserID, "MinimalHomePage") = "yes" Then
                ' Don't display the list of documents on the right side of the page
                repeaterFolderDocuments.Visible = False
            Else
                ' Get the data and display the repeater control
                Dim DocumentDataSet As New PublishedReportsDataSet(FolderID, _UserID)

                repeaterFolderDocuments.DataSource = DocumentDataSet.ReportDataView
                repeaterFolderDocuments.DataBind()
                repeaterFolderDocuments.Visible = True
            End If

            ' Hide the other sections
            ripplestoneHome.Attributes.Add("style", "display: none;")
            myDocuments.Attributes.Add("style", "display: none;")
            documentMaintenance.Attributes.Add("style", "display: none;")
            documentActions.Attributes.Add("style", "display: none;")
            documentSchedules.Attributes.Add("style", "display: none")
            documentMetrics.Attributes.Add("style", "display: none;")
            documentSearch.Attributes.Add("style", "display: none;")
        ElseIf objNode.Category = "Document" Then
            Dim DocFolderID As Integer = CInt(objNode.ParentNode.Value.Substring(1))

            Dim DocumentID As Integer = CInt(objNode.Value.Substring(1))
            Dim dsDocuments As New PublishedReportsDataSet(DocumentID, _UserID, "document")
            Dim DocumentTable = dsDocuments.ReportsByFolder.Tables(0)

            Dim strDescription As String = ""
            Dim strAuthor As String = ""
            Dim strAuthorContact As String = ""
            Dim strFileName As String = ""
            Dim strDocumentType As String = ""
            Dim strDefaultViewer As String = ""
            Dim strRecordLastModified As String = ""
            Dim activeDocument As Boolean = True

            For Each rowDocument As DataRow In DocumentTable.Rows
                strDescription = rowDocument.Item("Description").ToString
                strAuthor = rowDocument.Item("Author").ToString
                strAuthorContact = rowDocument.Item("AuthorContact").ToString
                strFileName = rowDocument.Item("FileName").ToString
                strDocumentType = rowDocument.Item("DocumentType").ToString
                strDefaultViewer = rowDocument.Item("Viewer").ToString
                strRecordLastModified = rowDocument.Item("RecordLastModified").ToString
                activeDocument = CBool(rowDocument.Item("Active"))

                ' Added code to display Crystal Reports with different controls than for 
                ' Office docs and pdf's
                ' Jeff Lyon - 11/02/2011 - version 3.2.9
                If strDocumentType = "Crystal Report" Then
                    If CBool(rowDocument.Item("DisableLiveData")) = True Then
                        imgbtnRunDoc.Enabled = False
                        lnkbtnRunDoc.Text = "Report is disabled"
                        lnkbtnRunDoc.Enabled = False
                        imgbtnRunDoc.Attributes.Add("style", "display: none;")
                    ElseIf CBool(rowDocument.Item("Active")) = False Then
                        imgbtnRunDoc.Enabled = False
                        lnkbtnRunDoc.Text = "Report is disabled"
                        lnkbtnRunDoc.Enabled = False
                        imgbtnRunDoc.Attributes.Add("style", "display: none;")
                    Else
                        ' Fixed bug where the "Report is disabled" was still displayed after the previous report was disabled.
                        ' Jeff Lyon - 4/23/2015 - version 3.5.3.3
                        imgbtnRunDoc.CommandArgument = DocumentID.ToString
                        imgbtnRunDoc.Enabled = True
                        lnkbtnRunDoc.CommandArgument = DocumentID.ToString
                        lnkbtnRunDoc.Text = "Run Report"
                        lnkbtnRunDoc.Enabled = True
                        runDoc.Attributes.Add("style", "display: none;")
                        runDocImg.Attributes.Add("style", "display: none;")
                        imgbtnRunDoc.Attributes.Add("style", "display: inline;")
                    End If
                    lnkbtnRunDoc.Attributes.Add("style", "display: inline;")

                    ' Added check to see if the Viewer Dropdown List is available
                    ' Jeff Lyon - 02/17/2020 - version 3.20.2.1
                    Dim homePageViewer As String = DocumentOption.GetOptionValueByReportIDAndDescription(DocumentID, "HomePageViewer")

                    If homePageViewer <> String.Empty Then
                        If homePageViewer = "no" Then
                            ddlViewer.Enabled = False
                        Else
                            ddlViewer.Enabled = True
                        End If
                    Else
                        ddlViewer.Enabled = True
                    End If
                    crViewerOptions.Attributes.Add("style", "display: inline;") ' JSL - 4/6/15 - version 3.5.3.2

                ElseIf strDocumentType = "Hyperlink" Then
                    ' Added new section for Hyperlinks, they were included in the else section
                    ' Jeff Lyon - 10/26/2016 - version 3.7.1.6
                    imgbtnRunDoc.CommandArgument = DocumentID.ToString
                    imgbtnRunDoc.Enabled = True
                    lnkbtnRunDoc.CommandArgument = DocumentID.ToString
                    lnkbtnRunDoc.Text = "Open Hyperlink"
                    lnkbtnRunDoc.Enabled = True
                    runDoc.Attributes.Add("style", "display: none;")
                    runDocImg.Attributes.Add("style", "display: none;")
                    imgbtnRunDoc.Attributes.Add("style", "display: inline;")
                    crViewerOptions.Attributes.Add("style", "display: none;") ' JSL - 4/6/15 - version 3.5.3.2
                Else
                    imgbtnRunDoc.CommandArgument = DocumentID.ToString
                    imgbtnRunDoc.Enabled = True
                    lnkbtnRunDoc.CommandArgument = DocumentID.ToString
                    lnkbtnRunDoc.Text = "Run Document"
                    lnkbtnRunDoc.Enabled = True
                    runDoc.Attributes.Add("style", "display: none;")
                    runDocImg.Attributes.Add("style", "display: none;")
                    imgbtnRunDoc.Attributes.Add("style", "display: inline;")
                    'runDoc.InnerHtml = rowDocument.Item("RunReportHref").ToString()
                    '               runDocImg.InnerHtml = rowDocument.Item("RunReportImageHref").ToString()
                    '               runDoc.Attributes.Add("style", "display: inline;")
                    '               runDocImg.Attributes.Add("style", "display: inline;")

                    'imgbtnRunDoc.Attributes.Add("style", "display: none;")
                    'lnkbtnRunDoc.Attributes.Add("style", "display: none;")
                    crViewerOptions.Attributes.Add("style", "display: none;") ' JSL - 4/6/15 - version 3.5.3.2
                End If

                imgbtnDocMaintPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & DocFolderID.ToString
                linkDocumentPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & DocFolderID.ToString
                linkEdit.NavigateUrl = rowDocument.Item("EditHref").ToString()
                imgbtnEdit.PostBackUrl = rowDocument.Item("EditHref").ToString()
                ' Added the Designer Report link for the RS Reports
                ' Jeff Lyon - 11/17/2016 - version 4.0.0.0
                If strDocumentType = "Ripplestone Report" Then
                    linkDesign.NavigateUrl = String.Format("ReportDesigner.aspx?DocID={0}", DocumentID)
                    imgbtnDesign.PostBackUrl = String.Format("ReportDesigner.aspx?DocID={0}", DocumentID)
                    linkDesign.Attributes.Add("style", "display: inline;")
                    imgbtnDesign.Attributes.Add("style", "display: inline;")
                Else
                    linkDesign.Attributes.Add("style", "display: none;")
                    imgbtnDesign.Attributes.Add("style", "display: none;")
                End If
                linkMove.NavigateUrl = String.Format("MoveDocument.aspx?DocID={0}&FolderID={1}&DocName={2}", DocumentID, rowDocument.Item("FolderID"), strFileName)
                imgbtnMove.PostBackUrl = String.Format("MoveDocument.aspx?DocID={0}&FolderID={1}&DocName={2}", DocumentID, rowDocument.Item("FolderID"), strFileName)
                linkbtnDeleteDoc.CommandArgument = DocumentID.ToString
                linkbtnDeleteDoc.Attributes.Add("onclick", "javascript:return confirm('Are you sure you want to delete this document?');")
                imgbtnDeleteDoc.Attributes.Add("onclick", "javascript:return confirm('Are you sure you want to delete this document?');")

            Next
            lblDescription.Text = "<b>Name:</b> " & objNode.Text & "<br /><br />" &
             "<b>Description:</b> " & strDescription & "<br /><br />" &
             "<b>File Name:</b> " & strFileName & "<br /><br />" &
             "<b>Author:</b> " & strAuthor & "<br /><br />" &
             "<b>Author Contact:</b> " & strAuthorContact & "<br /><br />" &
             "<b>Active:</b> " & activeDocument

            If strDocumentType = "Crystal Report" Then
                If strDefaultViewer.Trim.Length = 0 Then
                    strDefaultViewer = RSCommon.GetDefaultViewer
                End If
                Select Case strDefaultViewer
                    Case "CRWebViewer"
                        lblDescription.Text = lblDescription.Text & "<br /><br /><b>Report Viewer:</b> Web Viewer"
                        ddlViewer.SelectedIndex = 0
                    Case "PDF"
                        lblDescription.Text = lblDescription.Text & "<br /><br /><b>Report Viewer:</b> PDF"
                        ddlViewer.SelectedIndex = 1
                    Case Else
                        lblDescription.Text = lblDescription.Text & "<br /><br /><b>Report Viewer:</b> Web Viewer"
                End Select
            End If

            lblDescription.Text = lblDescription.Text & "<br /><br /><b>Record Last Modified by:</b> " & strRecordLastModified

            ' Build the Schedule section
            ' Added a check to see if this if a hyperlink and if it is then don't display the scheduler section
            ' Jeff Lyon - 10/26/2016 - version 3.7.1.6
            If strDocumentType = "Hyperlink" Then
                documentSchedules.Attributes.Add("style", "display: none;")
            Else
                If RSCommon.UseMinimizeHomePageData = True Or UserOption.GetOptionValueByUserIDAndDescription(_UserID, "MinimalHomePage") = "yes" Then
                    ' Don't Display
                    documentSchedules.Attributes.Add("style", "display: none;")
                ElseIf _objUser.IsAdministrator = False AndAlso _objUser.IsPublisher = False AndAlso _objUser.IsScheduler = False AndAlso _objUser.IsSuperUser = False Then
                    documentSchedules.Attributes.Add("style", "display: none;")
                Else

                    Dim dsSchedules As New ScheduledDocumentsDataSet(DocumentID)
                    Dim ScheduleTable = dsSchedules.ScheduledDataset.Tables(0)

                    lblSchedule.Text = ""
                    If ScheduleTable.Rows.Count = 0 Then
                        lblSchedule.Text = "There are no scheduled jobs for this report<br /><br />"
                    End If
                    For Each rowSchedule As DataRow In ScheduleTable.Rows
                        Dim ScheduleRow As String = "<b>Name:</b> " & rowSchedule.Item("Description").ToString & "<br />" &
                     rowSchedule.Item("CurrentInstanceHrefImage").ToString & rowSchedule.Item("CurrentInstanceHref").ToString & "<br />"

                        If rowSchedule.Item("HistoryHref").ToString.Length > 0 Then
                            ScheduleRow &= "<a class='scheduleHistoryButton' href='" & rowSchedule.Item("HistoryHref").ToString & "'><img src='Images/History.gif' border='0'></a>"
                            ScheduleRow &= "<a href=""" & rowSchedule.Item("HistoryHref").ToString & """>History</a><br /><br />"
                        End If

                        If _objUser.IsSuperUser Then
                            ScheduleRow &= "<a class='scheduleEditButton' href=""" & rowSchedule.Item("EditHref").ToString & """><img src='Images/Edit.gif' border='0'></a>"
                            ScheduleRow &= "<a href=""" & rowSchedule.Item("EditHref").ToString & """>Edit Schedule</a><br /><br />"
                        ElseIf _objUser.IsAdministrator Or _objUser.IsScheduler Then
                            ' Added code for Administrators to check to see if they are a Admin for the folder 
                            ' of the Document they have clicked on.
                            ' Jeff Lyon - 02/25/2011 - Version 2.9.11
                            If Ripplestone.BLL.SecurityRole.CheckPermissionsForSchedule(_objUser.ID, DocFolderID) Then
                                ScheduleRow &= "<a class='scheduleEditButton' href=""" & rowSchedule.Item("EditHref").ToString & """><img src='Images/Edit.gif' border='0'></a>"
                                ScheduleRow &= "<a href=""" & rowSchedule.Item("EditHref").ToString & """>Edit Schedule</a><br /><br />"
                            End If
                        End If

                        lblSchedule.Text = lblSchedule.Text & ScheduleRow
                    Next
                    documentSchedules.Attributes.Add("style", "display: block;")
                End If
            End If

            ' Set the nodeValue for the Add New Schedule link
            If _objUser.IsSuperUser Then
                linkDocumentSchedule.NavigateUrl = "EditSchedule.aspx?Mode=A&nodeValue=" & objNode.Value
                linkDocumentSchedule.Attributes.Add("style", "display: inline;")
                imgbtnDocumentSchedule.PostBackUrl = "EditSchedule.aspx?Mode=A&nodeValue=" & objNode.Value
                imgbtnDocumentSchedule.Attributes.Add("style", "display: inline;")
            ElseIf _objUser.IsAdministrator Or _objUser.IsScheduler Then
                ' Added code for Administrators to check to see if they are a Admin for the folder 
                ' of the Document they have clicked on.
                ' Jeff Lyon - 02/25/2011 - Version 2.9.11
                If Ripplestone.BLL.SecurityRole.CheckPermissionsForSchedule(_objUser.ID, DocFolderID) Then
                    linkDocumentSchedule.NavigateUrl = "EditSchedule.aspx?Mode=A&nodeValue=" & objNode.Value
                    linkDocumentSchedule.Attributes.Add("style", "display: inline;")
                    imgbtnDocumentSchedule.PostBackUrl = "EditSchedule.aspx?Mode=A&nodeValue=" & objNode.Value
                    imgbtnDocumentSchedule.Attributes.Add("style", "display: inline;")
                Else
                    linkDocumentSchedule.NavigateUrl = "#"
                    linkDocumentSchedule.Attributes.Add("style", "display: none;")
                    imgbtnDocumentSchedule.PostBackUrl = ""
                    imgbtnDocumentSchedule.Attributes.Add("style", "display: none;")
                End If
            Else
                linkDocumentSchedule.NavigateUrl = "#"
                linkDocumentSchedule.Attributes.Add("style", "display: none;")
                imgbtnDocumentSchedule.PostBackUrl = ""
                imgbtnDocumentSchedule.Attributes.Add("style", "display: none;")
            End If

            ' Changed to check the permissions for each document's folder
            ' JSL - 07/06/2009 - 2.9.9
            If _objUser.IsSuperUser Then
                documentMaintenance.Attributes.Add("style", "display: block;")
            Else
                If Ripplestone.BLL.SecurityRole.CheckPermissionsForPublish(_objUser.ID, DocFolderID) = True Then
                    documentMaintenance.Attributes.Add("style", "display: block;")
                Else
                    documentMaintenance.Attributes.Add("style", "display: none;")
                End If
            End If

            ripplestoneHome.Attributes.Add("style", "display: none;")
            myDocuments.Attributes.Add("style", "display: none;")
            folderHome.Attributes.Add("style", "display: none;")
            documentActions.Attributes.Add("style", "display: block;")
            documentMetrics.Attributes.Add("style", "display: block;")
            documentSearch.Attributes.Add("style", "display: none;")
        ElseIf objNode.Category = "Ripplestone" Then
            panelHome.HeaderText = RSCommon.GetRipplestoneHomeTitle
            lblHomeMessage.Text = RSCommon.GetRipplestoneHomeMessage
            ripplestoneHome.Attributes.Add("style", "display: block;")
            ' New for version 3.3.2
            If RSCommon.UseMinimizeHomePageData = True Or UserOption.GetOptionValueByUserIDAndDescription(_UserID, "MinimalHomePage") = "yes" Then
                myDocuments.Attributes.Add("style", "display: none;")          ' New for version 2.9.9
            Else
                myDocuments.Attributes.Add("style", "display: block;")         ' New for version 2.9.9
            End If
            folderHome.Attributes.Add("style", "display: none;")
            documentActions.Attributes.Add("style", "display: none;")
            documentMaintenance.Attributes.Add("style", "display: none;")
            documentSchedules.Attributes.Add("style", "display: none;")
            documentMetrics.Attributes.Add("style", "display: none;")
            documentSearch.Attributes.Add("style", "display: none;")
            If _objUser.IsSuperUser Or _objUser.IsAdministrator Then
                EditRootFolder.Attributes.Add("style", "display: block;")
                RSNewFolder.Attributes.Add("style", "display: block;")
                linkRootFolderEdit.NavigateUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                imgbtnRootFolderEdit.PostBackUrl = "EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString
                imgbtnPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                linkPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
            ElseIf _objUser.IsPublisher Then
                EditRootFolder.Attributes.Add("style", "display: none;")
                RSNewFolder.Attributes.Add("style", "display: none;")
                linkRootFolderEdit.NavigateUrl = "#"
                imgbtnRootFolderEdit.PostBackUrl = "#"
                imgbtnPublish.PostBackUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
                linkPublish.NavigateUrl = "EditPublishedReport.aspx?Mode=A&folderNode=F" & FolderID.ToString
            Else
                EditRootFolder.Attributes.Add("style", "display: none;")
                RSNewFolder.Attributes.Add("style", "display: none;")
                linkRootFolderEdit.NavigateUrl = "#"
                imgbtnRootFolderEdit.PostBackUrl = "#"
                imgbtnPublish.PostBackUrl = "#"
                linkPublish.NavigateUrl = "#"
            End If
            If _objUser.IsSuperUser Or _objUser.IsAdministrator Or _objUser.IsPublisher Then
                RSNewDocument.Attributes.Add("style", "display: block;")
            Else
                RSNewDocument.Attributes.Add("style", "display: none;")
            End If
            If _objUser.IsSuperUser Or _objUser.IsAdministrator Or _objUser.IsScheduler Then
                RSNewSchedule.Attributes.Add("style", "display: block;")
            Else
                RSNewSchedule.Attributes.Add("style", "display: none;")
            End If
        End If

    End Sub

#End Region

#Region " Nav Tree Events and Methods "

    Private Sub LoadTreeNode(ByVal objNode As RadTreeNode)

        If objNode.Category = "Document" Or objNode.Category = "Ripplestone" Then
            Return
        End If

        Dim FolderID As Integer = CInt(objNode.Value.Substring(1))

        TreeFunctions.LoadDocumentNodes(objNode, FolderID, _UserID, False)

    End Sub

    Protected Sub RadTreeFolders_ContextMenuItemClick(ByVal sender As Object, ByVal e As RadTreeViewContextMenuEventArgs) Handles RadTreeFolders.ContextMenuItemClick

        Select Case e.MenuItem.Value
            Case "New Folder"
                Response.Redirect("EditFolders.aspx?Mode=A", True)
            Case "Edit Folder"
                Dim FolderID As Integer = CInt(e.Node.Value.Substring(1))
                Response.Redirect("EditFolders.aspx?Mode=C&FolderID=" & FolderID.ToString, True)
            Case "Delete Folder"
                Dim FolderID As Integer = CInt(e.Node.Value.Substring(1))

                Dim result As Integer = Ripplestone.BLL.DocumentFolder.DeleteFromDB(FolderID, True)

                Select Case result
                    Case 1 ' Success
                        Dim objNode = RadTreeFolders.FindNodeByValue("F" & FolderID)
                        If Not objNode Is Nothing Then
                            Dim objPrevNode = objNode.Prev
                            If objPrevNode Is Nothing Then
                                objPrevNode = objNode.ParentNode
                            End If
                            objNode.Remove()
                            If Not objPrevNode Is Nothing Then
                                objPrevNode.Selected = True
                                ShowSelectedNode(objPrevNode)
                            End If
                        End If
                    Case 0 ' Error
                        ' Display that there was an error deleting the folder
                        lblMessages.Text = "There was an error deleting the folder"
                    Case 99 ' Shared Folder
                        ' Display that this is the System Shared Folder
                        lblMessages.Text = "The System Shared Folder Cannot be Deleted"
                End Select

            Case "Delete Document"
                Dim DocumentID As Integer = CInt(e.Node.Value.Substring(1))

                DeleteDoc(DocumentID)

            Case "Run Document"
                Dim DocumentID As Integer = CInt(e.Node.Value.Substring(1))
                LoadReport(DocumentID, "RightClick")

            Case "Edit Document"
                Dim DocumentID As Integer = CInt(e.Node.Value.Substring(1))
                Response.Redirect("EditPublishedReport.aspx?Mode=C&ReportId=" & DocumentID & "&nodeValue=D" & DocumentID, True)

            Case "New Schedule"
                Response.Redirect("EditSchedule.aspx?Mode=A", True)

            Case "Move Document"
                Dim DocumentID As Integer = CInt(e.Node.Value.Substring(1))
                Dim FolderID As Integer = CInt(e.Node.ParentNode.Value.Substring(1))
                Dim objDoc As Ripplestone.BLL.Document
                objDoc = Ripplestone.BLL.Document.GetDocumentByID(DocumentID)
                Dim DocumentFileName As String = objDoc.FileName

                Response.Redirect("MoveDocument.aspx?DocID=" & DocumentID.ToString & "&FolderID=" & FolderID.ToString & "&DocName=" & DocumentFileName, True)

            Case "New Document"
                Dim folderNode As String = ""

                If e.Node.Value.StartsWith("F") Then
                    folderNode = e.Node.Value
                ElseIf e.Node.Value.StartsWith("D") Then
                    folderNode = e.Node.ParentNode.Value
                End If
                Response.Redirect("EditPublishedReport.aspx?Mode=A&folderNode=" & folderNode, True)

            Case Else

        End Select

    End Sub

    Private Sub RadTreeFolders_NodeExpand(ByVal o As Object, ByVal e As RadTreeNodeEventArgs) Handles RadTreeFolders.NodeExpand

        Dim objNode = e.Node

        LoadTreeNode(objNode)

    End Sub

    Private Sub RadTreeFolders_NodeClick(ByVal o As Object, ByVal e As RadTreeNodeEventArgs) Handles RadTreeFolders.NodeClick

        Dim objNode = e.Node

        LoadTreeNode(objNode)

        objNode.Expanded = True

        ShowSelectedNode(objNode)

    End Sub

#End Region

#Region " Search Methods "

    Protected Sub aspxbtnSearch_Click() Handles aspxbtnSearch.Click

        ripplestoneHome.Attributes.Add("style", "display: none;")
        myDocuments.Attributes.Add("style", "display: none;")
        folderHome.Attributes.Add("style", "display: none;")
        documentMaintenance.Attributes.Add("style", "display: none;")
        documentActions.Attributes.Add("style", "display: none;")
        documentSchedules.Attributes.Add("style", "display: none")
        documentMetrics.Attributes.Add("style", "display: none;")

        documentSearch.Attributes.Add("style", "display: block;")

        Dim DocumentSearchDataSet As New PublishedReportsDataSet(aspxtxtSearch.Text.Trim, _UserID)

        repeaterSearch.DataSource = DocumentSearchDataSet.ReportDataView
        repeaterSearch.DataBind()

    End Sub

    Private Sub repeaterSearch_ItemCommand(source As Object, e As RepeaterCommandEventArgs) Handles repeaterSearch.ItemCommand

        If e.CommandName = "RunSearchImage" Or e.CommandName = "RunSearchLink" Then
            Dim docID As Integer = CInt(e.CommandArgument)
            LoadReport(docID, "Search")
        End If

    End Sub

#End Region

#Region " Button Events - Delete, Run "

    Private Sub linkbtnFolderDelete_Command(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.CommandEventArgs) Handles linkbtnFolderDelete.Command, imgbtnFolderDelete.Command

        If e.CommandName = "Delete" Then
            Dim FolderID As Integer = CInt(e.CommandArgument)

            Dim result As Integer = DocumentFolder.DeleteFromDB(FolderID, True)

            Select Case result
                Case 1 ' Success
                    Dim objNode = RadTreeFolders.FindNodeByValue("F" & FolderID)
                    If Not objNode Is Nothing Then
                        Dim objPrevNode = objNode.Prev
                        If objPrevNode Is Nothing Then
                            objPrevNode = objNode.ParentNode
                        End If
                        objNode.Remove()
                        If Not objPrevNode Is Nothing Then
                            objPrevNode.Selected = True
                            ShowSelectedNode(objPrevNode)
                        End If
                    End If
                Case 0 ' Error
                    ' Display that there was an error deleting the folder
                    lblMessages.Text = "There was an error deleting the folder"
                Case 98 ' System Folder
                    ' Display that this is the System Folder
                    lblMessages.Text = "The System Folder Cannot be Deleted"
                Case 99 ' Shared Folder
                    ' Display that this is the System Shared Folder
                    lblMessages.Text = "The System Shared Folder Cannot be Deleted"
            End Select
        End If

    End Sub

    Private Sub linkbtnDeleteDoc_Command(sender As Object, e As System.Web.UI.WebControls.CommandEventArgs) Handles linkbtnDeleteDoc.Command

        If e.CommandName = "Delete" Then
            Dim documentID As Integer = CInt(e.CommandArgument)

            DeleteDoc(documentID)

        End If

    End Sub

    Private Sub imgbtnDeleteDoc_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgbtnDeleteDoc.Click

        Dim documentID As Integer = CInt(RadTreeFolders.SelectedNode.Value.Substring(1))

        DeleteDoc(documentID)

    End Sub

    Private Sub imgbtnRunDoc_Click(sender As Object, e As System.Web.UI.ImageClickEventArgs) Handles imgbtnRunDoc.Click

        ' Added check to see if there is a value in the CommandArgument
        ' Jeff Lyon - 3/19/2014 - version 3.4.5.2
        ' Changed the method used to get the documentID
        ' Jeff Lyon - 4/28/2014 - version 3.4.5.3
        Dim documentID As Integer = CInt(RadTreeFolders.SelectedNode.Value.Substring(1))

        If documentID > 0 Then
            LoadReport(documentID, "RunDoc")
        Else
            lblMessages.Text = "The Document ID could not be found"
        End If

    End Sub

    Private Sub lnkbtnRunDoc_Click(sender As Object, e As System.EventArgs) Handles lnkbtnRunDoc.Click

        ' Added check to see if there is a value in the CommandArgument
        ' Jeff Lyon - 3/19/2014 - version 3.4.5.2
        ' Changed the method used to get the documentID
        ' Jeff Lyon - 4/28/2014 - version 3.4.5.3
        Dim documentID As Integer = CInt(RadTreeFolders.SelectedNode.Value.Substring(1))

        If documentID > 0 Then
            LoadReport(documentID, "RunDoc")
        Else
            lblMessages.Text = "The Document ID could not be found"
        End If

    End Sub

#End Region

#Region " My Favorites "

    Private Sub imgbtnAddFavorite_Click(ByVal sender As System.Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgbtnAddFavorite.Click

        Dim documentID As String = RadTreeFolders.SelectedNode.Value.Substring(1)

        Ripplestone.BLL.DocumentFavorite.InsertDocumentFavorite(CInt(documentID), _UserID)

        Dim FavoriteDocumentsList As List(Of Ripplestone.BLL.DocumentFavorite)
        FavoriteDocumentsList = Ripplestone.BLL.DocumentFavorite.GetDocumentFavoriteByUserID(_UserID)

        repeaterFavorites.DataSource = FavoriteDocumentsList
        repeaterFavorites.DataBind()

    End Sub

    ''' <summary>
    ''' Repeater control to list the favorites
    ''' </summary>
    ''' <param name="source"></param>
    ''' <param name="e"></param>
    ''' <remarks>
    ''' Jeff Lyon - 7/31/2015 - version 3.6.1.5
    ''' </remarks>
    Private Sub repeaterFavorites_ItemCommand(source As Object, e As RepeaterCommandEventArgs) Handles repeaterFavorites.ItemCommand

        If e.CommandName = "RunFavImage" Or e.CommandName = "RunFavLink" Then
            Dim docID As Integer = CInt(e.CommandArgument)
            LoadReport(docID, "Favorites")
        ElseIf e.CommandName = "DeleteFav" Then
            Dim docFavID As Integer = CInt(e.CommandArgument)

            Ripplestone.BLL.DocumentFavorite.DeleteDocumentFavoriteByID(docFavID)

            Dim FavoriteDocumentsList As List(Of Ripplestone.BLL.DocumentFavorite)
            FavoriteDocumentsList = Ripplestone.BLL.DocumentFavorite.GetDocumentFavoriteByUserID(_UserID)

            repeaterFavorites.DataSource = FavoriteDocumentsList
            repeaterFavorites.DataBind()
        End If

    End Sub

    ''' <summary>
    ''' Repeater control to list the favorites when used as the home page
    ''' </summary>
    ''' <param name="source"></param>
    ''' <param name="e"></param>
    ''' <remarks>
    ''' Jeff Lyon - 8/3/2015 - version 3.6.1.5
    ''' </remarks>
    Private Sub repeaterFavoritesHome_ItemCommand(source As Object, e As RepeaterCommandEventArgs) Handles repeaterFavoritesHome.ItemCommand

        If e.CommandName = "RunFavImage" Or e.CommandName = "RunFavLink" Then
            Dim docID As Integer = CInt(e.CommandArgument)
            LoadReport(docID, "Favorites")
        ElseIf e.CommandName = "DeleteFav" Then
            Dim docFavID As Integer = CInt(e.CommandArgument)

            DocumentFavorite.DeleteDocumentFavoriteByID(docFavID)

            Dim FavoriteDocumentsList As List(Of DocumentFavorite)
            FavoriteDocumentsList = DocumentFavorite.GetDocumentFavoriteByUserID(_UserID)

            repeaterFavorites.DataSource = FavoriteDocumentsList
            repeaterFavorites.DataBind()
        End If

    End Sub

#End Region

#Region " Report Tabs "

    Private Sub aspxbtnCloseReport1_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseReport1.Click

        Try
            ' Close the report and delete the session variable
            If _crystalReport1 IsNot Nothing Then
                _crystalReport1.Close()
                _crystalReport1.Dispose()
                GC.Collect()
                Session.Remove("report1")
                CrystalReportViewer1.ReportSource = Nothing
            End If

            ' Hides the Report 1 Tab
            ASPxPageControl1.TabPages(2).Text = "Empty Report 1"
            ASPxPageControl1.TabPages(2).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
            hideDocID1.Value = "0"
            Session.Item("ReportExported1") = "false"
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.btnCloseReport1", "Error in btnCloseReport1_Click")
        End Try

    End Sub

    Private Sub aspxbtnCloseReport2_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseReport2.Click

        Try
            ' Close the report and delete the session variable
            If _crystalReport2 IsNot Nothing Then
                _crystalReport2.Close()
                _crystalReport2.Dispose()
                GC.Collect()
                Session.Remove("report2")
                CrystalReportViewer2.ReportSource = Nothing
            End If

            ' Hides the Report 2 Tab
            ASPxPageControl1.TabPages(3).Text = "Empty Report 2"
            ASPxPageControl1.TabPages(3).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
            hideDocID2.Value = "0"
            Session.Item("ReportExported2") = "false"
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.btnCloseReport2", "Error in btnCloseReport2_Click")
        End Try

    End Sub

    Private Sub aspxbtnCloseReport3_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseReport3.Click

        Try
            ' Close the report and delete the session variable
            If _crystalReport3 IsNot Nothing Then
                _crystalReport3.Close()
                _crystalReport3.Dispose()
                GC.Collect()
                Session.Remove("report3")
                CrystalReportViewer3.ReportSource = Nothing
            End If

            ' Hides the Report 3 Tab
            ASPxPageControl1.TabPages(4).Text = "Empty Report 3"
            ASPxPageControl1.TabPages(4).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
            HideDocID3.Value = "0"
            Session.Item("ReportExported3") = "false"
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.btnCloseReport3", "Error in btnCloseReport3_Click")
        End Try

    End Sub

    Private Sub aspxbtnCloseReport4_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseReport4.Click

        Try
            ' Close the report and delete the session variable
            If _crystalReport4 IsNot Nothing Then
                _crystalReport4.Close()
                _crystalReport4.Dispose()
                GC.Collect()
                Session.Remove("report4")
                CrystalReportViewer4.ReportSource = Nothing
            End If

            ' Hides the Report 4 Tab
            ASPxPageControl1.TabPages(5).Text = "Empty Report 4"
            ASPxPageControl1.TabPages(5).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
            HideDocID4.Value = "0"
            Session.Item("ReportExported4") = "false"
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.btnCloseReport4", "Error in btnCloseReport4_Click")
        End Try

    End Sub

    Private Sub aspxbtnCloseReport5_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseReport5.Click

        Try
            ' Close the report and delete the session variable
            If _crystalReport5 IsNot Nothing Then
                _crystalReport5.Close()
                _crystalReport5.Dispose()
                GC.Collect()
                Session.Remove("report5")
                CrystalReportViewer5.ReportSource = Nothing
            End If

            ' Hides the Report 5 Tab
            ASPxPageControl1.TabPages(6).Text = "Empty Report 5"
            ASPxPageControl1.TabPages(6).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
            HideDocID5.Value = "0"
            Session.Item("ReportExported5") = "false"
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.btnCloseReport5", "Error in btnCloseReport5_Click")
        End Try

    End Sub

#End Region

#Region " Load the Report "

    ' Added the source parameter to determine where the LoadReport is being called from.
    ' Jeff Lyon - 2/5/2015 - version 3.5.2.2
    Private Function LoadReport(ByVal DocID As Integer, Optional ByVal source As String = "RunDoc") As Boolean

        If DocID = 0 Then
            ' The Rpt parameter was not part of the URL
            If IsTraceLogOn() = True Then
                Dim MyLog As New Log(_objUser.UserLogin)
                MyLog.WriteComment("Home.aspx_LoadReport - The querystring parameter(DocID) was not passed to the page")
                MyLog.Close()
            End If

            Return False
        End If

        Dim UserID As Integer = 0

        If IsTraceLogOn() = True Then
            Dim MyLog As New Log(_objUser.UserLogin)
            MyLog.WriteComment("Home.aspx_LoadReport - Getting Report information from DB")
            MyLog.Close()
        End If

        '******************************************************************************************
        ' Get the Document object for the passed in DocumentID
        '******************************************************************************************
        Dim objDoc As Document
        objDoc = Document.GetDocumentByID(DocID)

        Dim strReportPath As String = objDoc.FilePath
        Dim strReportName As String = objDoc.FileName
        Dim strFolderName As String = objDoc.Folder.FolderName

        Dim strDefaultViewer As String = ""
        If objDoc.Viewer <> "" Then
            strDefaultViewer = objDoc.Viewer
        Else
            strDefaultViewer = RSCommon.GetDefaultViewer
        End If

        If IsTraceLogOn() = True Then
            Dim MyLog As New Log(_objUser.UserLogin)
            MyLog.WriteComment("Home.aspx_LoadReport - Ripplestone Document Information Retrieved")
            MyLog.Close()
        End If

        ' Check for the rpt file
        If objDoc.ReportType <> "Hyperlink" AndAlso My.Computer.FileSystem.FileExists(strReportPath) = False Then
            Dim MyLog As New Log(_objUser.UserLogin)
            MyLog.WriteComment("Home.aspx_LoadReport - The report file was not found at location " & strReportPath)
            MyLog.Close()
            lblMessages.Text = "The report file was not found."
            Return False
        End If

        '******************************************************************************************
        ' Get the User object from either Session or the DB
        '******************************************************************************************
        Dim oUser As New User

        If Session("RSUser") IsNot Nothing Then
            oUser = TryCast(Session("RSUser"), Ripplestone.BLL.User)
            If oUser Is Nothing Then
                ' Cannot determine who the user is, so redirect to the login page
                Response.Redirect("SignOn.aspx", True)
            End If
        Else
            ' Cannot determine who the user is, so redirect to the login page
            Response.Redirect("SignOn.aspx", True)
        End If

        UserID = oUser.ID

        ' Added new code to check if the document is something other than a Crystal Report
        ' Jeff Lyon - 8/5/2015 - version 3.6.1.5
        Dim scriptCmd As String = ""

        Select Case objDoc.ReportType
            Case "Crystal Report"
                LoadCrystalReport(DocID, strDefaultViewer, source, strReportPath, oUser, strFolderName, objDoc.Title)
            Case "Excel"
                LoadExcelDocument(DocID)  ' Added to use the Excel viewer - Jeff Lyon - 7/24/2020 - version 3.20.7.1
            Case "Word"
                LoadWordDocument(DocID)   ' Added to use the Word viewer - Jeff Lyon - 7/24/2020 - version 3.20.7.1
            Case "Acrobat", "Word", "PowerPoint"
                DocumentUsage.InsertDocumentUsage(DocID, UserID, Now)
                Dim strDocumentPath As String = String.Format("ReportFolders/{0}/{1}", Ripplestone.BLL.DocumentFolder.GetFullFolderPath(objDoc.FolderID, False, "/"), objDoc.FileName)
                scriptCmd = "<script>window.open('" & strDocumentPath & "','_blank');</script>"

                Page.ClientScript.RegisterClientScriptBlock(Me.GetType(), "openOfficeDoc", scriptCmd)
                Return True

            Case "Hyperlink"
                DocumentUsage.InsertDocumentUsage(DocID, UserID, Now)
                scriptCmd = "<script>window.open('" & objDoc.FileName & "','_blank');</script>"

                Page.ClientScript.RegisterClientScriptBlock(Me.GetType(), "openWebsite", scriptCmd)
                Return True
            Case "Ripplestone Report"
                'Dim newReportTab As DevExpress.Web.TabPage
                'newReportTab = ASPxPageControl1.TabPages.Add("New Report", "NewReport")
                'Dim lbl As New Label
                'lbl.Text = "New Report Label"
                'newReportTab.Controls.Add(lbl)
                'Return True
                LoadRipplestoneReport(DocID)
                'Response.Redirect("ReportViewer.aspx?DocID=" & DocID, True)
        End Select

        DocumentUsage.InsertDocumentUsage(DocID, UserID, Now)

    End Function

    Private Shared Function GetTempFileName(ByVal FileType As String) As String

        Dim r As New Random(System.DateTime.Now.Millisecond)
        Dim strRandomNumber As String = r.Next(1, 100).ToString
        Dim strTempFileName As String = String.Format("rstmp{0}_{1:yyyy_MM_dd HHmmssff}", strRandomNumber, Date.Now)

        Select Case FileType

            Case "RPT"
                strTempFileName &= ".rpt"
            Case "PDF"
                strTempFileName &= ".pdf"
            Case "Excel"
                strTempFileName &= ".xls"
            Case "CSV"
                strTempFileName &= ".csv"
            Case "Text"
                strTempFileName &= ".txt"
        End Select

        Return strTempFileName

    End Function

#Region " Set Report Viewer Options "

    Private Sub SetReportViewerOptions(ByVal intReportID As Integer, ByVal viewerNumber As Integer)

        '****************************************************************
        ' Check if the current user can print and/or export this report
        ' Also set any other configurable options for the viewer.
        '****************************************************************
        Dim blnIsPrintSecurityOn As Boolean = RSCommon.IsGlobalPrintSecurityOn
        Dim blnIsExportSecurityOn As Boolean = RSCommon.IsGlobalExportSecurityOn
        Dim hideRefreshToolbarButton As Boolean = Utilities.GetRipplestoneConfigBooleanValue("hideRefreshToolbarButton", "0")
        Dim hideSearchToolbarButton As Boolean = Utilities.GetRipplestoneConfigBooleanValue("hideSearchToolbarButton", "0")
        Dim CRViewerExport As String = DocumentOption.GetOptionValueByReportIDAndDescription(intReportID, "CRViewerExport")
        Dim CRViewerPrint As String = DocumentOption.GetOptionValueByReportIDAndDescription(intReportID, "CRViewerPrint")
        Dim CRViewerRefresh As String = DocumentOption.GetOptionValueByReportIDAndDescription(intReportID, "CRViewerRefresh")
        Dim CRViewerSearch As String = DocumentOption.GetOptionValueByReportIDAndDescription(intReportID, "CRViewerSearch")

        ' Added to simplify the Export and Print override
        ' Jeff Lyon - 6/28/2019 - version 3.9.6.2
        If CRViewerExport <> String.Empty Then
            If CRViewerExport = "yes" Then
                blnIsExportSecurityOn = False
            ElseIf CRViewerExport = "no" Then
                blnIsExportSecurityOn = True
            End If
        End If

        If CRViewerPrint <> String.Empty Then
            If CRViewerPrint = "yes" Then
                blnIsPrintSecurityOn = False
            ElseIf CRViewerPrint = "no" Then
                blnIsPrintSecurityOn = True
            End If
        End If

        ' Added code to override the global setting for Refresh
        ' Jeff Lyon - 5/27/2020 - version 3.20.5.1
        If CRViewerRefresh <> String.Empty Then
            If CRViewerRefresh = "yes" Then
                hideRefreshToolbarButton = False
            ElseIf CRViewerRefresh = "no" Then
                hideRefreshToolbarButton = True
            End If
        End If

        ' Added code to override the global setting for Search
        ' Jeff Lyon - 5/27/2020 - version 3.20.5.1
        If CRViewerSearch <> String.Empty Then
            If CRViewerSearch = "yes" Then
                hideSearchToolbarButton = False
            ElseIf CRViewerSearch = "no" Then
                hideSearchToolbarButton = True
            End If
        End If

        Select Case viewerNumber
            Case 1
                ' Set the global option first
                CrystalReportViewer1.HasExportButton = Not blnIsExportSecurityOn
                CrystalReportViewer1.HasPrintButton = Not blnIsPrintSecurityOn
                CrystalReportViewer1.HasRefreshButton = Not hideRefreshToolbarButton
                CrystalReportViewer1.HasSearchButton = Not hideSearchToolbarButton

                ' Added to disable the Custom Export button if they are not allowed to export
                ' also disable the refresh button if that option is turned on
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                aspxbtnCustomExport1.Enabled = Not blnIsExportSecurityOn
                aspxbtnReportRefresh1.Enabled = Not hideRefreshToolbarButton

                ' Check to see how to use hyperlinks in the viewer
                ' JSL - 11/06/2006
                If RSCommon.IsOpenHyperlinksOn = True Then
                    CrystalReportViewer1.HyperlinkTarget = "_blank"
                Else
                    CrystalReportViewer1.HyperlinkTarget = "_self"
                End If

                If ReportViewerOptions.GetReportViewerGlobalPrintMode = "pdf" Then
                    CrystalReportViewer1.PrintMode = PrintMode.Pdf
                Else
                    CrystalReportViewer1.PrintMode = PrintMode.ActiveX
                End If
            Case 2
                ' Set the global option first
                CrystalReportViewer2.HasExportButton = Not blnIsExportSecurityOn
                CrystalReportViewer2.HasPrintButton = Not blnIsPrintSecurityOn
                CrystalReportViewer2.HasRefreshButton = Not hideRefreshToolbarButton
                CrystalReportViewer2.HasSearchButton = Not hideSearchToolbarButton

                ' Added to disable the Custom Export button if they are not allowed to export
                ' also disable the refresh button if that option is turned on
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                aspxbtnCustomExport2.Enabled = Not blnIsExportSecurityOn
                aspxbtnReportRefresh2.Enabled = Not hideRefreshToolbarButton

                ' Check to see how to use hyperlinks in the viewer
                ' JSL - 11/06/2006
                If RSCommon.IsOpenHyperlinksOn = True Then
                    CrystalReportViewer2.HyperlinkTarget = "_blank"
                Else
                    CrystalReportViewer2.HyperlinkTarget = "_self"
                End If

                If ReportViewerOptions.GetReportViewerGlobalPrintMode = "pdf" Then
                    CrystalReportViewer2.PrintMode = PrintMode.Pdf
                Else
                    CrystalReportViewer2.PrintMode = PrintMode.ActiveX
                End If
            Case 3
                ' Set the global option first
                CrystalReportViewer3.HasExportButton = Not blnIsExportSecurityOn
                CrystalReportViewer3.HasPrintButton = Not blnIsPrintSecurityOn
                CrystalReportViewer3.HasRefreshButton = Not hideRefreshToolbarButton
                CrystalReportViewer3.HasSearchButton = Not hideSearchToolbarButton

                ' Added to disable the Custom Export button if they are not allowed to export
                ' also disable the refresh button if that option is turned on
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                aspxbtnCustomExport3.Enabled = Not blnIsExportSecurityOn
                aspxbtnReportRefresh3.Enabled = Not hideRefreshToolbarButton

                ' Check to see how to use hyperlinks in the viewer
                ' JSL - 11/06/2006
                If RSCommon.IsOpenHyperlinksOn = True Then
                    CrystalReportViewer3.HyperlinkTarget = "_blank"
                Else
                    CrystalReportViewer3.HyperlinkTarget = "_self"
                End If

                If ReportViewerOptions.GetReportViewerGlobalPrintMode = "pdf" Then
                    CrystalReportViewer3.PrintMode = PrintMode.Pdf
                Else
                    CrystalReportViewer3.PrintMode = PrintMode.ActiveX
                End If
            Case 4
                ' Set the global option first
                CrystalReportViewer4.HasExportButton = Not blnIsExportSecurityOn
                CrystalReportViewer4.HasPrintButton = Not blnIsPrintSecurityOn
                CrystalReportViewer4.HasRefreshButton = Not hideRefreshToolbarButton
                CrystalReportViewer4.HasSearchButton = Not hideSearchToolbarButton

                ' Added to disable the Custom Export button if they are not allowed to export
                ' also disable the refresh button if that option is turned on
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                aspxbtnCustomExport4.Enabled = Not blnIsExportSecurityOn
                aspxbtnReportRefresh4.Enabled = Not hideRefreshToolbarButton

                ' Check to see how to use hyperlinks in the viewer
                ' JSL - 11/06/2006
                If RSCommon.IsOpenHyperlinksOn = True Then
                    CrystalReportViewer4.HyperlinkTarget = "_blank"
                Else
                    CrystalReportViewer4.HyperlinkTarget = "_self"
                End If

                If ReportViewerOptions.GetReportViewerGlobalPrintMode = "pdf" Then
                    CrystalReportViewer4.PrintMode = PrintMode.Pdf
                Else
                    CrystalReportViewer4.PrintMode = PrintMode.ActiveX
                End If
            Case 5
                ' Set the global option first
                CrystalReportViewer5.HasExportButton = Not blnIsExportSecurityOn
                CrystalReportViewer5.HasPrintButton = Not blnIsPrintSecurityOn
                CrystalReportViewer5.HasRefreshButton = Not hideRefreshToolbarButton
                CrystalReportViewer5.HasSearchButton = Not hideSearchToolbarButton

                ' Added to disable the Custom Export button if they are not allowed to export
                ' also disable the refresh button if that option is turned on
                ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
                aspxbtnCustomExport5.Enabled = Not blnIsExportSecurityOn
                aspxbtnReportRefresh5.Enabled = Not hideRefreshToolbarButton

                ' Check to see how to use hyperlinks in the viewer
                ' JSL - 11/06/2006
                If RSCommon.IsOpenHyperlinksOn = True Then
                    CrystalReportViewer5.HyperlinkTarget = "_blank"
                Else
                    CrystalReportViewer5.HyperlinkTarget = "_self"
                End If

                If ReportViewerOptions.GetReportViewerGlobalPrintMode = "pdf" Then
                    CrystalReportViewer5.PrintMode = PrintMode.Pdf
                Else
                    CrystalReportViewer5.PrintMode = PrintMode.ActiveX
                End If
        End Select

    End Sub

#End Region

#End Region

#Region " Load Crystal Report "

    Private Function LoadCrystalReport(ByVal docID As Integer, ByVal defaultViewer As String, ByVal source As String, ByVal reportPath As String, ByVal oUser As User, ByVal foldername As String, ByVal docTitle As String) As Boolean

        ' Added an additional If statement to check if the user has selected the Web Viewer
        ' If they have selected the web viewer then bypass the next section of code
        ' Jeff Lyon - 9/8/2016 - version 3.7.1.5
        If ddlViewer.SelectedValue <> "web" Then
            Dim scriptCmd As String = ""

            ' Added the Viewer Drop Down, so users can select a viewer
            ' Jeff Lyon - 7/30/14 - version 3.4.5.4
            If defaultViewer = "PDF" OrElse ddlViewer.SelectedValue <> "web" Then
                ' If the report is being run from the Run Document link with the ddlViewer, use the selected viewer.
                ' If the report is being run from somewhere else, use the viewered stored in the DB.
                ' Jeff Lyon - 2/5/2015 - version 3.5.2.2
                ' Added new items to the list of viewers
                ' Jeff Lyon - 10/24/17 - version 3.8.2.5
                ' Added paramType to determine which parameter window to use.  Can be either CR or RS.  Currently hard coded to CR
                ' The plan is to allow for the option to use the old Ripplestone parameter window as an option.
                ' Jeff Lyon - 5/16/2019 - version 3.9.7.1
                Dim paramType As String = "CR"
                If source = "RunDoc" Then
                    scriptCmd = "<script>window.open('CRViewerPDF.aspx?DocID=" & docID & "&viewer=" & ddlViewer.SelectedValue & "&paramType=" & paramType & "','_blank','resizable=1,toolbar=0,location=0,directories=0,addressbar=0,scrollbars=1,status=1,menubar=0,top=0,left=0,width=800,height=600');</script>"
                Else
                    scriptCmd = "<script>window.open('CRViewerPDF.aspx?DocID=" & docID & "&viewer=pdf&paramType=" & paramType & "','_blank','resizable=1,toolbar=0,location=0,directories=0,addressbar=0,scrollbars=1,status=1,menubar=0,top=0,left=0,width=800,height=600');</script>"
                End If

                Page.ClientScript.RegisterClientScriptBlock(Me.GetType(), "openPDFWindow", scriptCmd)
                Return True
            End If
        End If

        If ASPxPageControl1.TabPages(2).Text = "Empty Report 1" Then
            hideDocID1.Value = docID.ToString
            Try
                _crystalReport1 = New ReportDocument
                _crystalReport1.Load(reportPath, OpenReportMethod.OpenReportByTempCopy)
                ' Added to make sure it gets new data from the DB - JSL - 09/26/2007
                ' Removes saved data. This causes fresh data to be loaded when the report is subsequently viewed
                _crystalReport1.Refresh()
            Catch ex As Exception
                RSCommon.CreateTraceLogEntry(ex, "Home.LoadReport", "Error Loading the Report (Document - " & docTitle & " DocID: " & docID.ToString & ")")
                Return False
            End Try

            If IsTraceLogOn() = True Then
                Dim MyLog As New Log(_objUser.UserLogin)
                MyLog.WriteComment("Home.aspx_LoadReport - Report loaded into CR Report document object")
                MyLog.Close()
            End If

            ' *****************************************************************************************************
            ' Check the connection to the data source for this report, including any sub-reports
            ' *****************************************************************************************************
            If IsTraceLogOn() = True Then
                Dim MyLog As New Log(_objUser.UserLogin)
                MyLog.WriteComment("Home.aspx_LoadReport - Tables in the report: " & _crystalReport1.Database.Tables.Count)
                MyLog.Close()
            End If

            CrystalReportHelper.DoDBLogIn(_crystalReport1.Database.Tables, docID, _objUser.UserLogin)
            ' Set Login for any subreports
            CrystalReportHelper.SetDBLoginForSubReports(_crystalReport1)

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New Log(_objUser.UserLogin)
                MyLog.WriteComment("Home.LoadReport - DB Login Complete")
                MyLog.WriteComment("Home.LoadReport - Begin Row Level Security")
                MyLog.Close()
            End If

            ' Check for Row Level Security and apply any found
            Dim oReportRowSecurity As New ReportRowSecurity(_crystalReport1.Database.Tables, foldername, oUser.ID, _crystalReport1.RecordSelectionFormula, oUser.UserLogin)

            _crystalReport1.RecordSelectionFormula = oReportRowSecurity.GetRowSecurity()

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New Log(_objUser.UserLogin)
                MyLog.WriteComment("Home.LoadReport - Row Level Security Complete")
                MyLog.WriteComment("Home.LoadReport - Begin Dynamic Parameters")
                MyLog.Close()
            End If

            ' Added to enter the Parameter Name into the Prompt Text if the Prompt Text is empty
            ' Jeff Lyon - 4/12/13 - version 3.4.3
            ' This was removed because the PromptText would be Nothing and you can't add text to the property
            ' Jeff Lyon - 2/20/2014 - version 3.4.5.2
            'For Each oParameterFieldDefinition As ParameterFieldDefinition In _crystalReport1.DataDefinition.ParameterFields
            '	If oParameterFieldDefinition.PromptText IsNot Nothing AndAlso oParameterFieldDefinition.PromptText.Trim.Length = 0 Then
            '		oParameterFieldDefinition.PromptText = oParameterFieldDefinition.Name & ":"
            '	End If
            'Next

            ' Code to try and get the values from a Dynamic Parameter
            ' 3/25/2015
            'Ripplestone.CR.CrystalReportHelper.isParameterDynamic(_crystalReport1)

            CrystalReportParameter.FillRSDynamicParameters(docID, _crystalReport1, oUser)

            Session.Add("report1", _crystalReport1)

            If defaultViewer = "CRWebViewer" Then
                ' Only set the web viewer if that is the viewer being used
                SetReportViewerOptions(docID, 1)
            End If

            CrystalReportViewer1.ReportSource = _crystalReport1
            CrystalReportViewer1.EnableParameterPrompt = True
            CrystalReportViewer1.RefreshReport()
            CrystalReportViewer1.ShowFirstPage()

            ASPxPageControl1.TabPages(2).Text = docTitle
            ASPxPageControl1.TabPages(2).ClientVisible = True
            ASPxPageControl1.ActiveTabIndex = 2

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Load Report Complete")
                MyLog.Close()
            End If

        ElseIf ASPxPageControl1.TabPages(3).Text = "Empty Report 2" Then
            Try
                _crystalReport2 = New ReportDocument
                _crystalReport2.Load(reportPath, OpenReportMethod.OpenReportByTempCopy)
                ' Added to make sure it gets new data from the DB - JSL - 09/26/2007
                _crystalReport2.Refresh()
            Catch ex As Exception
                RSCommon.CreateTraceLogEntry(ex, "Home.LoadReport", "Error Loading the Report 2")
                Return False
            End Try

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 2 loaded into CR Report document object")
                MyLog.Close()
            End If

            ' *****************************************************************************************************
            ' Check the connection to the data source for this report, including any sub-reports
            ' *****************************************************************************************************
            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteEntry("Home.LoadReport", "Check the DB Login", "Tables in report 2: " & _crystalReport2.Database.Tables.Count)
                MyLog.Close()
            End If

            CrystalReportHelper.DoDBLogIn(_crystalReport2.Database.Tables, docID)
            ' Set Login for any subreports
            CrystalReportHelper.SetDBLoginForSubReports(_crystalReport2)

            ' Check for Row Level Security and apply any found
            Dim recordSelection = _crystalReport2.DataDefinition.RecordSelectionFormula

            Dim oReportRowSecurity As New ReportRowSecurity(_crystalReport2.Database.Tables, foldername, oUser.ID, _crystalReport2.RecordSelectionFormula, oUser.UserLogin)

            _crystalReport2.RecordSelectionFormula = oReportRowSecurity.GetRowSecurity()

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 2 ready to be sent to viewer")
                MyLog.Close()
            End If

            CrystalReportParameter.FillRSDynamicParameters(docID, _crystalReport2, oUser)

            Session.Add("report2", _crystalReport2)

            If defaultViewer = "CRWebViewer" Then
                ' Only set the web viewer if that is the viewer being used
                SetReportViewerOptions(docID, 2)
            End If

            CrystalReportViewer2.ReportSource = _crystalReport2
            CrystalReportViewer2.RefreshReport()
            CrystalReportViewer2.ShowFirstPage()

            ASPxPageControl1.TabPages(3).Text = docTitle
            ASPxPageControl1.TabPages(3).ClientVisible = True
            ASPxPageControl1.ActiveTabIndex = 3

        ElseIf ASPxPageControl1.TabPages(4).Text = "Empty Report 3" Then
            Try
                _crystalReport3 = New ReportDocument
                _crystalReport3.Load(reportPath, OpenReportMethod.OpenReportByTempCopy)
                ' Added to make sure it gets new data from the DB - JSL - 09/26/2007
                _crystalReport3.Refresh()
            Catch ex As Exception
                RSCommon.CreateTraceLogEntry(ex, "Home.LoadReport", "Error Loading Report 3")
                Return False
            End Try

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 3 loaded into CR Report document object")
                MyLog.Close()
            End If

            ' *****************************************************************************************************
            ' Check the connection to the data source for this report, including any sub-reports
            ' *****************************************************************************************************
            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteEntry("Home.LoadReport", "Check the DB Login", "Tables in report 3: " & _crystalReport3.Database.Tables.Count)
                MyLog.Close()
            End If

            CrystalReportHelper.DoDBLogIn(_crystalReport3.Database.Tables, docID)
            ' Set Login for any subreports
            CrystalReportHelper.SetDBLoginForSubReports(_crystalReport3)

            ' Check for Row Level Security and apply any found
            Dim recordSelection = _crystalReport3.DataDefinition.RecordSelectionFormula

            Dim oReportRowSecurity As New ReportRowSecurity(_crystalReport3.Database.Tables, foldername, oUser.ID, _crystalReport3.RecordSelectionFormula, oUser.UserLogin)

            _crystalReport3.RecordSelectionFormula = oReportRowSecurity.GetRowSecurity()

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 3 ready to be sent to viewer")
                MyLog.Close()
            End If

            CrystalReportParameter.FillRSDynamicParameters(docID, _crystalReport3, oUser)

            Session.Add("report3", _crystalReport3)

            If defaultViewer = "CRWebViewer" Then
                ' Only set the web viewer if that is the viewer being used
                SetReportViewerOptions(docID, 3)
            End If

            CrystalReportViewer3.ReportSource = _crystalReport3
            CrystalReportViewer3.RefreshReport()
            CrystalReportViewer3.ShowFirstPage()

            ASPxPageControl1.TabPages(4).Text = docTitle
            ASPxPageControl1.TabPages(4).ClientVisible = True
            ASPxPageControl1.ActiveTabIndex = 4

        ElseIf ASPxPageControl1.TabPages(5).Text = "Empty Report 4" Then
            Try
                _crystalReport4 = New ReportDocument
                _crystalReport4.Load(reportPath, OpenReportMethod.OpenReportByTempCopy)
                ' Added to make sure it gets new data from the DB - JSL - 09/26/2007
                _crystalReport4.Refresh()
            Catch ex As Exception
                RSCommon.CreateTraceLogEntry(ex, "Home.LoadReport", "Error Loading Report 4")
                Return False
            End Try

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 4 loaded into CR Report document object")
                MyLog.Close()
            End If

            ' *****************************************************************************************************
            ' Check the connection to the data source for this report, including any sub-reports
            ' *****************************************************************************************************
            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteEntry("Home.LoadReport", "Check the DB Login", "Tables in report 4: " & _crystalReport4.Database.Tables.Count)
                MyLog.Close()
            End If

            CrystalReportHelper.DoDBLogIn(_crystalReport4.Database.Tables, docID)
            ' Set Login for any subreports
            CrystalReportHelper.SetDBLoginForSubReports(_crystalReport4)

            ' Check for Row Level Security and apply any found
            Dim recordSelection = _crystalReport4.DataDefinition.RecordSelectionFormula

            Dim oReportRowSecurity As New ReportRowSecurity(_crystalReport4.Database.Tables, foldername, oUser.ID, _crystalReport4.RecordSelectionFormula, oUser.UserLogin)

            _crystalReport4.RecordSelectionFormula = oReportRowSecurity.GetRowSecurity()

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 4 ready to be sent to viewer")
                MyLog.Close()
            End If

            CrystalReportParameter.FillRSDynamicParameters(docID, _crystalReport4, oUser)

            Session.Add("report4", _crystalReport4)

            If defaultViewer = "CRWebViewer" Then
                ' Only set the web viewer if that is the viewer being used
                SetReportViewerOptions(docID, 4)
            End If

            CrystalReportViewer4.ReportSource = _crystalReport4
            CrystalReportViewer4.RefreshReport()
            CrystalReportViewer4.ShowFirstPage()

            ASPxPageControl1.TabPages(5).Text = docTitle
            ASPxPageControl1.TabPages(5).ClientVisible = True
            ASPxPageControl1.ActiveTabIndex = 5

        ElseIf ASPxPageControl1.TabPages(6).Text = "Empty Report 5" Then
            Try
                _crystalReport5 = New ReportDocument
                _crystalReport5.Load(reportPath, OpenReportMethod.OpenReportByTempCopy)
                ' Added to make sure it gets new data from the DB - JSL - 09/26/2007
                _crystalReport5.Refresh()
            Catch ex As Exception
                RSCommon.CreateTraceLogEntry(ex, "Home.LoadReport", "Error Loading Report 5")
                Return False
            End Try

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 5 loaded into CR Report document object")
                MyLog.Close()
            End If

            ' *****************************************************************************************************
            ' Check the connection to the data source for this report, including any sub-reports
            ' *****************************************************************************************************
            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteEntry("Home.LoadReport", "Check the DB Login", "Tables in report 5: " & _crystalReport5.Database.Tables.Count)
                MyLog.Close()
            End If

            CrystalReportHelper.DoDBLogIn(_crystalReport5.Database.Tables, docID)
            ' Set Login for any subreports
            CrystalReportHelper.SetDBLoginForSubReports(_crystalReport5)

            ' Check for Row Level Security and apply any found
            Dim recordSelection = _crystalReport5.DataDefinition.RecordSelectionFormula

            Dim oReportRowSecurity As New ReportRowSecurity(_crystalReport5.Database.Tables, foldername, oUser.ID, _crystalReport5.RecordSelectionFormula, oUser.UserLogin)

            _crystalReport5.RecordSelectionFormula = oReportRowSecurity.GetRowSecurity()

            If RSCommon.IsTraceLogOn = True Then
                Dim MyLog As New ICBLog
                MyLog.WriteComment("Home.aspx_LoadReport - Report 5 ready to be sent to viewer")
                MyLog.Close()
            End If

            CrystalReportParameter.FillRSDynamicParameters(docID, _crystalReport5, oUser)

            Session.Add("report5", _crystalReport5)

            If defaultViewer = "CRWebViewer" Then
                ' Only set the web viewer if that is the viewer being used
                SetReportViewerOptions(docID, 5)
            End If

            CrystalReportViewer5.ReportSource = _crystalReport5
            CrystalReportViewer5.RefreshReport()
            CrystalReportViewer5.ShowFirstPage()

            ASPxPageControl1.TabPages(6).Text = docTitle
            ASPxPageControl1.TabPages(6).ClientVisible = True
            ASPxPageControl1.ActiveTabIndex = 6

        Else
            ' Only 5 reports can be opened
        End If

        If RSCommon.IsTraceLogOn = True Then
            Dim MyLog As New ICBLog
            MyLog.WriteComment("Home.aspx_LoadReport - Report ready to be sent to viewer")
            MyLog.Close()
        End If

    End Function

#End Region

#Region " Load Ripplestone Report "

    Private Function LoadRipplestoneReport(ByVal docID As Integer) As Boolean

        Dim objDoc As Document
        objDoc = Document.GetDocumentByID(docID)

        Dim reportPath As String = objDoc.FilePath

        'Dim myDS As Object = myReport.DataSource

        'myReport.ExportToPdf("C:\Data\Test.pdf")

        If ASPxPageControl1.TabPages(7).Text = "Empty RS Report 1" Then

            Try
                _rsReport1 = New DevExpress.XtraReports.UI.XtraReport
                _rsReport1.LoadLayout(reportPath)
            Catch ex As Exception
                RSCommon.CreateTraceLogEntry(ex, "Home.LoadRSReport", "Error Loading RS Report 1")
                Return False
            End Try

            Session.Add("rsreport1", _rsReport1)

            webreportViewer1.OpenReport(_rsReport1)

            ASPxPageControl1.TabPages(7).Text = objDoc.Title
            ASPxPageControl1.TabPages(7).ClientVisible = True
            ASPxPageControl1.ActiveTabIndex = 7

        ElseIf ASPxPageControl1.TabPages(8).Text = "Empty RS Report 2" Then
            webreportViewer2.OpenReport(_rsReport2)

            ASPxPageControl1.TabPages(8).Text = objDoc.Title
            ASPxPageControl1.TabPages(8).ClientVisible = True
            ASPxPageControl1.ActiveTabIndex = 8

        End If

    End Function

#End Region

#Region " Load Excel Document "

    Private Function LoadExcelDocument(ByVal docID As Integer) As Boolean

        Try
            Dim objDoc As Document
            objDoc = Document.GetDocumentByID(docID)

            Dim documentPath As String = objDoc.FilePath

            If ASPxPageControl1.TabPages(9).Text = "Empty Excel 1" Then

                ASPxSpreadsheet1.Open(documentPath)

                ASPxPageControl1.TabPages(9).Text = objDoc.Title
                ASPxPageControl1.TabPages(9).ClientVisible = True
                ASPxPageControl1.ActiveTabIndex = 9

            End If
        Catch ex As Exception

        End Try

    End Function

#End Region

#Region " Load Word Document "

    Private Function LoadWordDocument(ByVal docID As Integer) As Boolean

        Try
            Dim objDoc As Document
            objDoc = Document.GetDocumentByID(docID)

            Dim documentPath As String = objDoc.FilePath

            If ASPxPageControl1.TabPages(9).Text = "Empty Excel 1" Then

                ASPxRichEdit1.Open(documentPath)

                ASPxPageControl1.TabPages(10).Text = objDoc.Title
                ASPxPageControl1.TabPages(10).ClientVisible = True
                ASPxPageControl1.ActiveTabIndex = 10
            End If
        Catch ex As Exception

        End Try


    End Function

#End Region

#Region " Crystal Report Viewer Events "

    Private Sub CrystalReportViewer1_Unload(sender As Object, e As EventArgs) Handles CrystalReportViewer1.Unload

        If hideDocID1.Value = "0" Then
            Exit Sub
        End If

        If hideDocID1.Value = "" Then
            Exit Sub
        End If

        If Session.Item("ReportExported1") IsNot Nothing Then
            If Session.Item("ReportExported1").ToString = "true" Then
                Exit Sub
            End If
        End If

        RipplestoneWeb.CommonWeb.CheckSendTo(_crystalReport1, CInt(hideDocID1.Value), 1)

    End Sub

    Private Sub CrystalReportViewer2_Unload(sender As Object, e As EventArgs) Handles CrystalReportViewer2.Unload

        If hideDocID2.Value = "0" Then
            Exit Sub
        End If

        If hideDocID2.Value = "" Then
            Exit Sub
        End If

        If Session.Item("ReportExported2") IsNot Nothing Then
            If Session.Item("ReportExported2").ToString = "true" Then
                Exit Sub
            End If
        End If

        RipplestoneWeb.CommonWeb.CheckSendTo(_crystalReport2, CInt(hideDocID2.Value), 2)

    End Sub

    Private Sub CrystalReportViewer3_Unload(sender As Object, e As EventArgs) Handles CrystalReportViewer3.Unload

        If HideDocID3.Value = "0" Then
            Exit Sub
        End If

        If HideDocID3.Value = "" Then
            Exit Sub
        End If

        If Session.Item("ReportExported3") IsNot Nothing Then
            If Session.Item("ReportExported3").ToString = "true" Then
                Exit Sub
            End If
        End If

        RipplestoneWeb.CommonWeb.CheckSendTo(_crystalReport3, CInt(HideDocID3.Value), 3)

    End Sub

    Private Sub CrystalReportViewer4_Unload(sender As Object, e As EventArgs) Handles CrystalReportViewer4.Unload

        If HideDocID4.Value = "0" Then
            Exit Sub
        End If

        If HideDocID4.Value = "" Then
            Exit Sub
        End If

        If Session.Item("ReportExported4") IsNot Nothing Then
            If Session.Item("ReportExported4").ToString = "true" Then
                Exit Sub
            End If
        End If

        RipplestoneWeb.CommonWeb.CheckSendTo(_crystalReport4, CInt(HideDocID4.Value), 4)

    End Sub

    Private Sub CrystalReportViewer5_Unload(sender As Object, e As EventArgs) Handles CrystalReportViewer5.Unload

        If HideDocID5.Value = "0" Then
            Exit Sub
        End If

        If HideDocID5.Value = "" Then
            Exit Sub
        End If

        If Session.Item("ReportExported5") IsNot Nothing Then
            If Session.Item("ReportExported5").ToString = "true" Then
                Exit Sub
            End If
        End If

        RipplestoneWeb.CommonWeb.CheckSendTo(_crystalReport5, CInt(HideDocID5.Value), 5)

    End Sub

#End Region

#Region " Crystal Reports Refresh Buttons "

    ' Changed code to refresh the viewer.  This will prompt for new parameters if the report has parameters.
    ' Jeff Lyon - 08/08/16 - version 3.7.1.4
    Private Sub aspxbtnReportRefresh1_Click(sender As Object, e As EventArgs) Handles aspxbtnReportRefresh1.Click

        CrystalReportViewer1.RefreshReport()

        ' Added to set the viewer toolbar option after a refresh
        ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
        If String.IsNullOrEmpty(hideDocID1.Value) = False Then
            SetReportViewerOptions(CInt(hideDocID1.Value), 1)
        End If

    End Sub

    Private Sub aspxbtnReportRefresh2_Click(sender As Object, e As EventArgs) Handles aspxbtnReportRefresh2.Click

        CrystalReportViewer2.RefreshReport()

        ' Added to set the viewer toolbar option after a refresh
        ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
        If String.IsNullOrEmpty(hideDocID2.Value) = False Then
            SetReportViewerOptions(CInt(hideDocID2.Value), 2)
        End If

    End Sub

    Private Sub aspxbtnReportRefresh3_Click(sender As Object, e As EventArgs) Handles aspxbtnReportRefresh3.Click

        CrystalReportViewer3.RefreshReport()

        ' Added to set the viewer toolbar option after a refresh
        ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
        If String.IsNullOrEmpty(HideDocID3.Value) = False Then
            SetReportViewerOptions(CInt(HideDocID3.Value), 3)
        End If

    End Sub

    Private Sub aspxbtnReportRefresh4_Click(sender As Object, e As EventArgs) Handles aspxbtnReportRefresh4.Click

        CrystalReportViewer4.RefreshReport()

        ' Added to set the viewer toolbar option after a refresh
        ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
        If String.IsNullOrEmpty(HideDocID4.Value) = False Then
            SetReportViewerOptions(CInt(HideDocID4.Value), 4)
        End If

    End Sub

    Private Sub aspxbtnReportRefresh5_Click(sender As Object, e As EventArgs) Handles aspxbtnReportRefresh5.Click

        CrystalReportViewer5.RefreshReport()

        ' Added to set the viewer toolbar option after a refresh
        ' Jeff Lyon - 02/14/2020 - version 3.20.2.1
        If String.IsNullOrEmpty(HideDocID5.Value) = False Then
            SetReportViewerOptions(CInt(HideDocID5.Value), 5)
        End If

    End Sub

#End Region

#Region " Delete Document "

    Private Sub DeleteDoc(ByVal documentID As Integer)

        Dim objDoc As Ripplestone.BLL.Document
        objDoc = Ripplestone.BLL.Document.GetDocumentByID(documentID)

        objDoc.DeleteDocumentByDocID(documentID)

        Dim objNode = RadTreeFolders.FindNodeByValue("D" & documentID)
        If objNode IsNot Nothing Then
            Dim objPrevNode = objNode.Prev
            If objPrevNode Is Nothing Then
                objPrevNode = objNode.ParentNode
            End If
            objNode.Remove()
            If objPrevNode IsNot Nothing Then
                objPrevNode.Selected = True
                ShowSelectedNode(objPrevNode)
            End If
        End If

    End Sub

#End Region

#Region " Documents Grid - Displayed on the right when a folder is clicked "

    Private Sub repeaterFolderDocuments_ItemCommand(source As Object, e As RepeaterCommandEventArgs) Handles repeaterFolderDocuments.ItemCommand

        If e.CommandName = "RunFolderImage" Or e.CommandName = "RunFolderLink" Then
            Dim docID As Integer = CInt(e.CommandArgument)
            LoadReport(docID, "RunDoc")
        End If

    End Sub

    ''' <summary>
    ''' Used by the Folder Repeater to determine if a Row is displayed
    ''' </summary>
    ''' <param name="IsActiveDocument"></param>
    ''' <returns></returns>
    ''' <history>
    ''' Added by Jeff Lyon - 7/3/2019 - version 3.9.6.2
    ''' </history>
    Public Function SetRowVisibility(ByVal IsActiveDocument As String) As String

        If IsActiveDocument = "True" Then
            Return "display:;" ' This will Display the row
        Else
            If _objUser Is Nothing Then
                FormsAuthentication.SignOut()
            ElseIf _objUser.IsSuperUser = True OrElse _objUser.IsAdministrator = True Then
                Return "display:;" ' This will Display the row
            Else
                Return "display:none;" ' This will hide the row
            End If
        End If

    End Function

#End Region

#Region " Ripplestone Report Events "

    Private Sub aspxbtnCloseRSReport1_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseRSReport1.Click

        Try
            ' Hides the RS Report 1 Tab
            ASPxPageControl1.TabPages(7).Text = "Empty RS Report 1"
            ASPxPageControl1.TabPages(7).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
            'ASPxDocumentViewer1 = Nothing
            webreportViewer1 = Nothing

        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.aspxbtnCloseRSReport1", "Error in aspxbtnCloseRSReport1_Click")
        End Try

    End Sub

    Private Sub aspxbtnCloseRSReport2_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseRSReport2.Click

        Try
            ' Hides the RS Report 2 Tab
            ASPxPageControl1.TabPages(8).Text = "Empty RS Report 2"
            ASPxPageControl1.TabPages(8).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
            'ASPxDocumentViewer2 = Nothing
            webreportViewer2 = Nothing
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.aspxbtnCloseRSReport2", "Error in aspxbtnCloseRSReport2_Click")
        End Try

    End Sub

    Private Sub aspxbtnCloseExcel1_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseExcel1.Click

        Try
            ' Hides the Excel 1 Tab
            ASPxPageControl1.TabPages(9).Text = "Empty Excel 1"
            ASPxPageControl1.TabPages(9).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.aspxbtnCloseExcel1", "Error in aspxbtnCloseExcel1_Click")
        End Try

    End Sub

    Private Sub aspxbtnCloseWord_Click(sender As Object, e As EventArgs) Handles aspxbtnCloseWord.Click

        Try
            ' Hides the Word 1 Tab
            ASPxPageControl1.TabPages(10).Text = "Empty Word 1"
            ASPxPageControl1.TabPages(10).ClientVisible = False
            ASPxPageControl1.ActiveTabIndex = 0
        Catch ex As Exception
            RSCommon.CreateTraceLogEntry(ex, "Home.aspxbtnCloseWord1", "Error in aspxbtnCloseWord1_Click")
        End Try

    End Sub


#End Region

End Class
