﻿<%@ Page Title="Row Level Security" Language="vb" AutoEventWireup="false" MasterPageFile="~/RSMasterPage.master" CodeBehind="RowSecurityNew.aspx.vb" Inherits="RSWebApp.RowSecurityNew" %>

<%@ Register Assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <script type="text/javascript">
        var isResetRequired = false;
        function onSelectedRoleChanged(s, e) {
            isResetRequired = true;
            gv.GetEditor("FolderID").PerformCallback(s.GetValue());
        }
        function onFolderCallBack(s, e) {
            if (isResetRequired) {
                isResetRequired = false;
                s.SetSelectedIndex(0);
            }
        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:ObjectDataSource ID="dataRowSecurity" runat="server" DeleteMethod="DeleteRowSecurityByID" SelectMethod="GetRowSecurity"
        TypeName="Ripplestone.BLL.RowSecurity" InsertMethod="InsertRowSecurityFromGrid" UpdateMethod="UpdateRowSecurityFromGrid">
        <DeleteParameters>
            <asp:Parameter Name="ID" Type="Int32" />
        </DeleteParameters>
        <InsertParameters>
            <asp:Parameter Name="RoleID" Type="Int32" />
            <asp:Parameter Name="FolderID" Type="Int32" />
            <asp:Parameter Name="Table" Type="String" />
            <asp:Parameter Name="Column" Type="String" />
            <asp:Parameter Name="RowOperator" Type="String" />
            <asp:Parameter Name="Value" Type="String" />
        </InsertParameters>
        <UpdateParameters>
            <asp:Parameter Name="ID" Type="Int32" />
            <asp:Parameter Name="RoleID" Type="Int32" />
            <asp:Parameter Name="FolderID" Type="Int32" />
            <asp:Parameter Name="Table" Type="String" />
            <asp:Parameter Name="Column" Type="String" />
            <asp:Parameter Name="RowOperator" Type="String" />
            <asp:Parameter Name="Value" Type="String" />
        </UpdateParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="dataRoles" runat="server" SelectMethod="GetSecurityRolesForGrid" TypeName="Ripplestone.BLL.SecurityRole"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="dataFolders" runat="server" SelectMethod="GetFoldersByRole" TypeName="Ripplestone.BLL.DocumentFolder">
        <SelectParameters>
            <asp:SessionParameter Name="RoleID" Type="Int32" DefaultValue="0" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="dataOperators" runat="server" SelectMethod="GetOperators" TypeName="Ripplestone.BLL.Operators"></asp:ObjectDataSource>
    <div class="nav2">
        <a class="nav2left" onclick="callHelp('RowSecurityHelp.htm')" href="javascript:void(0)">
            <img alt="Help" src="images/help3.gif" /></a> <span class="nav2title">Row Security</span>
        <a href="EditRowLevelSecurity.aspx?Mode=A" class="nav2right">Add New Row Security</a>
    </div>
    <div class="dataGrid">
        <dx:ASPxGridView ID="gridRowSecurity" runat="server" AutoGenerateColumns="False" DataSourceID="dataRowSecurity" KeyFieldName="ID" Width="100%"
            EnableCallbackAnimation="True" EnablePagingCallbackAnimation="True" ClientInstanceName="gv" OnCellEditorInitialize="grid_CellEditorInitialize">
            <SettingsDataSecurity AllowInsert="True" AllowEdit="True" AllowDelete="true" />
            <Styles AdaptiveDetailButtonWidth="22"></Styles>
            <SettingsContextMenu Enabled="True" />
            <SettingsPager PageSize="20">
                <PageSizeItemSettings ShowAllItem="True" Visible="True">
                </PageSizeItemSettings>
            </SettingsPager>
            <Settings ShowFilterRow="False" ShowGroupPanel="False" ShowFilterBar="Auto" ShowFilterRowMenu="True" />
            <SettingsBehavior ConfirmDelete="True" AllowSelectByRowClick="True" AllowSelectSingleRowOnly="True" EnableCustomizationWindow="True" />
            <SettingsSearchPanel Visible="True" ShowApplyButton="True" ShowClearButton="True" />
            <Columns>
                <dx:GridViewDataComboBoxColumn FieldName="RoleID" Caption="Role" VisibleIndex="0">
                    <PropertiesComboBox TextField="Role" ValueField="ID" ValueType="System.Int32" EnableSynchronization="False"
                        DataSecurityMode="Strict" IncrementalFilteringMode="StartsWith" DataSourceID="dataRoles">
                        <ClientSideEvents SelectedIndexChanged="onSelectedRoleChanged" />
                    </PropertiesComboBox>
                </dx:GridViewDataComboBoxColumn>
                <dx:GridViewDataComboBoxColumn FieldName="FolderID" Caption="Folder" VisibleIndex="1">
                    <PropertiesComboBox TextField="FolderName" ValueField="ID" ValueType="System.Int32" EnableSynchronization="False"
                        DataSecurityMode="Strict" IncrementalFilteringMode="StartsWith" DataSourceID="dataFolders">
                        <ClientSideEvents EndCallback="onFolderCallBack" />
                    </PropertiesComboBox>
                </dx:GridViewDataComboBoxColumn>
                <dx:GridViewDataTextColumn FieldName="Table" VisibleIndex="2">
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataTextColumn FieldName="Column" VisibleIndex="3">
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataComboBoxColumn Caption="Operator" FieldName="RowOperator" VisibleIndex="4">
                    <PropertiesComboBox TextField="AlertOperator" ValueField="AlertOperator" ValueType="System.String" EnableSynchronization="False"
                        DataSecurityMode="Strict" IncrementalFilteringMode="StartsWith" DataSourceID="dataOperators">
                    </PropertiesComboBox>
                </dx:GridViewDataComboBoxColumn>
                <dx:GridViewDataTextColumn FieldName="Value" VisibleIndex="5">
                </dx:GridViewDataTextColumn>
                <dx:GridViewCommandColumn ButtonType="Button" VisibleIndex="6" Width="50px" ShowCancelButton="True"
                    ShowClearFilterButton="True" ShowDeleteButton="True" ShowEditButton="True" ShowNewButtonInHeader="True" ShowUpdateButton="True">
                </dx:GridViewCommandColumn>
            </Columns>
        </dx:ASPxGridView>
    </div>
</asp:Content>
