﻿<%@ Page Title="Scheduled Groups" Language="vb" AutoEventWireup="false" MasterPageFile="~/RSMasterPage.master" CodeBehind="ScheduleGroups.aspx.vb" Inherits="RSWebApp.ScheduleGroups" %>
<%@ Register Assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <script type="text/javascript">
        function OnRowClick(s, e) {
            e.cancel = true;
        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="nav2">
		<a class="nav2left" onclick="callHelp('ReportSchedulingHelp.htm')" href="javascript:void(0)"><img alt="Help" src="images/help3.gif" /></a>
        <span class="nav2title">Scheduled Groups</span> 
        <a class="nav2right" href="EditScheduleGroup.aspx?Mode=A">Add New Scheduled Group</a>
	</div>
    <div>
        <asp:ObjectDataSource ID="dataScheduledGroups" runat="server" DeleteMethod="DeleteScheduleGroupByID" SelectMethod="GetScheduleGroups" TypeName="Ripplestone.BLL.ScheduleGroup">
            <DeleteParameters>
                <asp:Parameter Name="ID" Type="Int32" />
            </DeleteParameters>
        </asp:ObjectDataSource>
        <dx:ASPxGridView ID="gridScheduledGroups" runat="server" DataSourceID="dataScheduledGroups" AutoGenerateColumns="False" 
            KeyFieldName="ID" Width="100%" ClientInstanceName="gv" EnableCallbackAnimation="true" EnablePagingCallbackAnimation="true">
            <SettingsContextMenu Enabled="True">
            </SettingsContextMenu>
            <SettingsPager PageSize="20">
                <PageSizeItemSettings Visible="True">
                </PageSizeItemSettings>
            </SettingsPager>
            <Settings ShowFilterRow="True" ShowGroupPanel="True" ShowFilterBar="Auto" ShowFilterRowMenu="True" />
            <SettingsBehavior ConfirmDelete="True" AllowSelectByRowClick="True" AllowSelectSingleRowOnly="True" />
            <SettingsDataSecurity AllowEdit="False" AllowInsert="False" />
            <SettingsSearchPanel Visible="True" ShowApplyButton="True" ShowClearButton="True" />
            <Columns>
                <dx:GridViewDataTextColumn FieldName="ID" ReadOnly="True" VisibleIndex="0" Width="50px">
                    <EditFormSettings Visible="False" />
                    <HeaderStyle HorizontalAlign="Center">
                        <Paddings Padding="1px" />
                    </HeaderStyle>
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataTextColumn FieldName="GroupDescription" VisibleIndex="1" Caption="Group Name">
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataTextColumn FieldName="GroupFrequency" ReadOnly="True" VisibleIndex="2" Caption="Interval">
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataDateColumn FieldName="StartDateTime" VisibleIndex="3" Caption="Start Date">
                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                    </PropertiesDateEdit>
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                    <CellStyle Wrap="False">
                    </CellStyle>
                </dx:GridViewDataDateColumn>
                <dx:GridViewDataDateColumn FieldName="EndDate" VisibleIndex="5" Caption="End Date">
                </dx:GridViewDataDateColumn>
                <dx:GridViewDataDateColumn FieldName="LastExecutionDate" VisibleIndex="6" Caption="Last Run Date">
                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                    </PropertiesDateEdit>
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                    <CellStyle Wrap="False">
                    </CellStyle>
                </dx:GridViewDataDateColumn>
                <dx:GridViewDataDateColumn FieldName="NextRunDate" VisibleIndex="7" Caption="Next Run Date" Width="50px">
                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                    </PropertiesDateEdit>
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                    <CellStyle Wrap="False">
                    </CellStyle>
                </dx:GridViewDataDateColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="Run" VisibleIndex="8" Name="Run" Width="40px" ToolTip="Click to run this group now">
                    <CustomButtons>
                        <dx:GridViewCommandColumnCustomButton ID="btnRun" Text="Run" Visibility="AllDataRows">
                            <Image ToolTip="Click to run this group now" Url="~/Images/Run.gif" />
                        </dx:GridViewCommandColumnCustomButton>
                    </CustomButtons>
                    <HeaderStyle HorizontalAlign="Center">
                        <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="Edit" VisibleIndex="9" Name="Edit" Width="40px" ToolTip="Click to edit this group">
                    <CustomButtons>
                        <dx:GridViewCommandColumnCustomButton ID="btnEdit" Text="Edit" Visibility="AllDataRows">
                            <Image ToolTip="Click to edit this group" Url="~/Images/Edit.gif" />
                        </dx:GridViewCommandColumnCustomButton>
                    </CustomButtons>
                    <HeaderStyle HorizontalAlign="Center">
                        <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="Delete" Name="Delete" ShowClearFilterButton="True"
                    ShowDeleteButton="True" Width="40px" VisibleIndex="10" ToolTip="Click to delete this group">
                    <HeaderStyle HorizontalAlign="Center">
                        <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
            </Columns>
            <SettingsCommandButton>
                <ShowAdaptiveDetailButton ButtonType="Image"></ShowAdaptiveDetailButton>

                <HideAdaptiveDetailButton ButtonType="Image"></HideAdaptiveDetailButton>

                <DeleteButton>
                    <Image ToolTip="Delete this group?" Url="~/Images/Delete.gif" />
                </DeleteButton>
            </SettingsCommandButton>
            <Styles AdaptiveDetailButtonWidth="22"></Styles>
        </dx:ASPxGridView>
    </div>
	<div id="buttons">
        <dx:ASPxButton ID="btnReturn" runat="server" Text="Scheduled Reports" ToolTip="Return to Scheduled Reports"></dx:ASPxButton>&nbsp;
        <dx:ASPxLabel ID="lblGroupSubmitted" runat="server" Text="Group have been queued." ForeColor="#C00000" Visible="false"></dx:ASPxLabel>
	</div>
</asp:Content>
