﻿<%@ Page Language="VB" MasterPageFile="~/RSMasterPage.master" AutoEventWireup="false" Inherits="RSWebApp.ScheduledReports" Title="Scheduled Documents" Codebehind="ScheduledReports.aspx.vb" %>

<%@ Register assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" namespace="DevExpress.Web" tagprefix="dx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="Server">
	<div class="nav2">
		<a class="nav2left" onclick="callHelp('ReportSchedulingHelp.htm')" href="javascript:void(0)"><img alt="Help" src="images/help3.gif" /></a>
        <span class="nav2title">Scheduled Documents</span>
        <a id="newScheduledDocument" runat="server" class="nav2right" href="EditSchedule.aspx?Mode=A">Add New Scheduled Document</a>
	</div>
    <div class="topButtons">
        <dx:ASPxLabel ID="lblViews" runat="server" Text="Views"></dx:ASPxLabel>
		<asp:DropDownList ID="ddlViews" runat="server" Width="100px" AutoPostBack="False" Height="22px">
            <asp:ListItem Selected="True" Value="1">Job Queue</asp:ListItem>
            <asp:ListItem Value="2">Failed Jobs</asp:ListItem>
            <asp:ListItem Value="3">Last Jobs Run</asp:ListItem>
			<asp:ListItem Value="4">Schedule Log</asp:ListItem>
		</asp:DropDownList>&nbsp;
    	<asp:Button ID="btnOpenView" runat="server" Width="86px" Text="Open View"></asp:Button>
    </div>
    <div>
        <asp:Label ID="lblMessage" runat="server" Text="" ForeColor="Red"></asp:Label>
    </div>
    <div class="grid">
        <asp:ObjectDataSource ID="dataScheduledJobs" runat="server" DeleteMethod="DeleteScheduleJobByID" SelectMethod="GetScheduleJobs" TypeName="Ripplestone.BLL.ScheduleJob">
            <DeleteParameters>
                <asp:Parameter Name="ID" Type="Int32" />
            </DeleteParameters>
            <SelectParameters>
                <asp:SessionParameter DefaultValue="0" Name="userID" SessionField="UserID" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dataScheduleHistory" runat="server" SelectMethod="GetScheduleHistoryByJobID" TypeName="Ripplestone.BLL.ScheduleHistory" DeleteMethod="DeleteScheduleHistoryByHistoryID">
            <DeleteParameters>
                <asp:Parameter Name="historyID" Type="String" />
            </DeleteParameters>
            <SelectParameters>
                <asp:SessionParameter DefaultValue="0" Name="jobID" SessionField="JobID" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dataScheduleLog" runat="server" SelectMethod="GetScheduleLogByHistoryID" TypeName="Ripplestone.BLL.ScheduleLog">
            <SelectParameters>
                <asp:SessionParameter Name="historyID" SessionField="HistoryID" Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dataScheduleLogByJobID" runat="server" SelectMethod="GetScheduleLogByJobID" TypeName="Ripplestone.BLL.ScheduleLog">
            <SelectParameters>
                <asp:SessionParameter Name="jobID" SessionField="JobID" Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dataScheduleJob" runat="server" SelectMethod="GetScheduleJobByID" TypeName="Ripplestone.BLL.ScheduleJob">
            <SelectParameters>
                <asp:SessionParameter Name="jobID" SessionField="JobID" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <dx:ASPxGridView ID="gridScheduledJobs" runat="server" AutoGenerateColumns="False" DataSourceID="dataScheduledJobs" 
            KeyFieldName="ID" Width="100%" ClientInstanceName="gv" EnableCallbackAnimation="True" EnablePagingCallbackAnimation="True">
            <SettingsContextMenu Enabled="True" />
            <SettingsPager PageSize="20">
                <PageSizeItemSettings ShowAllItem="true" Visible="True">
                </PageSizeItemSettings>
            </SettingsPager>
            <Settings ShowFilterRow="True" ShowGroupPanel="True" ShowFilterBar="Auto" ShowFilterRowMenu="True" />
            <SettingsBehavior ConfirmDelete="True" AllowSelectByRowClick="True" AllowSelectSingleRowOnly="True" EnableCustomizationWindow="True" />
            <SettingsDataSecurity AllowEdit="False" AllowInsert="False" />
            <SettingsSearchPanel Visible="True" ShowApplyButton="True" ShowClearButton="True" />
            <SettingsDetail ShowDetailRow="true" />
            <Columns>
                <dx:GridViewDataTextColumn FieldName="ID" ReadOnly="True" VisibleIndex="0" Width="50px">
                    <EditFormSettings Visible="False" />
                    <HeaderStyle HorizontalAlign="Center">
                        <Paddings Padding="1px" />
                    </HeaderStyle>
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataTextColumn FieldName="JobDescription" VisibleIndex="1" Caption="Description">
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                    <CellStyle Wrap="False" />
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataTextColumn Caption="Folder" FieldName="Report.Folder.FolderName" VisibleIndex="2">
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataCheckColumn FieldName="Active" VisibleIndex="3" Caption="Active" Width="20px">
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>

                    <HeaderStyle HorizontalAlign="Center" >
                    <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle Wrap="False">
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewDataCheckColumn>
                <dx:GridViewDataTextColumn Caption="Interval" FieldName="ReportFrequency" VisibleIndex="4" Width="20px">
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                    <HeaderStyle>
                    <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle Wrap="False">
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataDateColumn FieldName="NextRunDate" VisibleIndex="5" Caption="Next Run Date" Width="50px">
                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                    </PropertiesDateEdit>
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                    <CellStyle Wrap="False">
                    </CellStyle>
                </dx:GridViewDataDateColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="Run" VisibleIndex="7" Name="Run" Width="40px" ToolTip="Click to have the job placed into the queue">
                    <CustomButtons>
                        <dx:GridViewCommandColumnCustomButton ID="btnRun" Text="Run" Visibility="AllDataRows">
                            <Image ToolTip="Click to run this job now" Url="~/Images/Run.gif" />
                        </dx:GridViewCommandColumnCustomButton>
                    </CustomButtons>
                    <HeaderStyle HorizontalAlign="Center" >
                    <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="Edit" VisibleIndex="8" Name="Edit" Width="40px" ToolTip="Click to edit this job">
                    <CustomButtons>
                        <dx:GridViewCommandColumnCustomButton ID="btnEdit" Text="Edit" Visibility="AllDataRows">
                            <Image ToolTip="Click to edit this job" Url="~/Images/Edit.gif" />
                        </dx:GridViewCommandColumnCustomButton>
                    </CustomButtons>
                    <HeaderStyle HorizontalAlign="Center" >
                    <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="Copy" VisibleIndex="9" Name="Copy" Width="40px" ToolTip="Click to create a copy of this job">
                    <CustomButtons>
                        <dx:GridViewCommandColumnCustomButton ID="btnCopy" Text="Copy" Visibility="AllDataRows">
                            <Image ToolTip="Click to copy this job" Url="~/Images/Copy.gif" />
                        </dx:GridViewCommandColumnCustomButton>
                    </CustomButtons>
                    <HeaderStyle HorizontalAlign="Center" >
                    <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="Delete" Name="Delete" ShowClearFilterButton="True"
                    ShowDeleteButton="True" Width="40px" VisibleIndex="10" ToolTip="Click to delete this job">
                    <HeaderStyle HorizontalAlign="Center" >
                    <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
                <dx:GridViewCommandColumn ButtonType="Image" Caption="History" VisibleIndex="11" Name="History" Width="40px" ToolTip="Click to view the history for this job">
                    <CustomButtons>
                        <dx:GridViewCommandColumnCustomButton ID="btnHistory" Text="History" Visibility="AllDataRows">
                            <Image ToolTip="Click to view this job's history" Url="~/Images/History.gif" />
                        </dx:GridViewCommandColumnCustomButton>
                    </CustomButtons>
                    <HeaderStyle HorizontalAlign="Center" >
                    <Paddings Padding="1px" />
                    </HeaderStyle>
                    <CellStyle>
                        <Paddings Padding="1px" />
                    </CellStyle>
                </dx:GridViewCommandColumn>
                <dx:GridViewDataDateColumn Caption="Start Date" FieldName="FullStartDate" ReadOnly="True" Visible="False" VisibleIndex="13" ToolTip="Date and time that the job will start">
                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                    </PropertiesDateEdit>
                    <SettingsHeaderFilter>
                        <DateRangePickerSettings EditFormatString=""></DateRangePickerSettings>
                    </SettingsHeaderFilter>
                    <CellStyle Wrap="False">
                    </CellStyle>
                </dx:GridViewDataDateColumn>
                <dx:GridViewDataDateColumn Caption="End Date" FieldName="EndDate" Visible="False" VisibleIndex="14" ToolTip="Date that the job will end">
                    <PropertiesDateEdit EditFormat="DateTime">
                    </PropertiesDateEdit>
                </dx:GridViewDataDateColumn>
                <dx:GridViewDataDateColumn Caption="Last Run Date" FieldName="LastExecutionDate" Visible="False" VisibleIndex="15" ToolTip="Date that the job was last run">
                    <PropertiesDateEdit EditFormat="DateTime">
                    </PropertiesDateEdit>
                </dx:GridViewDataDateColumn>
                <dx:GridViewDataCheckColumn Caption="Is Alert" FieldName="IsAlertReport" Visible="False" VisibleIndex="16">
                </dx:GridViewDataCheckColumn>
                <dx:GridViewDataTextColumn Caption="Report" FieldName="Report.FileName" ReadOnly="True" Visible="False" VisibleIndex="6" ToolTip="File name of the report">
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataTextColumn FieldName="Role.Role" ReadOnly="True" VisibleIndex="12" Visible="false" ToolTip="The role that the job will run under">
                </dx:GridViewDataTextColumn>
            </Columns>
            <Templates>
                <DetailRow>
                    <dx:ASPxPageControl ID="ASPxPageControl1" runat="server" ActiveTabIndex="0" TabSpacing="0px" Width="100%"
                        EnableClientSideAPI="True" ClientInstanceName="HomeTabs" EnableTheming="True">
                        <Paddings Padding="2px" PaddingLeft="5px" PaddingRight="5px"></Paddings>
                        <TabPages>
                            <dx:TabPage Name="tabGeneral" Text="General" ToolTip="General Information">
                                <ContentCollection>
                                    <dx:ContentControl>
                                        <div>
                                            <dx:ASPxLabel ID="ASPxlblJobID" runat="server" Text='<%# "Job ID: " & Eval("ID")%>'></dx:ASPxLabel>
                                        </div>
                                        <div>
                                            <dx:ASPxLabel ID="ASPxlblJobDescription" runat="server" Text='<%# "Job Description: " & Eval("JobDescription")%>'></dx:ASPxLabel>
                                        </div>
                                        <div>
                                            <dx:ASPxLabel ID="ASPxLabel1" runat="server" Text="Active: "></dx:ASPxLabel>
                                            <dx:ASPxCheckBox ID="ASPxchkActive" runat="server" ToolTip="Indicates if this job is currently active" Checked='<%# Eval("Active")%>' Enabled="false"></dx:ASPxCheckBox>
                                        </div>
                                        <div>
                                            <dx:ASPxLabel ID="ASPxlblLastExecution" runat="server" Text='<%# Eval("LastExecutionDateText")%>'></dx:ASPxLabel>
                                        </div>
                                        <div>
                                            <dx:ASPxLabel ID="ASPxlblCreated" runat="server" Text='<%# Eval("CreatedByText")%>'></dx:ASPxLabel>
                                        </div>
                                        <div>
                                            <dx:ASPxLabel ID="ASPxlblModified" runat="server" Text='<%# Eval("ModifiedByText")%>'></dx:ASPxLabel>
                                        </div>
                                    </dx:ContentControl>
                                </ContentCollection>
                            </dx:TabPage>
                            <dx:TabPage Name="tabHistory" Text="History" ToolTip="Scheduled Job History">
                                <ContentCollection>
                                    <dx:ContentControl ID="tabHistoryContent" runat="server" SupportsDisabledAttribute="True" Width="100%">
                                        <dx:ASPxGridView ID="gridHistory" runat="server" DataSourceID="dataScheduleHistory" KeyFieldName="HistoryID" Width="100%"
                                            OnBeforePerformDataSelect="gridHistory_BeforePerformDataSelect">
                                            <SettingsDetail ShowDetailRow="true" />
                                            <Columns>
                                                <dx:GridViewDataTextColumn Caption="Job Status" FieldName="Status" VisibleIndex="5">
                                                </dx:GridViewDataTextColumn>
                                                <dx:GridViewDataTextColumn Caption="Emailed To" FieldName="EmailedTo" VisibleIndex="10">
                                                </dx:GridViewDataTextColumn>
                                                <dx:GridViewDataDateColumn FieldName="StartTime" VisibleIndex="15" Caption="Execution Date" Width="50px">
                                                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime" />
                                                    <CellStyle Wrap="False">
                                                    </CellStyle>
                                                </dx:GridViewDataDateColumn>
                                                <dx:GridViewDataTextColumn Caption="Time to Execute" FieldName="ExecutionTime" VisibleIndex="20">
                                                </dx:GridViewDataTextColumn>
                                            </Columns>
                                            <Templates>
                                                <DetailRow>
                                                    <dx:ASPxGridView ID="gridLog" runat="server" AutoGenerateColumns="False" DataSourceID="dataScheduleLog" KeyFieldName="ID"
                                                        Width="100%" OnBeforePerformDataSelect="gridLog_BeforePerformDataSelect">
                                                        <Columns>
                                                            <dx:GridViewDataTextColumn FieldName="ID" VisibleIndex="5">
                                                            </dx:GridViewDataTextColumn>
                                                            <dx:GridViewDataTextColumn FieldName="HistoryID" VisibleIndex="10">
                                                            </dx:GridViewDataTextColumn>
                                                            <dx:GridViewDataTextColumn FieldName="Status" VisibleIndex="15">
                                                            </dx:GridViewDataTextColumn>
                                                            <dx:GridViewDataTextColumn FieldName="Notes" VisibleIndex="20">
                                                            </dx:GridViewDataTextColumn>
                                                            <dx:GridViewDataDateColumn FieldName="ModifiedDate" VisibleIndex="25" SortOrder="Ascending">
                                                                <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                                                                </PropertiesDateEdit>
                                                            </dx:GridViewDataDateColumn>
                                                        </Columns>
                                                    </dx:ASPxGridView>
                                                </DetailRow>
                                            </Templates>
                                        </dx:ASPxGridView>
                                    </dx:ContentControl>
                                </ContentCollection>
                            </dx:TabPage>
                            <dx:TabPage Name="tabLog" Text="Log" ToolTip="Scheduled Job Run Log">
                                <ContentCollection>
                                    <dx:ContentControl ID="tabLogContent" runat="server" SupportsDisabledAttribute="True" Width="100%">
                                        <dx:ASPxGridView ID="gridScheduleLogByJobID" runat="server" AutoGenerateColumns="False" DataSourceID="dataScheduleLogByJobID" KeyFieldName="ID"
                                            Width="100%">
                                            <SettingsPager PageSize="20">
                                                <PageSizeItemSettings Visible="True">
                                                </PageSizeItemSettings>
                                            </SettingsPager>
                                            <Settings ShowFilterRow="True" ShowGroupPanel="True" />
                                            <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                                            <SettingsSearchPanel Visible="True" />
                                            <Columns>
                                                <dx:GridViewDataTextColumn FieldName="ID" VisibleIndex="0" Width="50px">
                                                </dx:GridViewDataTextColumn>
                                                <dx:GridViewDataTextColumn FieldName="HistoryID" VisibleIndex="10" Width="150px">
                                                </dx:GridViewDataTextColumn>
                                                <dx:GridViewDataTextColumn FieldName="Status" VisibleIndex="15">
                                                </dx:GridViewDataTextColumn>
                                                <dx:GridViewDataTextColumn FieldName="Notes" VisibleIndex="20">
                                                </dx:GridViewDataTextColumn>
                                                <dx:GridViewDataDateColumn FieldName="ModifiedDate" VisibleIndex="25">
                                                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                                                    </PropertiesDateEdit>
                                                </dx:GridViewDataDateColumn>
                                            </Columns>
                                        </dx:ASPxGridView>
                                    </dx:ContentControl>
                                </ContentCollection>
                            </dx:TabPage>
                        </TabPages>
                    </dx:ASPxPageControl>
                </DetailRow>
            </Templates>
            <SettingsCommandButton>
                <ShowAdaptiveDetailButton ButtonType="Image"></ShowAdaptiveDetailButton>
                <HideAdaptiveDetailButton ButtonType="Image"></HideAdaptiveDetailButton>
                <DeleteButton>
                    <Image ToolTip="Delete this Job?" Url="~/Images/Delete.gif" />
                </DeleteButton>
            </SettingsCommandButton>
            <Styles AdaptiveDetailButtonWidth="22"></Styles>
        </dx:ASPxGridView>
        <dx:ASPxGridViewExporter ID="gridExport" runat="server">
        </dx:ASPxGridViewExporter>
    </div>
    <div id="buttons">
		<asp:Button ID="btnGroups" runat="server" Width="125px" Text="Scheduled Groups"></asp:Button>
	</div>
</asp:Content>
