<%@ Page Language="VB" MasterPageFile="~/RSMasterPage.master" AutoEventWireup="false" Inherits="RSWebApp.TraceLogs" Title="Trace Logs" Codebehind="TraceLogs.aspx.vb" %>

<%@ Register assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" namespace="DevExpress.Web" tagprefix="dx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="Server">
	<div class="nav2">
		<a class="nav2left" onclick="callHelp('ViewTraceLogHelp.htm')" href="javascript:void(0)">
			<img alt="Help" src="images/help3.gif" /></a> 
		<h3 class="nav2title">Trace Logs</h3>
		<span class="nav2right">
            <dx:ASPxButton ID="btnDeleteAllLogs" runat="server" Text="Delete All Logs" ToolTip="Delete all trace logs" OnClick="btnDeleteAllLogs_Click">
                <ClientSideEvents Click="function(s, e) {
	            e.processOnServer = confirm('Are you sure you want to delete ALL the trace logs?');
            }" />
            </dx:ASPxButton>
        </span>
	</div>
    <div>
        <asp:ObjectDataSource ID="dataTraceLogs" runat="server" SelectMethod="GetAllTraceLogs" TypeName="Ripplestone.BLL.TraceLog" DeleteMethod="DeleteFromFileSystem">
            <DeleteParameters>
                <asp:Parameter Name="fileName" Type="String" />
            </DeleteParameters>
        </asp:ObjectDataSource>
        <dx:ASPxGridView ID="gridTraceLogs" runat="server" AutoGenerateColumns="False" DataSourceID="dataTraceLogs" KeyFieldName="FileName" Width="100%">
            <SettingsDataSecurity AllowEdit="False" AllowInsert="False" />
            <SettingsSearchPanel Visible="True" />
            <SettingsBehavior ConfirmDelete="True" />
            <Columns>
                <dx:GridViewDataColumn Caption="Log File">
                    <DataItemTemplate>
                        <a href='<%# DataBinder.Eval(Container.DataItem, "Href") %>' runat="server" id="A1">
                            <%# DataBinder.Eval(Container.DataItem, "FileName") %>
                        </a>
                    </DataItemTemplate>
                </dx:GridViewDataColumn>
                <dx:GridViewDataColumn Caption="Download Log" VisibleIndex="5">
                    <DataItemTemplate>
                        <a href='<%# DataBinder.Eval(Container.DataItem, "DownloadHref") %>' runat="server" id="A2">Download Log</a>
                    </DataItemTemplate>
                </dx:GridViewDataColumn>
                <dx:GridViewCommandColumn ShowDeleteButton="True" VisibleIndex="7" Caption="Delete" ButtonRenderMode="Button">
                </dx:GridViewCommandColumn>
                <dx:GridViewDataTextColumn FieldName="FileSize" VisibleIndex="1" Caption="Size">
                    <CellStyle Wrap="False">
                    </CellStyle>
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataDateColumn FieldName="LastWriteTime" VisibleIndex="2" Caption="Last Modified">
                    <PropertiesDateEdit DisplayFormatString="" EditFormat="DateTime">
                    </PropertiesDateEdit>
                    <CellStyle Wrap="False">
                    </CellStyle>
                </dx:GridViewDataDateColumn>
            </Columns>
        </dx:ASPxGridView>
    </div>
</asp:Content>
