﻿<%@ Page Language="VB" MasterPageFile="~/RSMasterPage.master" AutoEventWireup="false" Inherits="RSWebApp.TrustedSystems" Title="Trusted Systems" Codebehind="TrustedSystems.aspx.vb" %>
<%@ Register Assembly="DevExpress.Web.v19.2, Version=19.2.5.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="Server">
	<div class="nav2">
		<a class="nav2left" onclick="callHelp('TrustedSystemHelp.htm')" href="javascript:void(0)">
			<img alt="Help" src="images/help3.gif" border="0" /></a> <span class="nav2title">Setup
				Trusted Systems</span>
	</div>
    <div>
        <asp:ObjectDataSource ID="dataTrustedSystems" runat="server" DeleteMethod="DeleteTrustedSystemBySystemName" InsertMethod="InsertTrustedSystem"
            SelectMethod="GetTrustedSystems" TypeName="Ripplestone.BLL.TrustedSystems" UpdateMethod="UpdateTrustedSystem" ConvertNullToDBNull="true">
            <DeleteParameters>
                <asp:Parameter Name="systemName" Type="String" />
            </DeleteParameters>
            <InsertParameters>
                <asp:Parameter Name="systemName" Type="String" />
                <asp:Parameter Name="returnURL" Type="String" ConvertEmptyStringToNull="false" />
            </InsertParameters>
            <UpdateParameters>
                <asp:Parameter Name="systemName" Type="String" />
                <asp:Parameter Name="returnURL" Type="String" ConvertEmptyStringToNull="false" />
            </UpdateParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dataTrustedUsers" runat="server" SelectMethod="GetTrustedUsers" TypeName="Ripplestone.BLL.TrustedUsers"
            DeleteMethod="DeleteTrustedUserByID" UpdateMethod="UpdateTrustedUserFromGrid" InsertMethod="InsertTrustedUser">
            <DeleteParameters>
                <asp:Parameter Name="ID" Type="Int32" />
            </DeleteParameters>
            <SelectParameters>
                <asp:SessionParameter Name="SystemName" SessionField="SystemName" Type="String" />
            </SelectParameters>
            <InsertParameters>
                <asp:SessionParameter Name="SystemName" SessionField="SystemName" Type="String" />
                <asp:Parameter Name="TrustedSystemUserID" Type="String" />
                <asp:Parameter Name="RipplestoneUserID" Type="Int32" />
            </InsertParameters>
            <UpdateParameters>
                <asp:Parameter Name="ID" Type="Int32" />
                <asp:Parameter Name="RipplestoneUserID" Type="Int32" />
                <asp:Parameter Name="TrustedSystemUserID" Type="String" />
            </UpdateParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dataUsers" runat="server" SelectMethod="GetAllUsers" TypeName="Ripplestone.BLL.User">
            <SelectParameters>
                <asp:SessionParameter Name="ID" Type="Int32" DefaultValue="0" />
            </SelectParameters>
        </asp:ObjectDataSource>

        <dx:ASPxGridView ID="grdTrustedSystems" runat="server" AutoGenerateColumns="False" DataSourceID="dataTrustedSystems" KeyFieldName="SystemName" 
            Width="100%" EnableCallbackAnimation="True" EnablePagingCallbackAnimation="True">
            <SettingsPager PageSize="20">
                <PageSizeItemSettings ShowAllItem="True" Visible="True">
                </PageSizeItemSettings>
            </SettingsPager>
            <Settings ShowFilterRow="False" ShowGroupPanel="False" ShowFilterBar="Auto" ShowFilterRowMenu="False" />
            <SettingsSearchPanel Visible="False" ShowApplyButton="True" ShowClearButton="True" />
            <SettingsDetail ShowDetailRow="true" />
            <Columns>
                <dx:GridViewDataTextColumn FieldName="SystemName" VisibleIndex="1" Width="50%">
                    <EditFormSettings Visible="False" />
                    <PropertiesTextEdit MaxLength="100">
                        <ValidationSettings SetFocusOnError="True">
                            <RequiredField ErrorText="Required Field" IsRequired="True" />
                        </ValidationSettings>
                    </PropertiesTextEdit>
                </dx:GridViewDataTextColumn>
                <dx:GridViewDataTextColumn FieldName="ReturnURL" VisibleIndex="2" Width="50%" >
                    <PropertiesTextEdit MaxLength="250" ConvertEmptyStringToNull="false">
                    </PropertiesTextEdit>
                </dx:GridViewDataTextColumn>
                <dx:GridViewCommandColumn ButtonType="Button" ShowDeleteButton="True" ShowEditButton="True" ShowNewButtonInHeader="True" VisibleIndex="6" Width="150px">
                </dx:GridViewCommandColumn>
            </Columns>
            <Templates>
                <DetailRow>
                    <dx:ASPxGridView ID="grdTrustedUsers" runat="server" AutoGenerateColumns="False" DataSourceID="dataTrustedUsers" KeyFieldName="ID"
                        Width="100%" OnBeforePerformDataSelect="grdTrustedUsers_BeforePerformDataSelect">
                        <Columns>
                            <dx:GridViewDataTextColumn FieldName="ID" VisibleIndex="5" Visible="false">
                                <EditFormSettings Visible="False" />                            
                            </dx:GridViewDataTextColumn>
                            <dx:GridViewDataTextColumn FieldName="TrustedSystemUserID" VisibleIndex="10">
                                <PropertiesTextEdit MaxLength="50">
                                </PropertiesTextEdit>
                            </dx:GridViewDataTextColumn>
                            <dx:GridViewDataComboBoxColumn FieldName="RipplestoneUserID" Caption="Reporting System User ID" VisibleIndex="20">
                                <PropertiesComboBox TextField="UserLogin" ValueField="ID" ValueType="System.Int32" EnableSynchronization="False" 
                                    DataSecurityMode="Strict" IncrementalFilteringMode="StartsWith" DataSourceID="dataUsers">
                                </PropertiesComboBox>
                            </dx:GridViewDataComboBoxColumn>
                            <dx:GridViewCommandColumn ButtonType="Button" ShowDeleteButton="True" ShowEditButton="True" ShowNewButtonInHeader="True" VisibleIndex="20" Width="150px">
                            </dx:GridViewCommandColumn>
                        </Columns>
                        <SettingsBehavior ConfirmDelete="True" />
                        <SettingsCommandButton>
                            <EditButton ButtonType="Button">
                            </EditButton>
                        </SettingsCommandButton>
                    </dx:ASPxGridView>
                </DetailRow>
            </Templates>
            <SettingsBehavior ConfirmDelete="True" />
            <SettingsCommandButton>
                <EditButton ButtonType="Button">
                </EditButton>
            </SettingsCommandButton>
        </dx:ASPxGridView>
    </div>
</asp:Content>
